/*
 * Decompiled with CFR 0.152.
 */
package potatowolfie.silly_goose.entity.goose.goals;

import java.util.EnumSet;
import net.minecraft.class_1352;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_3486;
import org.jetbrains.annotations.Nullable;
import potatowolfie.silly_goose.entity.goose.GooseEntity;

public class GooseWanderGoal
extends class_1352 {
    private final GooseEntity goose;
    private final double speed;
    private class_243 targetPos = null;
    private int navigationTimeout = 0;
    private int stuckCheckTimer = 0;
    private class_2338 lastPos = null;
    private boolean useDirectSwimming = false;
    private class_2338 nearestWaterPos = null;
    private int waterSearchCooldown = 0;
    private MovementMode currentMode = MovementMode.IDLE;
    private int modeTimer = 0;
    private static final int WATER_SEARCH_INTERVAL = 20;
    private static final int MAX_NAVIGATION_TIMEOUT = 100;
    private static final int STUCK_CHECK_INTERVAL = 20;
    private static final double STUCK_THRESHOLD = 1.0;
    private static final int IDLE_TIME_MIN = 20;
    private static final int IDLE_TIME_MAX = 60;
    private static final int WANDER_TIME_MIN = 80;
    private static final int WANDER_TIME_MAX = 200;

    public GooseWanderGoal(GooseEntity goose, double speed) {
        this.goose = goose;
        this.speed = speed;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
    }

    public boolean method_6264() {
        if (this.goose.method_6109()) {
            return false;
        }
        return !this.goose.method_5765();
    }

    public boolean method_6266() {
        return this.method_6264();
    }

    public void method_6269() {
        this.updateNearestWater();
        this.determineMovementMode();
    }

    public void method_6270() {
        this.goose.method_5942().method_6340();
        this.targetPos = null;
        this.currentMode = MovementMode.IDLE;
    }

    public void method_6268() {
        double distanceToWater;
        --this.waterSearchCooldown;
        if (this.waterSearchCooldown <= 0) {
            this.updateNearestWater();
            this.waterSearchCooldown = 20;
        }
        --this.stuckCheckTimer;
        if (this.stuckCheckTimer <= 0) {
            this.checkIfStuck();
            this.stuckCheckTimer = 20;
        }
        if (this.goose.method_5799()) {
            if (!this.useDirectSwimming && this.targetPos != null) {
                this.useDirectSwimming = true;
                this.goose.method_5942().method_6340();
            }
        } else if (this.useDirectSwimming) {
            this.useDirectSwimming = false;
        }
        if (this.nearestWaterPos != null && (distanceToWater = this.goose.method_24515().method_10262((class_2382)this.nearestWaterPos)) > 256.0) {
            this.currentMode = MovementMode.RETURNING;
            this.modeTimer = 0;
        }
        if (this.goose.shouldReturnToPreference()) {
            this.handleReturnToPreference();
            return;
        }
        ++this.modeTimer;
        switch (this.currentMode.ordinal()) {
            case 0: {
                this.handleIdleMode();
                break;
            }
            case 1: {
                this.handleWanderingMode();
                break;
            }
            case 2: {
                this.handleSeekingWaterMode();
                break;
            }
            case 3: {
                this.handleSeekingLandMode();
                break;
            }
            case 4: {
                this.handleReturningMode();
            }
        }
        if (this.targetPos != null) {
            --this.navigationTimeout;
            double distanceToTarget = this.goose.method_73189().method_1022(this.targetPos);
            if (distanceToTarget < 2.0) {
                this.targetPos = null;
                this.goose.method_5942().method_6340();
                this.useDirectSwimming = false;
                this.transitionToMode(MovementMode.IDLE);
                return;
            }
            if (this.useDirectSwimming) {
                this.handleDirectSwimming();
            } else if (this.navigationTimeout % 20 == 0 && distanceToTarget > 3.0) {
                this.goose.method_5942().method_6337(this.targetPos.field_1352, this.targetPos.field_1351, this.targetPos.field_1350, this.speed);
            }
            if (this.navigationTimeout <= 0) {
                this.targetPos = null;
                this.goose.method_5942().method_6340();
                this.useDirectSwimming = false;
                this.transitionToMode(MovementMode.IDLE);
            }
        }
    }

    private void handleDirectSwimming() {
        float yawDiff;
        double targetYaw;
        if (this.targetPos == null) {
            return;
        }
        class_243 currentPos = this.goose.method_73189();
        class_243 direction = this.targetPos.method_1020(currentPos).method_1029();
        float currentYaw = this.goose.method_36454();
        for (targetYaw = Math.atan2(-direction.field_1352, direction.field_1350) * 57.29577951308232; targetYaw > 180.0; targetYaw -= 360.0) {
        }
        while (targetYaw < -180.0) {
            targetYaw += 360.0;
        }
        while (currentYaw > 180.0f) {
            currentYaw -= 360.0f;
        }
        while (currentYaw < -180.0f) {
            currentYaw += 360.0f;
        }
        for (yawDiff = (float)(targetYaw - (double)currentYaw); yawDiff > 180.0f; yawDiff -= 360.0f) {
        }
        while (yawDiff < -180.0f) {
            yawDiff += 360.0f;
        }
        float maxRotation = 15.0f;
        float yawAdjustment = Math.max(-maxRotation, Math.min(maxRotation, yawDiff));
        float newYaw = currentYaw + yawAdjustment;
        this.goose.method_36456(newYaw);
        this.goose.method_5636(newYaw);
        this.goose.method_5847(newYaw);
        if (Math.abs(yawDiff) < 45.0f) {
            double swimSpeed = this.speed * 0.15;
            class_243 velocity = this.goose.method_18798();
            this.goose.method_18800(direction.field_1352 * swimSpeed, velocity.field_1351, direction.field_1350 * swimSpeed);
            this.goose.field_6037 = true;
        } else {
            class_243 velocity = this.goose.method_18798();
            this.goose.method_18800(velocity.field_1352 * 0.5, velocity.field_1351, velocity.field_1350 * 0.5);
            this.goose.field_6037 = true;
        }
    }

    private void handleReturnToPreference() {
        class_243 landPos;
        boolean prefersWater = this.goose.getPrefersWater();
        boolean inWater = this.goose.method_5799();
        if (prefersWater && !inWater) {
            if (this.nearestWaterPos != null) {
                this.setTarget(class_243.method_24955((class_2382)this.nearestWaterPos));
                this.currentMode = MovementMode.SEEKING_WATER;
            }
        } else if (!prefersWater && inWater && (landPos = this.findLandNearWater()) != null) {
            this.setTarget(landPos);
            this.currentMode = MovementMode.SEEKING_LAND;
        }
    }

    private void handleIdleMode() {
        int idleDuration = 20 + this.goose.method_59922().method_43048(40);
        if (this.modeTimer >= idleDuration) {
            this.determineMovementMode();
        }
    }

    private void handleWanderingMode() {
        boolean prefersWater = this.goose.getPrefersWater();
        boolean inWater = this.goose.method_5799();
        if (this.targetPos == null) {
            class_243 wanderTarget = this.findWanderTarget();
            if (wanderTarget != null) {
                this.setTarget(wanderTarget);
            } else {
                this.transitionToMode(MovementMode.IDLE);
            }
        }
        if (this.modeTimer > 40 && this.goose.method_59922().method_43057() < 0.02f) {
            this.transitionToMode(MovementMode.IDLE);
        }
        if (this.modeTimer > 60 && this.goose.method_59922().method_43057() < 0.3f) {
            this.targetPos = null;
        }
    }

    private void handleSeekingWaterMode() {
        boolean inWater = this.goose.method_5799();
        if (inWater) {
            this.targetPos = null;
            this.transitionToMode(MovementMode.WANDERING);
            return;
        }
        if (this.targetPos == null || this.nearestWaterPos == null) {
            this.updateNearestWater();
            if (this.nearestWaterPos != null) {
                this.setTarget(class_243.method_24955((class_2382)this.nearestWaterPos));
            } else {
                this.transitionToMode(MovementMode.IDLE);
            }
        }
        if (this.modeTimer > 200) {
            this.transitionToMode(MovementMode.IDLE);
        }
    }

    private void handleSeekingLandMode() {
        boolean inWater = this.goose.method_5799();
        if (!inWater && this.goose.method_24828()) {
            this.targetPos = null;
            this.transitionToMode(MovementMode.WANDERING);
            return;
        }
        if (this.targetPos == null) {
            class_243 landPos = this.findLandNearWater();
            if (landPos != null) {
                this.setTarget(landPos);
            } else {
                this.transitionToMode(MovementMode.IDLE);
            }
        }
        if (this.modeTimer > 200) {
            this.transitionToMode(MovementMode.IDLE);
        }
    }

    private void handleReturningMode() {
        if (this.nearestWaterPos == null) {
            this.updateNearestWater();
        }
        if (this.nearestWaterPos != null) {
            double distanceToWater = this.goose.method_24515().method_10262((class_2382)this.nearestWaterPos);
            if (distanceToWater <= 256.0) {
                this.targetPos = null;
                this.determineMovementMode();
                return;
            }
            boolean prefersWater = this.goose.getPrefersWater();
            if (prefersWater) {
                this.setTarget(class_243.method_24955((class_2382)this.nearestWaterPos));
            } else {
                class_243 landPos = this.findLandNearWater();
                if (landPos != null) {
                    this.setTarget(landPos);
                } else {
                    this.setTarget(class_243.method_24955((class_2382)this.nearestWaterPos));
                }
            }
        }
    }

    private void determineMovementMode() {
        double distanceToWater;
        if (this.nearestWaterPos == null) {
            this.updateNearestWater();
        }
        if (this.nearestWaterPos != null && (distanceToWater = this.goose.method_24515().method_10262((class_2382)this.nearestWaterPos)) > 256.0) {
            this.transitionToMode(MovementMode.RETURNING);
            return;
        }
        boolean prefersWater = this.goose.getPrefersWater();
        boolean inWater = this.goose.method_5799();
        if (prefersWater) {
            if (!inWater) {
                if (this.goose.method_59922().method_43057() < 0.7f) {
                    this.transitionToMode(MovementMode.SEEKING_WATER);
                } else {
                    this.transitionToMode(this.goose.method_59922().method_43056() ? MovementMode.IDLE : MovementMode.WANDERING);
                }
            } else {
                this.transitionToMode(this.goose.method_59922().method_43057() < 0.85f ? MovementMode.WANDERING : MovementMode.IDLE);
            }
        } else if (inWater) {
            if (this.goose.method_59922().method_43057() < 0.8f) {
                this.transitionToMode(MovementMode.SEEKING_LAND);
            } else {
                this.transitionToMode(this.goose.method_59922().method_43057() < 0.7f ? MovementMode.WANDERING : MovementMode.IDLE);
            }
        } else {
            this.transitionToMode(this.goose.method_59922().method_43057() < 0.85f ? MovementMode.WANDERING : MovementMode.IDLE);
        }
    }

    private void transitionToMode(MovementMode newMode) {
        this.currentMode = newMode;
        this.modeTimer = 0;
        this.targetPos = null;
        this.useDirectSwimming = false;
        this.goose.method_5942().method_6340();
    }

    @Nullable
    private class_243 findWanderTarget() {
        boolean prefersWater = this.goose.getPrefersWater();
        boolean inWater = this.goose.method_5799();
        if (prefersWater && inWater || !prefersWater && !inWater) {
            return this.findNearbyWanderPos();
        }
        if (this.goose.method_59922().method_43057() < 0.3f) {
            return this.findNearbyWanderPos();
        }
        if (prefersWater) {
            return this.nearestWaterPos != null ? class_243.method_24955((class_2382)this.nearestWaterPos) : this.findNearbyWanderPos();
        }
        class_243 landPos = this.findLandNearWater();
        return landPos != null ? landPos : this.findNearbyWanderPos();
    }

    @Nullable
    private class_243 findNearbyWanderPos() {
        boolean prefersWater = this.goose.getPrefersWater();
        for (int attempt = 0; attempt < 10; ++attempt) {
            boolean targetIsWater;
            double distance = 8.0 + this.goose.method_59922().method_43058() * 4.0;
            double angle = this.goose.method_59922().method_43058() * Math.PI * 2.0;
            double randomX = this.goose.method_23317() + Math.cos(angle) * distance;
            double randomZ = this.goose.method_23321() + Math.sin(angle) * distance;
            class_2338 targetBlockPos = class_2338.method_49637((double)randomX, (double)this.goose.method_23318(), (double)randomZ);
            if (this.nearestWaterPos != null && targetBlockPos.method_10262((class_2382)this.nearestWaterPos) > 256.0 || prefersWater != (targetIsWater = this.goose.method_73183().method_8316(targetBlockPos).method_15767(class_3486.field_15517))) continue;
            double targetY = this.goose.method_23318();
            if (targetIsWater) {
                class_2338 checkPos = targetBlockPos;
                while (this.goose.method_73183().method_8316(checkPos).method_15767(class_3486.field_15517)) {
                    targetY = (double)checkPos.method_10264() + 1.0;
                    checkPos = checkPos.method_10084();
                }
            } else {
                targetY = this.goose.method_23318() + (this.goose.method_59922().method_43058() - 0.5) * 2.0;
            }
            return new class_243(randomX, targetY, randomZ);
        }
        return null;
    }

    @Nullable
    private class_243 findLandNearWater() {
        if (this.nearestWaterPos == null) {
            return null;
        }
        for (int attempt = 0; attempt < 15; ++attempt) {
            class_2338 landPos = this.nearestWaterPos.method_10069(this.goose.method_59922().method_43048(17) - 8, this.goose.method_59922().method_43048(5) - 2, this.goose.method_59922().method_43048(17) - 8);
            if (this.goose.method_73183().method_8316(landPos).method_15767(class_3486.field_15517) || !this.goose.method_73183().method_8320(landPos.method_10074()).method_51367()) continue;
            return class_243.method_24955((class_2382)landPos);
        }
        return null;
    }

    private void updateNearestWater() {
        class_2338 goosePos = this.goose.method_24515();
        class_2338 nearest = null;
        double nearestDistance = Double.MAX_VALUE;
        for (class_2338 pos : class_2338.method_10097((class_2338)goosePos.method_10069(-32, -16, -32), (class_2338)goosePos.method_10069(32, 16, 32))) {
            double distance;
            if (!this.goose.method_73183().method_8316(pos).method_15767(class_3486.field_15517) || !((distance = goosePos.method_10262((class_2382)pos)) < nearestDistance)) continue;
            nearestDistance = distance;
            nearest = pos.method_10062();
        }
        this.nearestWaterPos = nearest;
    }

    private void setTarget(class_243 target) {
        this.targetPos = target;
        this.navigationTimeout = 100;
        if (this.goose.method_5799()) {
            this.useDirectSwimming = true;
            this.goose.method_5942().method_6340();
        } else {
            this.useDirectSwimming = false;
            this.goose.method_5942().method_6337(target.field_1352, target.field_1351, target.field_1350, this.speed);
        }
    }

    private void checkIfStuck() {
        double distanceMoved;
        class_2338 currentPos = this.goose.method_24515();
        if (this.lastPos != null && this.targetPos != null && (distanceMoved = currentPos.method_10262((class_2382)this.lastPos)) < 1.0) {
            this.targetPos = null;
            this.goose.method_5942().method_6340();
            this.transitionToMode(MovementMode.IDLE);
        }
        this.lastPos = currentPos.method_10062();
    }

    public static enum MovementMode {
        IDLE,
        WANDERING,
        SEEKING_WATER,
        SEEKING_LAND,
        RETURNING;

    }
}

