/*
 * Decompiled with CFR 0.152.
 */
package axdev.magicconstruction.basics;

import axdev.magicconstruction.basics.ConfigServer;
import axdev.magicconstruction.items.ItemRepairRune;
import axdev.magicconstruction.items.wand.ItemWand;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.AnvilUpdateEvent;

@EventBusSubscriber(modid="magicconstruction")
public class AnvilEvents {
    @SubscribeEvent
    public static void onAnvilUpdate(AnvilUpdateEvent event) {
        if (!((Boolean)ConfigServer.RUNES_ENABLED.get()).booleanValue()) {
            return;
        }
        ItemStack left = event.getLeft();
        ItemStack right = event.getRight();
        Item item = right.getItem();
        if (item instanceof ItemRepairRune) {
            boolean canRepair;
            ItemRepairRune rune = (ItemRepairRune)item;
            boolean isWand = left.getItem() instanceof ItemWand;
            boolean bl = canRepair = isWand || (Boolean)ConfigServer.RUNES_WAND_ONLY.get() == false;
            if (!canRepair || !left.isDamageableItem()) {
                return;
            }
            int maxDamage = left.getMaxDamage();
            int currentDamage = left.getDamageValue();
            if (currentDamage == 0) {
                return;
            }
            double repairPercent = rune.getRepairPercent() >= 1.0f ? (Double)ConfigServer.RUNE_MAJOR_REPAIR_PERCENT.get() : (Double)ConfigServer.RUNE_MINOR_REPAIR_PERCENT.get();
            int xpCost = rune.getRepairPercent() >= 1.0f ? (Integer)ConfigServer.RUNE_MAJOR_XP_COST.get() : (Integer)ConfigServer.RUNE_MINOR_XP_COST.get();
            int repairAmount = (int)((double)maxDamage * repairPercent);
            int newDamage = Math.max(0, currentDamage - repairAmount);
            ItemStack result = left.copy();
            result.setDamageValue(newDamage);
            event.setOutput(result);
            event.setCost((long)xpCost);
            event.setMaterialCost(1);
        }
    }
}

