/*
 * Decompiled with CFR 0.152.
 */
package axdev.magicconstruction.basics;

import axdev.magicconstruction.MagicConstruction;
import axdev.magicconstruction.basics.ConfigServer;
import axdev.magicconstruction.basics.ReplacementRegistry;
import axdev.magicconstruction.containers.ContainerManager;
import axdev.magicconstruction.items.wand.ItemWand;
import axdev.magicconstruction.wand.WandItemUseContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.util.BlockSnapshot;
import net.neoforged.neoforge.event.level.BlockEvent;

public class WandUtil {
    public static boolean stackEquals(ItemStack stackA, ItemStack stackB) {
        return ItemStack.isSameItemSameComponents((ItemStack)stackA, (ItemStack)stackB);
    }

    public static boolean stackEquals(ItemStack stackA, Item item) {
        ItemStack stackB = new ItemStack((ItemLike)item);
        return WandUtil.stackEquals(stackA, stackB);
    }

    public static ItemStack holdingWand(Player player) {
        if (player.getItemInHand(InteractionHand.MAIN_HAND) != ItemStack.EMPTY && player.getItemInHand(InteractionHand.MAIN_HAND).getItem() instanceof ItemWand) {
            return player.getItemInHand(InteractionHand.MAIN_HAND);
        }
        if (player.getItemInHand(InteractionHand.OFF_HAND) != ItemStack.EMPTY && player.getItemInHand(InteractionHand.OFF_HAND).getItem() instanceof ItemWand) {
            return player.getItemInHand(InteractionHand.OFF_HAND);
        }
        return null;
    }

    public static BlockPos posFromVec(Vec3 vec) {
        return new BlockPos((int)Math.round(vec.x), (int)Math.round(vec.y), (int)Math.round(vec.z));
    }

    public static Vec3 entityPositionVec(Entity entity) {
        return new Vec3(entity.getX(), entity.getY() + (double)(entity.getBbHeight() / 2.0f), entity.getZ());
    }

    public static Vec3 blockPosVec(BlockPos pos) {
        return new Vec3((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
    }

    public static List<ItemStack> getHotbar(Player player) {
        return player.getInventory().items.subList(0, 9);
    }

    public static List<ItemStack> getHotbarWithOffhand(Player player) {
        ArrayList<ItemStack> inventory = new ArrayList<ItemStack>(player.getInventory().items.subList(0, 9));
        inventory.addAll((Collection<ItemStack>)player.getInventory().offhand);
        return inventory;
    }

    public static List<ItemStack> getMainInv(Player player) {
        return player.getInventory().items.subList(9, player.getInventory().items.size());
    }

    public static List<ItemStack> getFullInv(Player player) {
        ArrayList<ItemStack> inventory = new ArrayList<ItemStack>((Collection<ItemStack>)player.getInventory().offhand);
        inventory.addAll((Collection<ItemStack>)player.getInventory().items);
        return inventory;
    }

    public static int blockDistance(BlockPos p1, BlockPos p2) {
        return Math.max(Math.abs(p1.getX() - p2.getX()), Math.abs(p1.getZ() - p2.getZ()));
    }

    public static boolean isTEAllowed(BlockState state) {
        if (!state.hasBlockEntity()) {
            return true;
        }
        ResourceLocation name = BuiltInRegistries.BLOCK.getKey((Object)state.getBlock());
        if (name == null) {
            return false;
        }
        String fullId = name.toString();
        String modId = name.getNamespace();
        boolean inList = ((List)ConfigServer.TE_LIST.get()).contains(fullId) || ((List)ConfigServer.TE_LIST.get()).contains(modId);
        boolean isWhitelist = (Boolean)ConfigServer.TE_WHITELIST.get();
        return isWhitelist == inList;
    }

    public static boolean placeBlock(Level world, Player player, BlockState block, BlockPos pos, @Nullable BlockItem item) {
        ItemStack stack;
        if (!world.setBlockAndUpdate(pos, block)) {
            MagicConstruction.LOGGER.info("Block could not be placed");
            return false;
        }
        BlockSnapshot snapshot = BlockSnapshot.create((ResourceKey)world.dimension(), (LevelAccessor)world, (BlockPos)pos);
        BlockEvent.EntityPlaceEvent placeEvent = new BlockEvent.EntityPlaceEvent(snapshot, block, (Entity)player);
        NeoForge.EVENT_BUS.post((Event)placeEvent);
        if (placeEvent.isCanceled()) {
            world.removeBlock(pos, false);
            return false;
        }
        if (item == null) {
            stack = new ItemStack((ItemLike)block.getBlock().asItem());
        } else {
            stack = new ItemStack((ItemLike)item);
            player.awardStat(Stats.ITEM_USED.get((Object)item));
        }
        block.getBlock().setPlacedBy(world, pos, block, (LivingEntity)player, stack);
        return true;
    }

    public static boolean removeBlock(Level world, Player player, @Nullable BlockState block, BlockPos pos) {
        BlockState currentBlock = world.getBlockState(pos);
        if (!world.mayInteract(player, pos)) {
            return false;
        }
        if (!player.isCreative()) {
            if (currentBlock.getDestroySpeed((BlockGetter)world, pos) <= -1.0f || world.getBlockEntity(pos) != null) {
                return false;
            }
            if (block != null && !ReplacementRegistry.matchBlocks(currentBlock.getBlock(), block.getBlock())) {
                return false;
            }
        }
        BlockEvent.BreakEvent breakEvent = new BlockEvent.BreakEvent(world, pos, currentBlock, player);
        NeoForge.EVENT_BUS.post((Event)breakEvent);
        if (breakEvent.isCanceled()) {
            return false;
        }
        world.removeBlock(pos, false);
        return true;
    }

    public static int countItem(Player player, Item item) {
        if (player.getInventory().items == null) {
            return 0;
        }
        if (player.isCreative()) {
            return Integer.MAX_VALUE;
        }
        int total = 0;
        ContainerManager containerManager = MagicConstruction.instance.containerManager;
        List<ItemStack> inventory = WandUtil.getFullInv(player);
        for (ItemStack stack : inventory) {
            if (stack == null || stack.isEmpty()) continue;
            if (WandUtil.stackEquals(stack, item)) {
                total += stack.getCount();
                continue;
            }
            int amount = containerManager.countItems(player, new ItemStack((ItemLike)item), stack);
            if (amount == Integer.MAX_VALUE) {
                return Integer.MAX_VALUE;
            }
            total += amount;
        }
        return total;
    }

    private static boolean isPositionModifiable(Level world, Player player, BlockPos pos) {
        if (!world.isInWorldBounds(pos)) {
            return false;
        }
        if (!world.mayInteract(player, pos)) {
            return false;
        }
        return (Integer)ConfigServer.MAX_RANGE.get() <= 0 || WandUtil.blockDistance(player.blockPosition(), pos) <= (Integer)ConfigServer.MAX_RANGE.get();
    }

    public static boolean isPositionPlaceable(Level world, Player player, BlockPos pos, boolean replace) {
        if (!WandUtil.isPositionModifiable(world, player, pos)) {
            return false;
        }
        if (world.isEmptyBlock(pos)) {
            return true;
        }
        return replace && world.getBlockState(pos).canBeReplaced((BlockPlaceContext)new WandItemUseContext(world, player, new BlockHitResult(new Vec3(0.0, 0.0, 0.0), Direction.DOWN, pos, false), pos, (BlockItem)Items.STONE));
    }

    public static boolean isBlockRemovable(Level world, Player player, BlockPos pos) {
        if (!WandUtil.isPositionModifiable(world, player, pos)) {
            return false;
        }
        if (!player.isCreative()) {
            return !(world.getBlockState(pos).getDestroySpeed((BlockGetter)world, pos) <= -1.0f) && world.getBlockEntity(pos) == null;
        }
        return true;
    }

    public static boolean isBlockPermeable(Level world, BlockPos pos) {
        return world.isEmptyBlock(pos) || world.getBlockState(pos).getCollisionShape((BlockGetter)world, pos).isEmpty();
    }

    public static boolean entitiesCollidingWithBlock(Level world, BlockState blockState, BlockPos pos) {
        VoxelShape shape = blockState.getCollisionShape((BlockGetter)world, pos);
        if (!shape.isEmpty()) {
            AABB blockBB = shape.bounds().move(pos);
            return !world.getEntitiesOfClass(LivingEntity.class, blockBB, Predicate.not(Entity::isSpectator)).isEmpty();
        }
        return false;
    }

    public static Direction fromVector(Vec3 vector) {
        return Direction.getNearest((double)vector.x, (double)vector.y, (double)vector.z);
    }
}

