/*
 * Decompiled with CFR 0.152.
 */
package axdev.magicconstruction.client;

import axdev.magicconstruction.basics.WandUtil;
import axdev.magicconstruction.client.ModKeyBindings;
import axdev.magicconstruction.network.ModMessages;
import axdev.magicconstruction.network.PacketUndo;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.InputEvent;

public class ClientEvents {
    private boolean lastModifierState = false;

    @SubscribeEvent
    public void onMouseInput(InputEvent.MouseButton.Pre event) {
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player == null) {
            return;
        }
        if (mc.screen != null) {
            return;
        }
        if (WandUtil.holdingWand((Player)player) == null) {
            return;
        }
        if (!ClientEvents.isModifierDown()) {
            return;
        }
        if (event.getAction() == 1 && ModKeyBindings.UNDO.matchesMouse(event.getButton())) {
            ModMessages.sendToServer(new PacketUndo());
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onKeyInput(InputEvent.Key event) {
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player == null) {
            return;
        }
        if (WandUtil.holdingWand((Player)player) == null) {
            return;
        }
        boolean modifierDown = ClientEvents.isModifierDown();
        if (this.lastModifierState != modifierDown) {
            this.lastModifierState = modifierDown;
        }
    }

    public static boolean isModifierDown() {
        return ModKeyBindings.MODIFIER.isDown();
    }
}

