/*
 * Decompiled with CFR 0.152.
 */
package axdev.magicconstruction.client;

import axdev.magicconstruction.basics.WandUtil;
import axdev.magicconstruction.items.wand.ItemWand;
import axdev.magicconstruction.wand.LedgeDetector;
import axdev.magicconstruction.wand.WandJob;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Set;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.RenderHighlightEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;

public class RenderBlockPreview {
    private static final long UNDO_PREVIEW_TIMEOUT = 3000L;
    private WandJob wandJob;
    private WandJob ledgeWandJob;
    private BlockHitResult cachedLedgeResult;
    public Set<BlockPos> undoBlocks;
    private long undoBlocksTimestamp;

    @SubscribeEvent
    public void renderBlockHighlight(RenderHighlightEvent.Block event) {
        Set<BlockPos> blocks;
        if (event.getTarget().getType() != HitResult.Type.BLOCK) {
            return;
        }
        BlockHitResult rtr = event.getTarget();
        Entity entity = event.getCamera().getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        float colorR = 0.2f;
        float colorG = 0.6f;
        float colorB = 1.0f;
        ItemStack wand = WandUtil.holdingWand(player);
        if (wand == null) {
            return;
        }
        if (!player.isCrouching()) {
            if (this.wandJob == null || !RenderBlockPreview.compareRTR(this.wandJob.rayTraceResult, rtr) || !this.wandJob.wand.equals(wand) || this.wandJob.blockCount() < 2) {
                this.wandJob = ItemWand.getWandJob(player, player.level(), rtr, wand);
            }
            blocks = this.wandJob.getBlockPositions();
        } else if (this.undoBlocks != null && !this.undoBlocks.isEmpty() && !this.isUndoPreviewExpired()) {
            blocks = this.undoBlocks;
            colorR = 1.0f;
            colorG = 0.0f;
            colorB = 0.0f;
        } else {
            this.clearUndoBlocks();
            return;
        }
        if (blocks == null || blocks.isEmpty()) {
            return;
        }
        this.renderBlocks(event.getPoseStack(), event.getMultiBufferSource(), event.getDeltaTracker(), player, blocks, colorR, colorG, colorB);
        event.setCanceled(true);
    }

    @SubscribeEvent
    public void renderLedgePreview(RenderLevelStageEvent event) {
        Set<BlockPos> blocks;
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null) {
            return;
        }
        LocalPlayer player = mc.player;
        ItemStack wand = WandUtil.holdingWand((Player)player);
        PoseStack poseStack = event.getPoseStack();
        MultiBufferSource.BufferSource buffer = mc.renderBuffers().bufferSource();
        if (this.undoBlocks != null && !this.undoBlocks.isEmpty()) {
            if (this.isUndoPreviewExpired()) {
                this.clearUndoBlocks();
            } else {
                this.renderBlocks(poseStack, (MultiBufferSource)buffer, event.getPartialTick(), (Player)player, this.undoBlocks, 1.0f, 0.0f, 0.0f);
                buffer.endBatch();
                return;
            }
        }
        if (wand == null) {
            return;
        }
        if (mc.hitResult != null && mc.hitResult.getType() == HitResult.Type.BLOCK) {
            return;
        }
        BlockHitResult ledgeResult = LedgeDetector.detectLedge((Player)player, player.level());
        if (ledgeResult == null) {
            this.ledgeWandJob = null;
            this.cachedLedgeResult = null;
            return;
        }
        if (this.ledgeWandJob == null || this.cachedLedgeResult == null || !RenderBlockPreview.compareRTR(this.cachedLedgeResult, ledgeResult) || !this.ledgeWandJob.wand.equals(wand)) {
            this.ledgeWandJob = ItemWand.getWandJob((Player)player, player.level(), ledgeResult, wand);
            this.cachedLedgeResult = ledgeResult;
        }
        if ((blocks = this.ledgeWandJob.getBlockPositions()) == null || blocks.isEmpty()) {
            return;
        }
        this.renderBlocks(poseStack, (MultiBufferSource)buffer, event.getPartialTick(), (Player)player, blocks, 0.2f, 0.6f, 1.0f);
        buffer.endBatch();
    }

    private void renderBlocks(PoseStack ms, MultiBufferSource buffer, DeltaTracker deltaTracker, Player player, Set<BlockPos> blocks, float colorR, float colorG, float colorB) {
        VertexConsumer lineBuilder = buffer.getBuffer((RenderType)RenderType.LINES);
        float partialTicks = deltaTracker.getGameTimeDeltaPartialTick(false);
        double d0 = player.xOld + (player.getX() - player.xOld) * (double)partialTicks;
        double d1 = player.yOld + (double)player.getEyeHeight() + (player.getY() - player.yOld) * (double)partialTicks;
        double d2 = player.zOld + (player.getZ() - player.zOld) * (double)partialTicks;
        for (BlockPos block : blocks) {
            AABB aabb = new AABB(block).move(-d0, -d1, -d2);
            LevelRenderer.renderLineBox((PoseStack)ms, (VertexConsumer)lineBuilder, (AABB)aabb, (float)colorR, (float)colorG, (float)colorB, (float)0.4f);
        }
    }

    public BlockHitResult getLedgeResult(Player player) {
        if (Minecraft.getInstance().hitResult != null && Minecraft.getInstance().hitResult.getType() == HitResult.Type.BLOCK) {
            return null;
        }
        return LedgeDetector.detectLedge(player, player.level());
    }

    public void reset() {
        this.wandJob = null;
        this.ledgeWandJob = null;
        this.cachedLedgeResult = null;
    }

    private static boolean compareRTR(BlockHitResult rtr1, BlockHitResult rtr2) {
        if (rtr1 == null || rtr2 == null) {
            return false;
        }
        return rtr1.getBlockPos().equals((Object)rtr2.getBlockPos()) && rtr1.getDirection().equals((Object)rtr2.getDirection());
    }

    public void setUndoBlocks(Set<BlockPos> blocks) {
        this.undoBlocks = blocks;
        this.undoBlocksTimestamp = System.currentTimeMillis();
    }

    private boolean isUndoPreviewExpired() {
        return System.currentTimeMillis() - this.undoBlocksTimestamp >= 3000L;
    }

    private void clearUndoBlocks() {
        this.undoBlocks = null;
        this.undoBlocksTimestamp = 0L;
    }
}

