/*
 * Decompiled with CFR 0.152.
 */
package axdev.magicconstruction.containers;

import axdev.magicconstruction.containers.ModMenuTypes;
import axdev.magicconstruction.items.wand.ItemWand;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class BlockPouchMenu
extends AbstractContainerMenu {
    private final ItemStack wand;
    private final int pouchSize;
    private final SimpleContainer pouchContainer;

    public BlockPouchMenu(int containerId, Inventory playerInv, FriendlyByteBuf data) {
        this(containerId, playerInv, playerInv.player.getMainHandItem());
    }

    public BlockPouchMenu(int containerId, Inventory playerInv, ItemStack wand) {
        super((MenuType)ModMenuTypes.BLOCK_POUCH_MENU.get(), containerId);
        int col;
        this.wand = wand;
        this.pouchSize = Math.min(36, ItemWand.getPouchCapacity(wand) / 64);
        this.pouchContainer = new SimpleContainer(this.pouchSize){

            public void setChanged() {
                super.setChanged();
                BlockPouchMenu.this.savePouchContents();
            }
        };
        this.loadPouchContents();
        int rows = (int)Math.ceil((double)this.pouchSize / 9.0);
        for (int row = 0; row < rows; ++row) {
            for (col = 0; col < 9; ++col) {
                int index = row * 9 + col;
                if (index >= this.pouchSize) continue;
                this.addSlot(new PouchSlot((Container)this.pouchContainer, index, 8 + col * 18, 18 + row * 18, wand));
            }
        }
        int invY = 18 + rows * 18 + 14 + 14 + 4;
        for (int row = 0; row < 3; ++row) {
            for (int col2 = 0; col2 < 9; ++col2) {
                this.addSlot(new Slot((Container)playerInv, col2 + row * 9 + 9, 8 + col2 * 18, invY + row * 18));
            }
        }
        for (col = 0; col < 9; ++col) {
            this.addSlot(new Slot((Container)playerInv, col, 8 + col * 18, invY + 58));
        }
    }

    private void loadPouchContents() {
        NonNullList<ItemStack> contents = ItemWand.getPouchContents(this.wand);
        for (int i = 0; i < contents.size() && i < this.pouchSize; ++i) {
            this.pouchContainer.setItem(i, ((ItemStack)contents.get(i)).copy());
        }
    }

    private void savePouchContents() {
        NonNullList contents = NonNullList.create();
        for (int i = 0; i < this.pouchSize; ++i) {
            ItemStack stack = this.pouchContainer.getItem(i);
            if (stack.isEmpty()) continue;
            contents.add((Object)stack.copy());
        }
        ItemWand.setPouchContents(this.wand, (NonNullList<ItemStack>)contents);
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack slotStack = slot.getItem();
            if (slotStack == this.wand || ItemStack.isSameItemSameComponents((ItemStack)slotStack, (ItemStack)this.wand)) {
                return ItemStack.EMPTY;
            }
            itemstack = slotStack.copy();
            if (index < this.pouchSize ? !this.moveItemStackTo(slotStack, this.pouchSize, this.slots.size(), true) : !this.moveItemStackTo(slotStack, 0, this.pouchSize, false)) {
                return ItemStack.EMPTY;
            }
            if (slotStack.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return itemstack;
    }

    public boolean stillValid(Player player) {
        return player.getMainHandItem() == this.wand || player.getOffhandItem() == this.wand;
    }

    public void removed(Player player) {
        super.removed(player);
        this.savePouchContents();
    }

    public int getPouchSize() {
        return this.pouchSize;
    }

    private static class PouchSlot
    extends Slot {
        private final ItemStack wand;

        public PouchSlot(Container container, int slot, int x, int y, ItemStack wand) {
            super(container, slot, x, y);
            this.wand = wand;
        }

        public boolean mayPlace(ItemStack stack) {
            return stack != this.wand && !ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)this.wand);
        }
    }
}

