/*
 * Decompiled with CFR 0.152.
 */
package axdev.magicconstruction.crafting;

import axdev.magicconstruction.crafting.ModRecipes;
import axdev.magicconstruction.items.ItemBlockPouch;
import axdev.magicconstruction.items.wand.ItemWand;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;

public class WandPouchRecipe
extends CustomRecipe {
    public WandPouchRecipe(CraftingBookCategory category) {
        super(category);
    }

    public boolean matches(CraftingInput input, Level level) {
        ItemStack wandStack = ItemStack.EMPTY;
        ItemStack pouchStack = ItemStack.EMPTY;
        int itemCount = 0;
        for (int i = 0; i < input.size(); ++i) {
            ItemStack stack = input.getItem(i);
            if (stack.isEmpty()) continue;
            ++itemCount;
            if (stack.getItem() instanceof ItemWand) {
                if (!wandStack.isEmpty()) {
                    return false;
                }
                wandStack = stack;
                continue;
            }
            if (stack.getItem() instanceof ItemBlockPouch) {
                if (!pouchStack.isEmpty()) {
                    return false;
                }
                pouchStack = stack;
                continue;
            }
            return false;
        }
        if (wandStack.isEmpty() || pouchStack.isEmpty() || itemCount != 2) {
            return false;
        }
        return !ItemWand.hasPouch(wandStack);
    }

    public ItemStack assemble(CraftingInput input, HolderLookup.Provider registries) {
        ItemStack wandStack = ItemStack.EMPTY;
        ItemStack pouchStack = ItemStack.EMPTY;
        for (int i = 0; i < input.size(); ++i) {
            ItemStack stack = input.getItem(i);
            if (stack.isEmpty()) continue;
            if (stack.getItem() instanceof ItemWand) {
                wandStack = stack;
                continue;
            }
            if (!(stack.getItem() instanceof ItemBlockPouch)) continue;
            pouchStack = stack;
        }
        if (wandStack.isEmpty() || pouchStack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        ItemStack result = wandStack.copy();
        ItemBlockPouch pouch = (ItemBlockPouch)pouchStack.getItem();
        ItemWand.setPouchTier(result, pouch.getTier());
        return result;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInput input) {
        return NonNullList.withSize((int)input.size(), (Object)ItemStack.EMPTY);
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= 2;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipes.WAND_POUCH_SERIALIZER.get();
    }
}

