/*
 * Decompiled with CFR 0.152.
 */
package axdev.magicconstruction.items.wand;

import axdev.magicconstruction.containers.BlockPouchMenu;
import axdev.magicconstruction.wand.LedgeDetector;
import axdev.magicconstruction.wand.WandJob;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class ItemWand
extends Item {
    private static final String TAG_POUCH = "block_pouch";
    private static final String TAG_POUCH_TIER = "pouch_tier";
    private static final int[] POUCH_CAPACITIES = new int[]{0, 128, 256, 512, 2048};
    private final int limit;
    private final Item repairItem;

    public ItemWand(Item.Properties properties, int limit, Item repairItem) {
        super(properties);
        this.limit = limit;
        this.repairItem = repairItem;
    }

    public int getLimit() {
        return this.limit;
    }

    public static int getPouchTier(ItemStack wand) {
        CustomData customData = (CustomData)wand.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY);
        CompoundTag tag = customData.copyTag();
        return tag.getInt(TAG_POUCH_TIER);
    }

    public static void setPouchTier(ItemStack wand, int tier) {
        CustomData customData = (CustomData)wand.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY);
        CompoundTag tag = customData.copyTag();
        tag.putInt(TAG_POUCH_TIER, tier);
        wand.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tag));
    }

    public static int getPouchCapacity(ItemStack wand) {
        int tier = ItemWand.getPouchTier(wand);
        if (tier < 0 || tier >= POUCH_CAPACITIES.length) {
            return 0;
        }
        return POUCH_CAPACITIES[tier];
    }

    public static boolean hasPouch(ItemStack wand) {
        return ItemWand.getPouchTier(wand) > 0;
    }

    @Nonnull
    public InteractionResult useOn(UseOnContext context) {
        Player player = context.getPlayer();
        InteractionHand hand = context.getHand();
        Level world = context.getLevel();
        if (world.isClientSide || player == null) {
            return InteractionResult.FAIL;
        }
        ItemStack stack = player.getItemInHand(hand);
        if (player.isCrouching()) {
            if (ItemWand.hasPouch(stack)) {
                this.openPouchGui(player, stack);
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        }
        WandJob job = ItemWand.getWandJob(player, world, new BlockHitResult(context.getClickLocation(), context.getClickedFace(), context.getClickedPos(), false), stack);
        return job.doIt() ? InteractionResult.SUCCESS : InteractionResult.FAIL;
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> use(@Nonnull Level world, Player player, @Nonnull InteractionHand hand) {
        WandJob job;
        BlockHitResult ledgeResult;
        ItemStack stack = player.getItemInHand(hand);
        if (player.isCrouching()) {
            if (ItemWand.hasPouch(stack)) {
                if (!world.isClientSide) {
                    this.openPouchGui(player, stack);
                }
                return InteractionResultHolder.success((Object)stack);
            }
            return InteractionResultHolder.pass((Object)stack);
        }
        if (!world.isClientSide && (ledgeResult = LedgeDetector.detectLedge(player, world)) != null && (job = ItemWand.getWandJob(player, world, ledgeResult, stack)).doIt()) {
            return InteractionResultHolder.success((Object)stack);
        }
        return InteractionResultHolder.pass((Object)stack);
    }

    private void openPouchGui(Player player, final ItemStack wand) {
        player.openMenu(new MenuProvider(){

            public Component getDisplayName() {
                return Component.translatable((String)"magicconstruction.gui.block_pouch");
            }

            public AbstractContainerMenu createMenu(int containerId, Inventory playerInv, Player player) {
                return new BlockPouchMenu(containerId, playerInv, wand);
            }
        });
    }

    public static WandJob getWandJob(Player player, Level world, @Nullable BlockHitResult rayTraceResult, ItemStack wand) {
        WandJob wandJob = new WandJob(player, world, rayTraceResult, wand);
        wandJob.getSnapshots();
        return wandJob;
    }

    public boolean isCorrectToolForDrops(@Nonnull ItemStack stack, @Nonnull BlockState blockIn) {
        return false;
    }

    public boolean isValidRepairItem(@Nonnull ItemStack toRepair, @Nonnull ItemStack repair) {
        return repair.getItem() == this.repairItem;
    }

    public int remainingDurability(ItemStack stack) {
        return stack.getMaxDamage() - stack.getDamageValue();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(@Nonnull ItemStack itemstack, @Nonnull Item.TooltipContext context, @Nonnull List<Component> lines, @Nonnull TooltipFlag extraInfo) {
        lines.add((Component)Component.translatable((String)"magicconstruction.tooltip.blocks", (Object[])new Object[]{this.limit}).withStyle(ChatFormatting.GRAY));
        if (ItemWand.hasPouch(itemstack)) {
            NonNullList<ItemStack> contents = ItemWand.getPouchContents(itemstack);
            int total = ItemWand.countPouchItems(contents);
            int capacity = ItemWand.getPouchCapacity(itemstack);
            lines.add((Component)Component.translatable((String)"magicconstruction.tooltip.pouch", (Object[])new Object[]{total, capacity}).withStyle(ChatFormatting.AQUA));
            if (!contents.isEmpty()) {
                int shown = 0;
                for (ItemStack stack : contents) {
                    if (shown >= 5) {
                        lines.add((Component)Component.translatable((String)"magicconstruction.tooltip.and_more", (Object[])new Object[]{contents.size() - 5}).withStyle(ChatFormatting.DARK_GRAY));
                        break;
                    }
                    lines.add((Component)Component.literal((String)("  " + stack.getCount() + "x ")).withStyle(ChatFormatting.DARK_GRAY).append((Component)stack.getHoverName().copy().withStyle(ChatFormatting.GRAY)));
                    ++shown;
                }
            }
            lines.add((Component)Component.translatable((String)"magicconstruction.tooltip.shift_pouch").withStyle(ChatFormatting.DARK_GRAY));
        }
    }

    public static NonNullList<ItemStack> getPouchContents(ItemStack wand) {
        NonNullList contents = NonNullList.create();
        CustomData customData = (CustomData)wand.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY);
        CompoundTag tag = customData.copyTag();
        if (tag.contains(TAG_POUCH)) {
            ListTag list = tag.getList(TAG_POUCH, 10);
            for (int i = 0; i < list.size(); ++i) {
                CompoundTag itemTag = list.getCompound(i);
                ItemStack stack = ItemStack.parseOptional((HolderLookup.Provider)HolderLookup.Provider.create(Stream.empty()), (CompoundTag)itemTag);
                if (stack.isEmpty()) continue;
                contents.add((Object)stack);
            }
        }
        return contents;
    }

    public static void setPouchContents(ItemStack wand, NonNullList<ItemStack> contents) {
        CustomData customData = (CustomData)wand.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY);
        CompoundTag tag = customData.copyTag();
        ListTag list = new ListTag();
        for (ItemStack stack : contents) {
            if (stack.isEmpty()) continue;
            CompoundTag itemTag = new CompoundTag();
            itemTag.putString("id", BuiltInRegistries.ITEM.getKey((Object)stack.getItem()).toString());
            itemTag.putInt("count", stack.getCount());
            list.add((Object)itemTag);
        }
        tag.put(TAG_POUCH, (Tag)list);
        wand.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tag));
    }

    public static ItemStack addToPouchContents(ItemStack wand, ItemStack toAdd) {
        int canAddTotal;
        int currentTotal;
        NonNullList<ItemStack> contents = ItemWand.getPouchContents(wand);
        int remaining = toAdd.getCount();
        int maxStack = toAdd.getMaxStackSize();
        int capacity = ItemWand.getPouchCapacity(wand);
        int availableSpace = capacity - (currentTotal = ItemWand.countPouchItems(contents));
        if (availableSpace <= 0) {
            return toAdd.copy();
        }
        int toAddNow = canAddTotal = Math.min(remaining, availableSpace);
        for (ItemStack stack : contents) {
            int canAdd;
            if (toAddNow <= 0) break;
            if (!ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)toAdd) || (canAdd = maxStack - stack.getCount()) <= 0) continue;
            int toTransfer = Math.min(canAdd, toAddNow);
            stack.grow(toTransfer);
            toAddNow -= toTransfer;
        }
        while (toAddNow > 0) {
            ItemStack newStack = toAdd.copy();
            int stackSize = Math.min(toAddNow, maxStack);
            newStack.setCount(stackSize);
            contents.add((Object)newStack);
            toAddNow -= stackSize;
        }
        ItemWand.setPouchContents(wand, contents);
        int leftover = remaining - canAddTotal;
        if (leftover > 0) {
            ItemStack result = toAdd.copy();
            result.setCount(leftover);
            return result;
        }
        return ItemStack.EMPTY;
    }

    public static boolean consumeFromPouch(ItemStack wand, Item item, int amount) {
        NonNullList<ItemStack> contents = ItemWand.getPouchContents(wand);
        for (int i = 0; i < contents.size(); ++i) {
            ItemStack stack = (ItemStack)contents.get(i);
            if (stack.getItem() != item || stack.getCount() < amount) continue;
            stack.shrink(amount);
            if (stack.isEmpty()) {
                contents.remove(i);
            }
            ItemWand.setPouchContents(wand, contents);
            return true;
        }
        return false;
    }

    public static int countInPouch(ItemStack wand, Item item) {
        NonNullList<ItemStack> contents = ItemWand.getPouchContents(wand);
        for (ItemStack stack : contents) {
            if (stack.getItem() != item) continue;
            return stack.getCount();
        }
        return 0;
    }

    private static int countPouchItems(NonNullList<ItemStack> contents) {
        int total = 0;
        for (ItemStack stack : contents) {
            total += stack.getCount();
        }
        return total;
    }
}

