/*
 * Decompiled with CFR 0.152.
 */
package axdev.magicconstruction.network;

import axdev.magicconstruction.MagicConstruction;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record PacketUndoBlocks(HashSet<BlockPos> undoBlocks) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<PacketUndoBlocks> TYPE = new CustomPacketPayload.Type(MagicConstruction.loc("undo_blocks"));
    public static final StreamCodec<FriendlyByteBuf, PacketUndoBlocks> STREAM_CODEC = StreamCodec.of(PacketUndoBlocks::encode, PacketUndoBlocks::decode);

    public PacketUndoBlocks(Set<BlockPos> undoBlocks) {
        this(new HashSet<BlockPos>(undoBlocks));
    }

    public static void encode(FriendlyByteBuf buffer, PacketUndoBlocks msg) {
        buffer.writeInt(msg.undoBlocks.size());
        for (BlockPos pos : msg.undoBlocks) {
            buffer.writeBlockPos(pos);
        }
    }

    public static PacketUndoBlocks decode(FriendlyByteBuf buffer) {
        HashSet<BlockPos> undoBlocks = new HashSet<BlockPos>();
        int size = buffer.readInt();
        for (int i = 0; i < size; ++i) {
            undoBlocks.add(buffer.readBlockPos());
        }
        return new PacketUndoBlocks(undoBlocks);
    }

    public static void handle(PacketUndoBlocks msg, IPayloadContext ctx) {
        ctx.enqueueWork(() -> MagicConstruction.instance.renderBlockPreview.setUndoBlocks(msg.undoBlocks));
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

