/*
 * Decompiled with CFR 0.152.
 */
package axdev.magicconstruction.wand;

import axdev.magicconstruction.MagicConstruction;
import axdev.magicconstruction.basics.ModStats;
import axdev.magicconstruction.items.wand.ItemWand;
import axdev.magicconstruction.wand.PlaceAction;
import axdev.magicconstruction.wand.undo.ISnapshot;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class WandJob {
    public final Player player;
    public final Level world;
    public final BlockHitResult rayTraceResult;
    public final ItemStack wand;
    public final ItemWand wandItem;
    private List<ISnapshot> placeSnapshots;

    public WandJob(Player player, Level world, BlockHitResult rayTraceResult, ItemStack wand) {
        this.player = player;
        this.world = world;
        this.rayTraceResult = rayTraceResult;
        this.placeSnapshots = new ArrayList<ISnapshot>();
        this.wand = wand;
        this.wandItem = (ItemWand)wand.getItem();
    }

    @Nullable
    private BlockItem getTargetItem() {
        Item tgitem = this.world.getBlockState(this.rayTraceResult.getBlockPos()).getBlock().asItem();
        if (!(tgitem instanceof BlockItem)) {
            return null;
        }
        return (BlockItem)tgitem;
    }

    public void getSnapshots() {
        if (this.rayTraceResult.getType() != HitResult.Type.BLOCK) {
            return;
        }
        int limit = Math.min(this.wandItem.remainingDurability(this.wand), this.wandItem.getLimit());
        BlockItem targetItem = this.getTargetItem();
        if (targetItem == null) {
            return;
        }
        this.placeSnapshots = PlaceAction.getSnapshots(this.world, this.player, this.rayTraceResult, this.wand, targetItem, limit);
    }

    public Set<BlockPos> getBlockPositions() {
        return this.placeSnapshots.stream().map(ISnapshot::getPos).collect(Collectors.toSet());
    }

    public int blockCount() {
        return this.placeSnapshots.size();
    }

    public boolean doIt() {
        ArrayList<ISnapshot> executed = new ArrayList<ISnapshot>();
        BlockItem targetItem = this.getTargetItem();
        for (ISnapshot snapshot : this.placeSnapshots) {
            if (this.wand.isEmpty() || this.wandItem.remainingDurability(this.wand) == 0) break;
            if (!snapshot.execute(this.world, this.player, this.rayTraceResult)) continue;
            if (this.player.isCreative()) {
                executed.add(snapshot);
            } else {
                boolean consumed = this.consumeItem(targetItem);
                if (consumed) {
                    executed.add(snapshot);
                    Level level = this.world;
                    if (level instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)level;
                        this.wand.hurtAndBreak(1, serverLevel, (LivingEntity)this.player, item -> {});
                    }
                } else {
                    snapshot.forceRestore(this.world);
                }
            }
            this.player.awardStat(ModStats.USE_WAND);
        }
        this.placeSnapshots = executed;
        if (!this.placeSnapshots.isEmpty()) {
            SoundType sound = this.placeSnapshots.get(0).getBlockState().getSoundType();
            this.world.playSound(null, this.player.blockPosition(), sound.getPlaceSound(), SoundSource.BLOCKS, sound.volume, sound.pitch);
            MagicConstruction.instance.undoHistory.add(this.player, this.world, this.placeSnapshots);
        }
        return !this.placeSnapshots.isEmpty();
    }

    private boolean consumeItem(BlockItem targetItem) {
        if (ItemWand.hasPouch(this.wand) && ItemWand.consumeFromPouch(this.wand, (Item)targetItem, 1)) {
            return true;
        }
        for (int i = 0; i < this.player.getInventory().getContainerSize(); ++i) {
            ItemStack stack = this.player.getInventory().getItem(i);
            if (stack.getItem() != targetItem || stack.getCount() <= 0) continue;
            stack.shrink(1);
            if (stack.isEmpty()) {
                this.player.getInventory().setItem(i, ItemStack.EMPTY);
            }
            return true;
        }
        return false;
    }
}

