/*
 * Decompiled with CFR 0.152.
 */
package axdev.magicconstruction.wand.undo;

import axdev.magicconstruction.basics.WandUtil;
import axdev.magicconstruction.items.wand.ItemWand;
import axdev.magicconstruction.network.ModMessages;
import axdev.magicconstruction.network.PacketUndoBlocks;
import axdev.magicconstruction.wand.undo.ISnapshot;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class UndoHistory {
    private static final long CONFIRM_TIMEOUT = 3000L;
    private final HashMap<UUID, PlayerHistory> history = new HashMap();

    private PlayerHistory getHistory(Player player) {
        return this.history.computeIfAbsent(player.getUUID(), k -> new PlayerHistory());
    }

    public void add(Player player, Level world, List<ISnapshot> snapshots) {
        PlayerHistory ph = this.getHistory(player);
        ph.entries.add(new UndoEntry(snapshots, world));
        ph.pendingConfirm = false;
        ph.lastUndoRequest = 0L;
    }

    public void tryUndo(Player player) {
        PlayerHistory ph = this.getHistory(player);
        if (ph.entries.isEmpty()) {
            player.displayClientMessage((Component)Component.translatable((String)"magicconstruction.message.undo_empty").withStyle(ChatFormatting.RED), true);
            return;
        }
        long now = System.currentTimeMillis();
        if (ph.pendingConfirm && now - ph.lastUndoRequest < 3000L) {
            this.executeUndo(player, ph);
        } else {
            ph.pendingConfirm = true;
            ph.lastUndoRequest = now;
            this.sendUndoPreview(player, ph);
            player.displayClientMessage((Component)Component.translatable((String)"magicconstruction.message.undo_confirm").withStyle(ChatFormatting.YELLOW), true);
        }
    }

    private void executeUndo(Player player, PlayerHistory ph) {
        UndoEntry entry = ph.entries.removeLast();
        ph.pendingConfirm = false;
        ph.lastUndoRequest = 0L;
        Level world = entry.world;
        int undoneCount = 0;
        int skippedCount = 0;
        for (ISnapshot snapshot : entry.snapshots) {
            if (snapshot.canRestore(world, player)) {
                ItemStack stack;
                if (!snapshot.restore(world, player)) continue;
                ++undoneCount;
                if (player.isCreative()) continue;
                ItemStack remaining = stack = snapshot.getRequiredItems();
                ItemStack wand = WandUtil.holdingWand(player);
                if (wand != null && wand.getItem() instanceof ItemWand && ItemWand.hasPouch(wand)) {
                    remaining = ItemWand.addToPouchContents(wand, stack);
                }
                if (remaining.isEmpty() || player.getInventory().add(remaining)) continue;
                player.drop(remaining, false);
                continue;
            }
            ++skippedCount;
        }
        player.getInventory().setChanged();
        if (undoneCount > 0) {
            world.playSound(null, player.blockPosition(), SoundEvents.ITEM_PICKUP, SoundSource.PLAYERS, 0.5f, 0.8f);
            if (skippedCount > 0) {
                player.displayClientMessage((Component)Component.translatable((String)"magicconstruction.message.undo_partial", (Object[])new Object[]{undoneCount, skippedCount}).withStyle(ChatFormatting.YELLOW), true);
            } else {
                player.displayClientMessage((Component)Component.translatable((String)"magicconstruction.message.undo_success", (Object[])new Object[]{undoneCount}).withStyle(ChatFormatting.GREEN), true);
            }
        } else {
            player.displayClientMessage((Component)Component.translatable((String)"magicconstruction.message.undo_failed").withStyle(ChatFormatting.RED), true);
        }
        this.clearUndoPreview(player);
    }

    private void sendUndoPreview(Player player, PlayerHistory ph) {
        if (ph.entries.isEmpty()) {
            return;
        }
        UndoEntry entry = ph.entries.getLast();
        if (!entry.world.equals(player.level())) {
            return;
        }
        Set<BlockPos> positions = entry.snapshots.stream().map(ISnapshot::getPos).collect(Collectors.toSet());
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            ModMessages.sendToPlayer(new PacketUndoBlocks(positions), sp);
        }
    }

    private void clearUndoPreview(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            ModMessages.sendToPlayer(new PacketUndoBlocks(Collections.emptySet()), sp);
        }
    }

    public void removePlayer(Player player) {
        this.history.remove(player.getUUID());
    }

    public Set<BlockPos> getLastUndoPositions(Player player) {
        PlayerHistory ph = this.getHistory(player);
        if (ph.entries.isEmpty()) {
            return Collections.emptySet();
        }
        UndoEntry entry = ph.entries.getLast();
        if (!entry.world.equals(player.level())) {
            return Collections.emptySet();
        }
        return entry.snapshots.stream().map(ISnapshot::getPos).collect(Collectors.toSet());
    }

    public boolean hasPendingConfirm(Player player) {
        PlayerHistory ph = this.getHistory(player);
        if (!ph.pendingConfirm) {
            return false;
        }
        long now = System.currentTimeMillis();
        if (now - ph.lastUndoRequest >= 3000L) {
            ph.pendingConfirm = false;
            return false;
        }
        return true;
    }

    public void updateClient(Player player, boolean show) {
        if (player.level().isClientSide) {
            return;
        }
        PlayerHistory ph = this.getHistory(player);
        if (show && !ph.entries.isEmpty()) {
            this.sendUndoPreview(player, ph);
        } else {
            this.clearUndoPreview(player);
        }
    }

    public boolean isUndoActive(Player player) {
        return this.hasPendingConfirm(player);
    }

    public boolean undo(Player player, Level world, BlockPos pos) {
        return false;
    }

    private static class PlayerHistory {
        public final LinkedList<UndoEntry> entries = new LinkedList();
        public boolean pendingConfirm = false;
        public long lastUndoRequest = 0L;

        private PlayerHistory() {
        }
    }

    private static class UndoEntry {
        public final List<ISnapshot> snapshots;
        public final Level world;

        public UndoEntry(List<ISnapshot> snapshots, Level world) {
            this.snapshots = snapshots;
            this.world = world;
        }
    }
}

