/*
 * Decompiled with CFR 0.152.
 */
package axdev.magicconstruction.containers;

import axdev.magicconstruction.containers.BlockPouchData;
import axdev.magicconstruction.containers.ModScreenHandlers;
import axdev.magicconstruction.items.wand.ItemWand;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2371;

public class BlockPouchScreenHandler
extends class_1703 {
    private final class_1799 wand;
    private final int pouchSize;
    private final class_1277 pouchContainer;
    private final class_1657 player;

    public BlockPouchScreenHandler(int syncId, class_1661 playerInv, BlockPouchData data) {
        this(syncId, playerInv, playerInv.field_7546.method_6047());
    }

    public BlockPouchScreenHandler(int syncId, class_1661 playerInv, class_1799 wand) {
        super(ModScreenHandlers.BLOCK_POUCH, syncId);
        int col;
        this.wand = wand;
        this.player = playerInv.field_7546;
        this.pouchSize = Math.min(36, ItemWand.getPouchCapacity(wand) / 64);
        this.pouchContainer = new class_1277(this.pouchSize){

            public void method_5431() {
                super.method_5431();
                BlockPouchScreenHandler.this.savePouchContents();
            }
        };
        this.loadPouchContents();
        int rows = (int)Math.ceil((double)this.pouchSize / 9.0);
        for (int row = 0; row < rows; ++row) {
            for (col = 0; col < 9; ++col) {
                int index = row * 9 + col;
                if (index >= this.pouchSize) continue;
                this.method_7621(new PouchSlot(this.pouchContainer, index, 8 + col * 18, 18 + row * 18, wand));
            }
        }
        int invY = 18 + rows * 18 + 14 + 14 + 4;
        for (int row = 0; row < 3; ++row) {
            for (int col2 = 0; col2 < 9; ++col2) {
                this.method_7621(new class_1735((class_1263)playerInv, col2 + row * 9 + 9, 8 + col2 * 18, invY + row * 18));
            }
        }
        for (col = 0; col < 9; ++col) {
            this.method_7621(new class_1735((class_1263)playerInv, col, 8 + col * 18, invY + 58));
        }
    }

    private void loadPouchContents() {
        class_2371<class_1799> contents = ItemWand.getPouchContents(this.wand, this.player.method_37908());
        for (int i = 0; i < contents.size() && i < this.pouchSize; ++i) {
            this.pouchContainer.method_5447(i, ((class_1799)contents.get(i)).method_7972());
        }
    }

    private void savePouchContents() {
        class_2371 contents = class_2371.method_10211();
        for (int i = 0; i < this.pouchSize; ++i) {
            class_1799 stack = this.pouchContainer.method_5438(i);
            if (stack.method_7960()) continue;
            contents.add((Object)stack.method_7972());
        }
        ItemWand.setPouchContents(this.wand, (class_2371<class_1799>)contents, this.player.method_37908());
    }

    public class_1799 method_7601(class_1657 player, int index) {
        class_1799 itemstack = class_1799.field_8037;
        class_1735 slot = (class_1735)this.field_7761.get(index);
        if (slot != null && slot.method_7681()) {
            class_1799 slotStack = slot.method_7677();
            if (slotStack == this.wand || class_1799.method_31577((class_1799)slotStack, (class_1799)this.wand)) {
                return class_1799.field_8037;
            }
            itemstack = slotStack.method_7972();
            if (index < this.pouchSize ? !this.method_7616(slotStack, this.pouchSize, this.field_7761.size(), true) : !this.method_7616(slotStack, 0, this.pouchSize, false)) {
                return class_1799.field_8037;
            }
            if (slotStack.method_7960()) {
                slot.method_53512(class_1799.field_8037);
            } else {
                slot.method_7668();
            }
        }
        return itemstack;
    }

    public boolean method_7597(class_1657 player) {
        return player.method_6047() == this.wand || player.method_6079() == this.wand;
    }

    public void method_7595(class_1657 player) {
        super.method_7595(player);
        this.savePouchContents();
    }

    public int getPouchSize() {
        return this.pouchSize;
    }

    private static class PouchSlot
    extends class_1735 {
        private final class_1799 wand;

        public PouchSlot(class_1277 inventory, int index, int x, int y, class_1799 wand) {
            super((class_1263)inventory, index, x, y);
            this.wand = wand;
        }

        public boolean method_7680(class_1799 stack) {
            return stack != this.wand && !class_1799.method_31577((class_1799)stack, (class_1799)this.wand);
        }
    }
}

