/*
 * Decompiled with CFR 0.152.
 */
package axdev.magicconstruction.wand;

import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_3965;
import org.jetbrains.annotations.Nullable;

public class LedgeDetector {
    private static final double MAX_DISTANCE = 6.0;
    private static final double STEP = 0.25;
    private static final double LEDGE_SEARCH_RADIUS = 1.5;

    @Nullable
    public static class_3965 detectLedge(class_1657 player, class_1937 world) {
        class_243 eyePos = player.method_33571();
        class_243 lookVec = player.method_5828(1.0f);
        for (double d = 1.0; d <= 6.0; d += 0.25) {
            class_243 checkPos = eyePos.method_1019(lookVec.method_1021(d));
            class_2338 blockPos = class_2338.method_49638((class_2374)checkPos);
            if (!world.method_22347(blockPos)) {
                return null;
            }
            class_3965 ledge = LedgeDetector.findAdjacentLedge(world, checkPos, blockPos, lookVec);
            if (ledge == null) continue;
            return ledge;
        }
        return null;
    }

    @Nullable
    private static class_3965 findAdjacentLedge(class_1937 world, class_243 checkPos, class_2338 airPos, class_243 lookVec) {
        class_2350[] searchOrder;
        class_2350 primaryDir = LedgeDetector.getPrimaryLookDirection(lookVec);
        for (class_2350 dir : searchOrder = LedgeDetector.getSearchOrder(primaryDir, lookVec)) {
            class_2338 adjacentPos = airPos.method_10093(dir);
            if (world.method_22347(adjacentPos)) continue;
            class_2338 placePos = airPos;
            class_2350 hitFace = dir.method_10153();
            if (!LedgeDetector.isValidLedgePlacement(world, placePos, adjacentPos)) continue;
            class_243 hitLocation = class_243.method_24953((class_2382)adjacentPos).method_1031((double)hitFace.method_10148() * 0.5, (double)hitFace.method_10164() * 0.5, (double)hitFace.method_10165() * 0.5);
            return new class_3965(hitLocation, hitFace, adjacentPos, false);
        }
        return null;
    }

    private static class_2350 getPrimaryLookDirection(class_243 lookVec) {
        double absX = Math.abs(lookVec.field_1352);
        double absY = Math.abs(lookVec.field_1351);
        double absZ = Math.abs(lookVec.field_1350);
        if (absY >= absX && absY >= absZ) {
            return lookVec.field_1351 > 0.0 ? class_2350.field_11036 : class_2350.field_11033;
        }
        if (absX >= absZ) {
            return lookVec.field_1352 > 0.0 ? class_2350.field_11034 : class_2350.field_11039;
        }
        return lookVec.field_1350 > 0.0 ? class_2350.field_11035 : class_2350.field_11043;
    }

    private static class_2350[] getSearchOrder(class_2350 primary, class_243 lookVec) {
        class_2350[] all = class_2350.values();
        class_2350[] result = new class_2350[6];
        int idx = 0;
        for (class_2350 dir : all) {
            if (dir == primary || dir == primary.method_10153()) continue;
            result[idx++] = dir;
        }
        result[idx++] = primary;
        result[idx] = primary.method_10153();
        return result;
    }

    private static boolean isValidLedgePlacement(class_1937 world, class_2338 placePos, class_2338 supportPos) {
        if (!world.method_22347(placePos)) {
            return false;
        }
        return !world.method_22347(supportPos);
    }
}

