/*
 * Decompiled with CFR 0.152.
 */
package axdev.magicconstruction.wand;

import axdev.magicconstruction.items.wand.ItemWand;
import axdev.magicconstruction.wand.undo.ISnapshot;
import axdev.magicconstruction.wand.undo.PlaceSnapshot;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3965;

public class PlaceAction {
    public static List<ISnapshot> getSnapshots(class_1937 world, class_1657 player, class_3965 rayTraceResult, class_1799 wand, class_1747 targetItem, int limit) {
        LinkedList<ISnapshot> placeSnapshots = new LinkedList<ISnapshot>();
        LinkedList<class_2338> candidates = new LinkedList<class_2338>();
        HashSet<class_2338> allCandidates = new HashSet<class_2338>();
        class_2350 placeDirection = rayTraceResult.method_17780();
        class_2680 targetBlock = world.method_8320(rayTraceResult.method_17777());
        class_2338 startingPoint = rayTraceResult.method_17777().method_10093(placeDirection);
        candidates.add(startingPoint);
        int availableItems = PlaceAction.countAvailableItems(player, wand, targetItem, world);
        while (!candidates.isEmpty() && placeSnapshots.size() < limit && placeSnapshots.size() < availableItems) {
            class_2338 currentCandidate = (class_2338)candidates.removeFirst();
            try {
                class_2338 supportingPoint = currentCandidate.method_10093(placeDirection.method_10153());
                class_2680 candidateSupportingBlock = world.method_8320(supportingPoint);
                if (targetBlock.method_26204() != candidateSupportingBlock.method_26204() || !allCandidates.add(currentCandidate) || !world.method_8320(currentCandidate).method_26215()) continue;
                class_3965 blockRayTraceResult = new class_3965(class_243.method_24953((class_2382)currentCandidate), placeDirection, currentCandidate, false);
                class_2680 placementState = targetItem.method_7711().method_9564();
                if (placementState == null) continue;
                placeSnapshots.add(new PlaceSnapshot(placementState, currentCandidate, new class_1799((class_1935)targetItem)));
                PlaceAction.addNeighbors(candidates, currentCandidate, placeDirection);
            }
            catch (Exception exception) {}
        }
        return placeSnapshots;
    }

    private static int countAvailableItems(class_1657 player, class_1799 wand, class_1747 targetItem, class_1937 world) {
        if (player.method_7337()) {
            return Integer.MAX_VALUE;
        }
        int count = 0;
        if (ItemWand.hasPouch(wand)) {
            count += ItemWand.countInPouch(wand, (class_1792)targetItem, world);
        }
        for (int i = 0; i < player.method_31548().method_5439(); ++i) {
            class_1799 stack = player.method_31548().method_5438(i);
            if (stack.method_7909() != targetItem) continue;
            count += stack.method_7947();
        }
        return count;
    }

    private static void addNeighbors(LinkedList<class_2338> candidates, class_2338 current, class_2350 placeDirection) {
        switch (placeDirection) {
            case field_11033: 
            case field_11036: {
                candidates.add(current.method_10095());
                candidates.add(current.method_10072());
                candidates.add(current.method_10078());
                candidates.add(current.method_10067());
                break;
            }
            case field_11043: 
            case field_11035: {
                candidates.add(current.method_10078());
                candidates.add(current.method_10067());
                candidates.add(current.method_10084());
                candidates.add(current.method_10074());
                break;
            }
            case field_11034: 
            case field_11039: {
                candidates.add(current.method_10095());
                candidates.add(current.method_10072());
                candidates.add(current.method_10084());
                candidates.add(current.method_10074());
            }
        }
    }
}

