/*
 * Decompiled with CFR 0.152.
 */
package axdev.magicconstruction.wand;

import axdev.magicconstruction.MagicConstruction;
import axdev.magicconstruction.items.wand.ItemWand;
import axdev.magicconstruction.wand.PlaceAction;
import axdev.magicconstruction.wand.undo.ISnapshot;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2498;
import net.minecraft.class_3419;
import net.minecraft.class_3965;

public class WandJob {
    public final class_1657 player;
    public final class_1937 world;
    public final class_3965 rayTraceResult;
    public final class_1799 wand;
    public final ItemWand wandItem;
    private List<ISnapshot> placeSnapshots;

    public WandJob(class_1657 player, class_1937 world, class_3965 rayTraceResult, class_1799 wand) {
        this.player = player;
        this.world = world;
        this.rayTraceResult = rayTraceResult;
        this.placeSnapshots = new ArrayList<ISnapshot>();
        this.wand = wand;
        this.wandItem = (ItemWand)wand.method_7909();
    }

    private class_1747 getTargetItem() {
        class_1792 tgitem = this.world.method_8320(this.rayTraceResult.method_17777()).method_26204().method_8389();
        if (!(tgitem instanceof class_1747)) {
            return null;
        }
        return (class_1747)tgitem;
    }

    public void getSnapshots() {
        if (this.rayTraceResult.method_17783() != class_239.class_240.field_1332) {
            return;
        }
        int limit = Math.min(this.wandItem.remainingDurability(this.wand), this.wandItem.getLimit());
        class_1747 targetItem = this.getTargetItem();
        if (targetItem == null) {
            return;
        }
        this.placeSnapshots = PlaceAction.getSnapshots(this.world, this.player, this.rayTraceResult, this.wand, targetItem, limit);
    }

    public Set<class_2338> getBlockPositions() {
        return this.placeSnapshots.stream().map(ISnapshot::getPos).collect(Collectors.toSet());
    }

    public boolean doIt() {
        ArrayList<ISnapshot> executed = new ArrayList<ISnapshot>();
        class_1747 targetItem = this.getTargetItem();
        for (ISnapshot snapshot : this.placeSnapshots) {
            if (this.wand.method_7960() || this.wandItem.remainingDurability(this.wand) == 0) break;
            if (!snapshot.execute(this.world, this.player, this.rayTraceResult)) continue;
            if (this.player.method_7337()) {
                executed.add(snapshot);
                continue;
            }
            boolean consumed = this.consumeItem(targetItem);
            if (consumed) {
                executed.add(snapshot);
                this.wand.method_7970(1, (class_1309)this.player, class_1304.field_6173);
                continue;
            }
            snapshot.forceRestore(this.world);
        }
        this.placeSnapshots = executed;
        if (!this.placeSnapshots.isEmpty()) {
            class_2498 sound = this.placeSnapshots.get(0).getBlockState().method_26231();
            this.world.method_8396(null, this.player.method_24515(), sound.method_10598(), class_3419.field_15245, sound.field_11540, sound.field_11539);
            MagicConstruction.undoHistory.add(this.player, this.world, this.placeSnapshots);
        }
        return !this.placeSnapshots.isEmpty();
    }

    private boolean consumeItem(class_1747 targetItem) {
        if (ItemWand.hasPouch(this.wand) && ItemWand.consumeFromPouch(this.wand, (class_1792)targetItem, 1, this.world)) {
            return true;
        }
        for (int i = 0; i < this.player.method_31548().method_5439(); ++i) {
            class_1799 stack = this.player.method_31548().method_5438(i);
            if (stack.method_7909() != targetItem || stack.method_7947() <= 0) continue;
            stack.method_7934(1);
            return true;
        }
        return false;
    }
}

