/*
 * Decompiled with CFR 0.152.
 */
package axdev.magicconstruction;

import axdev.magicconstruction.basics.ConfigClient;
import axdev.magicconstruction.basics.ConfigServer;
import axdev.magicconstruction.basics.ModStats;
import axdev.magicconstruction.client.BlockPouchScreen;
import axdev.magicconstruction.client.ClientEvents;
import axdev.magicconstruction.client.ModKeyBindings;
import axdev.magicconstruction.client.RenderBlockPreview;
import axdev.magicconstruction.containers.ContainerManager;
import axdev.magicconstruction.containers.ContainerRegistrar;
import axdev.magicconstruction.containers.ModMenuTypes;
import axdev.magicconstruction.crafting.ModRecipes;
import axdev.magicconstruction.items.ModItems;
import axdev.magicconstruction.network.ModMessages;
import axdev.magicconstruction.wand.undo.UndoHistory;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="magicconstruction")
public class MagicConstruction {
    public static final String MODID = "magicconstruction";
    public static final String MODNAME = "Magic Construction";
    public static MagicConstruction instance;
    public static final Logger LOGGER;
    public ContainerManager containerManager;
    public UndoHistory undoHistory;
    public RenderBlockPreview renderBlockPreview;

    public MagicConstruction() {
        instance = this;
        this.containerManager = new ContainerManager();
        this.undoHistory = new UndoHistory();
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::clientSetup);
        modEventBus.addListener(this::registerKeyBindings);
        ModItems.ITEMS.register(modEventBus);
        ModItems.CREATIVE_TABS.register(modEventBus);
        ModMenuTypes.MENU_TYPES.register(modEventBus);
        ModRecipes.RECIPE_SERIALIZERS.register(modEventBus);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)ConfigServer.SPEC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ConfigClient.SPEC);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        LOGGER.info("Magic Construction loaded!");
        ContainerRegistrar.register();
        ModMessages.register();
        ModStats.init();
    }

    private void clientSetup(FMLClientSetupEvent event) {
        this.renderBlockPreview = new RenderBlockPreview();
        MinecraftForge.EVENT_BUS.register((Object)this.renderBlockPreview);
        MinecraftForge.EVENT_BUS.register((Object)new ClientEvents());
        event.enqueueWork(() -> MenuScreens.m_96206_((MenuType)((MenuType)ModMenuTypes.BLOCK_POUCH_MENU.get()), BlockPouchScreen::new));
    }

    private void registerKeyBindings(RegisterKeyMappingsEvent event) {
        event.register(ModKeyBindings.UNDO);
        event.register(ModKeyBindings.OPEN_POUCH);
        event.register(ModKeyBindings.MODIFIER);
    }

    public static ResourceLocation loc(String name) {
        return new ResourceLocation(MODID, name);
    }

    static {
        LOGGER = LogManager.getLogger();
    }
}

