/*
 * Decompiled with CFR 0.152.
 */
package axdev.magicconstruction.basics;

import axdev.magicconstruction.basics.ConfigServer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;

public class ReplacementRegistry {
    private static final List<Set<Block>> similarBlockGroups = new ArrayList<Set<Block>>();

    public static void init() {
        similarBlockGroups.clear();
        List configList = (List)ConfigServer.SIMILAR_BLOCKS.get();
        for (String entry : configList) {
            String[] blockIds = entry.split(";");
            HashSet<Block> group = new HashSet<Block>();
            for (String blockId : blockIds) {
                Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(blockId.trim()));
                if (block == null) continue;
                group.add(block);
            }
            if (group.size() <= 1) continue;
            similarBlockGroups.add(group);
        }
    }

    public static boolean matchBlocks(Block b1, Block b2) {
        if (b1 == b2) {
            return true;
        }
        for (Set<Block> group : similarBlockGroups) {
            if (!group.contains(b1) || !group.contains(b2)) continue;
            return true;
        }
        return false;
    }
}

