/*
 * Decompiled with CFR 0.152.
 */
package axdev.magicconstruction.client;

import axdev.magicconstruction.containers.BlockPouchMenu;
import axdev.magicconstruction.items.wand.ItemWand;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;

public class BlockPouchScreen
extends AbstractContainerScreen<BlockPouchMenu> {
    private final int rows;
    private final int pouchCapacity;
    private final int pouchSize;
    private int currentItems = 0;
    private static final int BG_COLOR = -3750202;
    private static final int BORDER_WHITE = -1;
    private static final int BORDER_DARK = -11184811;
    private static final int BORDER_DARKER = -13158601;
    private static final int SLOT_BG = -7631989;
    private static final int SLOT_BORDER_DARK = -13158601;
    private static final int SLOT_BORDER_LIGHT = -1;
    private static final int TEXT_DARK = -12566464;

    public BlockPouchScreen(BlockPouchMenu menu, Inventory playerInv, Component title) {
        super((AbstractContainerMenu)menu, playerInv, title);
        this.pouchSize = menu.getPouchSize();
        this.rows = (int)Math.ceil((double)this.pouchSize / 9.0);
        this.f_97726_ = 176;
        this.f_97727_ = 18 + this.rows * 18 + 14 + 14 + 54 + 4 + 18 + 8 + 2;
        this.f_97731_ = 18 + this.rows * 18 + 14 + 4 + 2;
        this.pouchCapacity = ItemWand.getPouchCapacity(playerInv.f_35978_.m_21205_());
    }

    protected void m_7286_(GuiGraphics graphics, float partialTick, int mouseX, int mouseY) {
        int slotY;
        int slotX;
        int col;
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        this.drawPanel(graphics, x, y, this.f_97726_, this.f_97727_);
        int pouchY = y + 17;
        for (int row = 0; row < this.rows; ++row) {
            for (int col2 = 0; col2 < 9; ++col2) {
                int index = row * 9 + col2;
                if (index >= this.pouchSize) continue;
                int slotX2 = x + 7 + col2 * 18;
                int slotY2 = pouchY + row * 18;
                this.drawSlot(graphics, slotX2, slotY2);
            }
        }
        int capacityBarY = pouchY + this.rows * 18 + 4;
        this.drawCapacityBar(graphics, x + 7, capacityBarY, 162);
        int invY = capacityBarY + 14 + 12 + 2;
        for (int row = 0; row < 3; ++row) {
            for (col = 0; col < 9; ++col) {
                slotX = x + 7 + col * 18;
                slotY = invY + row * 18;
                this.drawSlot(graphics, slotX, slotY);
            }
        }
        int hotbarY = invY + 58;
        for (col = 0; col < 9; ++col) {
            slotX = x + 7 + col * 18;
            slotY = hotbarY;
            this.drawSlot(graphics, slotX, slotY);
        }
    }

    private void drawPanel(GuiGraphics graphics, int x, int y, int width, int height) {
        graphics.m_280509_(x, y, x + width, y + height, -3750202);
        graphics.m_280509_(x, y, x + width - 1, y + 1, -1);
        graphics.m_280509_(x, y, x + 1, y + height - 1, -1);
        graphics.m_280509_(x + 1, y + 1, x + width - 2, y + 2, -1);
        graphics.m_280509_(x + 1, y + 1, x + 2, y + height - 2, -1);
        graphics.m_280509_(x + width - 2, y + 2, x + width - 1, y + height - 1, -11184811);
        graphics.m_280509_(x + 2, y + height - 2, x + width - 1, y + height - 1, -11184811);
        graphics.m_280509_(x + width - 1, y + 1, x + width, y + height, -13158601);
        graphics.m_280509_(x + 1, y + height - 1, x + width, y + height, -13158601);
    }

    private void drawSlot(GuiGraphics graphics, int x, int y) {
        graphics.m_280509_(x, y, x + 18, y + 18, -7631989);
        graphics.m_280509_(x, y, x + 17, y + 1, -13158601);
        graphics.m_280509_(x, y, x + 1, y + 17, -13158601);
        graphics.m_280509_(x + 17, y + 1, x + 18, y + 18, -1);
        graphics.m_280509_(x + 1, y + 17, x + 18, y + 18, -1);
    }

    private void drawCapacityBar(GuiGraphics graphics, int x, int y, int width) {
        this.currentItems = 0;
        NonNullList<ItemStack> contents = ItemWand.getPouchContents(this.f_96541_.f_91074_.m_21205_());
        for (ItemStack stack : contents) {
            this.currentItems += stack.m_41613_();
        }
        graphics.m_280509_(x, y, x + width, y + 10, -13158601);
        graphics.m_280509_(x + 1, y + 1, x + width - 1, y + 9, -7631989);
        float fillPercent = this.pouchCapacity > 0 ? (float)this.currentItems / (float)this.pouchCapacity : 0.0f;
        int fillWidth = (int)((float)(width - 4) * fillPercent);
        if (fillWidth > 0) {
            int barColor;
            int n = fillPercent > 0.9f ? -1618884 : (barColor = fillPercent > 0.7f ? -812014 : -11163051);
            int barColorDark = fillPercent > 0.9f ? -4179669 : (fillPercent > 0.7f ? -2717424 : -12748227);
            graphics.m_280509_(x + 2, y + 2, x + 2 + fillWidth, y + 8, barColor);
            graphics.m_280509_(x + 2, y + 6, x + 2 + fillWidth, y + 8, barColorDark);
        }
        String capacityText = this.currentItems + " / " + this.pouchCapacity;
        int textWidth = this.f_96547_.m_92895_(capacityText);
        graphics.m_280056_(this.f_96547_, capacityText, x + (width - textWidth) / 2, y + 1, -1, false);
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
        this.m_280072_(graphics, mouseX, mouseY);
    }

    protected void m_280003_(GuiGraphics graphics, int mouseX, int mouseY) {
        graphics.m_280614_(this.f_96547_, this.f_96539_, this.f_97728_, 6, -12566464, false);
        String tierText = this.getTierText();
        int tierTextX = this.f_97726_ - this.f_96547_.m_92895_(tierText) - 7;
        graphics.m_280056_(this.f_96547_, tierText, tierTextX, 6, -12566464, false);
        graphics.m_280614_(this.f_96547_, this.f_169604_, this.f_97730_, this.f_97731_, -12566464, false);
    }

    private String getTierText() {
        int tier = ItemWand.getPouchTier(this.f_96541_.f_91074_.m_21205_());
        return switch (tier) {
            case 1 -> "Basic";
            case 2 -> "Iron";
            case 3 -> "Gold";
            case 4 -> "Diamond";
            default -> "";
        };
    }
}

