/*
 * Decompiled with CFR 0.152.
 */
package axdev.magicconstruction.client;

import axdev.magicconstruction.basics.ConfigClient;
import axdev.magicconstruction.basics.WandUtil;
import axdev.magicconstruction.items.wand.ItemWand;
import axdev.magicconstruction.wand.LedgeDetector;
import axdev.magicconstruction.wand.WandJob;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderHighlightEvent;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@OnlyIn(value=Dist.CLIENT)
public class RenderBlockPreview {
    private static final long UNDO_PREVIEW_TIMEOUT = 3000L;
    private WandJob wandJob;
    private WandJob ledgeWandJob;
    private BlockHitResult cachedLedgeResult;
    public Set<BlockPos> undoBlocks;
    private long undoBlocksTimestamp;

    @SubscribeEvent
    public void renderBlockHighlight(RenderHighlightEvent.Block event) {
        Set<BlockPos> blocks;
        if (event.getTarget().m_6662_() != HitResult.Type.BLOCK) {
            return;
        }
        BlockHitResult rtr = event.getTarget();
        Entity entity = event.getCamera().m_90592_();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        float colorR = 0.2f;
        float colorG = 0.6f;
        float colorB = 1.0f;
        ItemStack wand = WandUtil.holdingWand(player);
        if (wand == null) {
            return;
        }
        if (!player.m_6047_()) {
            if (this.wandJob == null || !RenderBlockPreview.compareRTR(this.wandJob.rayTraceResult, rtr) || !this.wandJob.wand.equals(wand) || this.wandJob.blockCount() < 2) {
                this.wandJob = ItemWand.getWandJob(player, player.m_9236_(), rtr, wand);
            }
            blocks = this.wandJob.getBlockPositions();
        } else if (this.undoBlocks != null && !this.undoBlocks.isEmpty() && !this.isUndoPreviewExpired()) {
            blocks = this.undoBlocks;
            colorR = 1.0f;
            colorG = 0.0f;
            colorB = 0.0f;
        } else {
            this.clearUndoBlocks();
            return;
        }
        if (blocks == null || blocks.isEmpty()) {
            return;
        }
        this.renderBlocks(event.getPoseStack(), event.getMultiBufferSource(), event.getPartialTick(), player, blocks, colorR, colorG, colorB);
        event.setCanceled(true);
    }

    @SubscribeEvent
    public void renderLedgePreview(RenderLevelStageEvent event) {
        Set<BlockPos> blocks;
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null) {
            return;
        }
        LocalPlayer player = mc.f_91074_;
        ItemStack wand = WandUtil.holdingWand((Player)player);
        PoseStack poseStack = event.getPoseStack();
        MultiBufferSource.BufferSource buffer = mc.m_91269_().m_110104_();
        if (this.undoBlocks != null && !this.undoBlocks.isEmpty()) {
            if (this.isUndoPreviewExpired()) {
                this.clearUndoBlocks();
            } else {
                this.renderBlocks(poseStack, (MultiBufferSource)buffer, event.getPartialTick(), (Player)player, this.undoBlocks, 1.0f, 0.0f, 0.0f);
                buffer.m_109911_();
                return;
            }
        }
        if (wand == null) {
            return;
        }
        if (!((Boolean)ConfigClient.SHOW_LEDGE_PREVIEW.get()).booleanValue()) {
            return;
        }
        if (mc.f_91077_ != null && mc.f_91077_.m_6662_() == HitResult.Type.BLOCK) {
            return;
        }
        BlockHitResult ledgeResult = LedgeDetector.detectLedge((Player)player, player.m_9236_());
        if (ledgeResult == null) {
            this.ledgeWandJob = null;
            this.cachedLedgeResult = null;
            return;
        }
        if (this.ledgeWandJob == null || this.cachedLedgeResult == null || !RenderBlockPreview.compareRTR(this.cachedLedgeResult, ledgeResult) || !this.ledgeWandJob.wand.equals(wand)) {
            this.ledgeWandJob = ItemWand.getWandJob((Player)player, player.m_9236_(), ledgeResult, wand);
            this.cachedLedgeResult = ledgeResult;
        }
        if ((blocks = this.ledgeWandJob.getBlockPositions()) == null || blocks.isEmpty()) {
            return;
        }
        this.renderBlocks(poseStack, (MultiBufferSource)buffer, event.getPartialTick(), (Player)player, blocks, 0.2f, 0.6f, 1.0f);
        buffer.m_109911_();
    }

    private void renderBlocks(PoseStack ms, MultiBufferSource buffer, float partialTicks, Player player, Set<BlockPos> blocks, float colorR, float colorG, float colorB) {
        VertexConsumer lineBuilder = buffer.m_6299_((RenderType)RenderType.f_110371_);
        double d0 = player.f_19790_ + (player.m_20185_() - player.f_19790_) * (double)partialTicks;
        double d1 = player.f_19791_ + (double)player.m_20192_() + (player.m_20186_() - player.f_19791_) * (double)partialTicks;
        double d2 = player.f_19792_ + (player.m_20189_() - player.f_19792_) * (double)partialTicks;
        for (BlockPos block : blocks) {
            AABB aabb = new AABB(block).m_82386_(-d0, -d1, -d2);
            LevelRenderer.m_109646_((PoseStack)ms, (VertexConsumer)lineBuilder, (AABB)aabb, (float)colorR, (float)colorG, (float)colorB, (float)0.4f);
        }
    }

    public BlockHitResult getLedgeResult(Player player) {
        if (Minecraft.m_91087_().f_91077_ != null && Minecraft.m_91087_().f_91077_.m_6662_() == HitResult.Type.BLOCK) {
            return null;
        }
        return LedgeDetector.detectLedge(player, player.m_9236_());
    }

    public void reset() {
        this.wandJob = null;
        this.ledgeWandJob = null;
        this.cachedLedgeResult = null;
    }

    private static boolean compareRTR(BlockHitResult rtr1, BlockHitResult rtr2) {
        if (rtr1 == null || rtr2 == null) {
            return false;
        }
        return rtr1.m_82425_().equals((Object)rtr2.m_82425_()) && rtr1.m_82434_().equals((Object)rtr2.m_82434_());
    }

    public void setUndoBlocks(Set<BlockPos> blocks) {
        this.undoBlocks = blocks;
        this.undoBlocksTimestamp = System.currentTimeMillis();
    }

    private boolean isUndoPreviewExpired() {
        return System.currentTimeMillis() - this.undoBlocksTimestamp >= 3000L;
    }

    private void clearUndoBlocks() {
        this.undoBlocks = null;
        this.undoBlocksTimestamp = 0L;
    }
}

