/*
 * Decompiled with CFR 0.152.
 */
package axdev.magicconstruction.containers;

import axdev.magicconstruction.containers.ModMenuTypes;
import axdev.magicconstruction.items.wand.ItemWand;
import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class BlockPouchMenu
extends AbstractContainerMenu {
    private final ItemStack wand;
    private final int pouchSize;
    private final SimpleContainer pouchContainer;

    public BlockPouchMenu(int containerId, Inventory playerInv, ItemStack wand) {
        super((MenuType)ModMenuTypes.BLOCK_POUCH_MENU.get(), containerId);
        int col;
        this.wand = wand;
        this.pouchSize = Math.min(36, ItemWand.getPouchCapacity(wand) / 64);
        this.pouchContainer = new SimpleContainer(this.pouchSize){

            public void m_6596_() {
                super.m_6596_();
                BlockPouchMenu.this.savePouchContents();
            }
        };
        this.loadPouchContents();
        int rows = (int)Math.ceil((double)this.pouchSize / 9.0);
        for (int row = 0; row < rows; ++row) {
            for (col = 0; col < 9; ++col) {
                int index = row * 9 + col;
                if (index >= this.pouchSize) continue;
                this.m_38897_(new PouchSlot((Container)this.pouchContainer, index, 8 + col * 18, 18 + row * 18, wand));
            }
        }
        int invY = 18 + rows * 18 + 14 + 14 + 4;
        for (int row = 0; row < 3; ++row) {
            for (int col2 = 0; col2 < 9; ++col2) {
                this.m_38897_(new Slot((Container)playerInv, col2 + row * 9 + 9, 8 + col2 * 18, invY + row * 18));
            }
        }
        for (col = 0; col < 9; ++col) {
            this.m_38897_(new Slot((Container)playerInv, col, 8 + col * 18, invY + 58));
        }
    }

    private void loadPouchContents() {
        NonNullList<ItemStack> contents = ItemWand.getPouchContents(this.wand);
        for (int i = 0; i < contents.size() && i < this.pouchSize; ++i) {
            this.pouchContainer.m_6836_(i, ((ItemStack)contents.get(i)).m_41777_());
        }
    }

    private void savePouchContents() {
        NonNullList contents = NonNullList.m_122779_();
        for (int i = 0; i < this.pouchSize; ++i) {
            ItemStack stack = this.pouchContainer.m_8020_(i);
            if (stack.m_41619_()) continue;
            contents.add((Object)stack.m_41777_());
        }
        ItemWand.setPouchContents(this.wand, (NonNullList<ItemStack>)contents);
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack slotStack = slot.m_7993_();
            if (slotStack == this.wand || ItemStack.m_41656_((ItemStack)slotStack, (ItemStack)this.wand)) {
                return ItemStack.f_41583_;
            }
            itemstack = slotStack.m_41777_();
            if (index < this.pouchSize ? !this.m_38903_(slotStack, this.pouchSize, this.f_38839_.size(), true) : !this.m_38903_(slotStack, 0, this.pouchSize, false)) {
                return ItemStack.f_41583_;
            }
            if (slotStack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return itemstack;
    }

    public boolean m_6875_(Player player) {
        return player.m_21205_() == this.wand || player.m_21206_() == this.wand;
    }

    public void m_6877_(Player player) {
        super.m_6877_(player);
        this.savePouchContents();
    }

    public int getPouchSize() {
        return this.pouchSize;
    }

    private static class PouchSlot
    extends Slot {
        private final ItemStack wand;

        public PouchSlot(Container container, int slot, int x, int y, ItemStack wand) {
            super(container, slot, x, y);
            this.wand = wand;
        }

        public boolean m_5857_(ItemStack stack) {
            return stack != this.wand && !ItemStack.m_41656_((ItemStack)stack, (ItemStack)this.wand);
        }
    }
}

