/*
 * Decompiled with CFR 0.152.
 */
package axdev.magicconstruction.crafting;

import axdev.magicconstruction.crafting.ModRecipes;
import axdev.magicconstruction.items.ItemBlockPouch;
import axdev.magicconstruction.items.wand.ItemWand;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;

public class WandPouchRecipe
extends CustomRecipe {
    public WandPouchRecipe(ResourceLocation id, CraftingBookCategory category) {
        super(id, category);
    }

    public boolean matches(CraftingContainer container, Level level) {
        ItemStack wandStack = ItemStack.f_41583_;
        ItemStack pouchStack = ItemStack.f_41583_;
        int itemCount = 0;
        for (int i = 0; i < container.m_6643_(); ++i) {
            ItemStack stack = container.m_8020_(i);
            if (stack.m_41619_()) continue;
            ++itemCount;
            if (stack.m_41720_() instanceof ItemWand) {
                if (!wandStack.m_41619_()) {
                    return false;
                }
                wandStack = stack;
                continue;
            }
            if (stack.m_41720_() instanceof ItemBlockPouch) {
                if (!pouchStack.m_41619_()) {
                    return false;
                }
                pouchStack = stack;
                continue;
            }
            return false;
        }
        if (wandStack.m_41619_() || pouchStack.m_41619_() || itemCount != 2) {
            return false;
        }
        return !ItemWand.hasPouch(wandStack);
    }

    public ItemStack assemble(CraftingContainer container, RegistryAccess registryAccess) {
        ItemStack wandStack = ItemStack.f_41583_;
        ItemStack pouchStack = ItemStack.f_41583_;
        for (int i = 0; i < container.m_6643_(); ++i) {
            ItemStack stack = container.m_8020_(i);
            if (stack.m_41619_()) continue;
            if (stack.m_41720_() instanceof ItemWand) {
                wandStack = stack;
                continue;
            }
            if (!(stack.m_41720_() instanceof ItemBlockPouch)) continue;
            pouchStack = stack;
        }
        if (wandStack.m_41619_() || pouchStack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        ItemStack result = wandStack.m_41777_();
        ItemBlockPouch pouch = (ItemBlockPouch)pouchStack.m_41720_();
        ItemWand.setPouchTier(result, pouch.getTier());
        return result;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer container) {
        return NonNullList.m_122780_((int)container.m_6643_(), (Object)ItemStack.f_41583_);
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipes.WAND_POUCH_SERIALIZER.get();
    }
}

