/*
 * Decompiled with CFR 0.152.
 */
package axdev.magicconstruction.items.wand;

import axdev.magicconstruction.containers.BlockPouchMenu;
import axdev.magicconstruction.wand.LedgeDetector;
import axdev.magicconstruction.wand.WandJob;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemWand
extends Item {
    private static final String TAG_POUCH = "block_pouch";
    private static final String TAG_POUCH_TIER = "pouch_tier";
    private static final int[] POUCH_CAPACITIES = new int[]{0, 128, 256, 512, 2048};
    private final int limit;
    private final Item repairItem;

    public ItemWand(Item.Properties properties, int limit, Item repairItem) {
        super(properties);
        this.limit = limit;
        this.repairItem = repairItem;
    }

    public int getLimit() {
        return this.limit;
    }

    public static int getPouchTier(ItemStack wand) {
        CompoundTag tag = wand.m_41784_();
        return tag.m_128451_(TAG_POUCH_TIER);
    }

    public static void setPouchTier(ItemStack wand, int tier) {
        CompoundTag tag = wand.m_41784_();
        tag.m_128405_(TAG_POUCH_TIER, tier);
    }

    public static int getPouchCapacity(ItemStack wand) {
        int tier = ItemWand.getPouchTier(wand);
        if (tier < 0 || tier >= POUCH_CAPACITIES.length) {
            return 0;
        }
        return POUCH_CAPACITIES[tier];
    }

    public static boolean hasPouch(ItemStack wand) {
        return ItemWand.getPouchTier(wand) > 0;
    }

    @Nonnull
    public InteractionResult m_6225_(UseOnContext context) {
        Player player = context.m_43723_();
        InteractionHand hand = context.m_43724_();
        Level world = context.m_43725_();
        if (world.f_46443_ || player == null) {
            return InteractionResult.FAIL;
        }
        ItemStack stack = player.m_21120_(hand);
        if (player.m_6047_()) {
            if (ItemWand.hasPouch(stack)) {
                this.openPouchGui(player, stack);
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        }
        WandJob job = ItemWand.getWandJob(player, world, new BlockHitResult(context.m_43720_(), context.m_43719_(), context.m_8083_(), false), stack);
        return job.doIt() ? InteractionResult.SUCCESS : InteractionResult.FAIL;
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(@Nonnull Level world, Player player, @Nonnull InteractionHand hand) {
        WandJob job;
        BlockHitResult ledgeResult;
        ItemStack stack = player.m_21120_(hand);
        if (player.m_6047_()) {
            if (ItemWand.hasPouch(stack)) {
                if (!world.f_46443_) {
                    this.openPouchGui(player, stack);
                }
                return InteractionResultHolder.m_19090_((Object)stack);
            }
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        if (!world.f_46443_ && (ledgeResult = LedgeDetector.detectLedge(player, world)) != null && (job = ItemWand.getWandJob(player, world, ledgeResult, stack)).doIt()) {
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    private void openPouchGui(Player player, final ItemStack wand) {
        player.m_5893_(new MenuProvider(){

            public Component m_5446_() {
                return Component.m_237115_((String)"magicconstruction.gui.block_pouch");
            }

            public AbstractContainerMenu m_7208_(int containerId, Inventory playerInv, Player player) {
                return new BlockPouchMenu(containerId, playerInv, wand);
            }
        });
    }

    public static WandJob getWandJob(Player player, Level world, @Nullable BlockHitResult rayTraceResult, ItemStack wand) {
        WandJob wandJob = new WandJob(player, world, rayTraceResult, wand);
        wandJob.getSnapshots();
        return wandJob;
    }

    public boolean m_8096_(@Nonnull BlockState blockIn) {
        return false;
    }

    public boolean m_6832_(@Nonnull ItemStack toRepair, @Nonnull ItemStack repair) {
        return repair.m_41720_() == this.repairItem;
    }

    public int remainingDurability(ItemStack stack) {
        return stack.m_41776_() - stack.m_41773_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(@Nonnull ItemStack itemstack, @Nullable Level world, @Nonnull List<Component> lines, @Nonnull TooltipFlag extraInfo) {
        lines.add((Component)Component.m_237110_((String)"magicconstruction.tooltip.blocks", (Object[])new Object[]{this.limit}).m_130940_(ChatFormatting.GRAY));
        if (ItemWand.hasPouch(itemstack)) {
            NonNullList<ItemStack> contents = ItemWand.getPouchContents(itemstack);
            int total = ItemWand.countPouchItems(contents);
            int capacity = ItemWand.getPouchCapacity(itemstack);
            lines.add((Component)Component.m_237110_((String)"magicconstruction.tooltip.pouch", (Object[])new Object[]{total, capacity}).m_130940_(ChatFormatting.AQUA));
            if (!contents.isEmpty()) {
                int shown = 0;
                for (ItemStack stack : contents) {
                    if (shown >= 5) {
                        lines.add((Component)Component.m_237110_((String)"magicconstruction.tooltip.and_more", (Object[])new Object[]{contents.size() - 5}).m_130940_(ChatFormatting.DARK_GRAY));
                        break;
                    }
                    lines.add((Component)Component.m_237113_((String)("  " + stack.m_41613_() + "x ")).m_130940_(ChatFormatting.DARK_GRAY).m_7220_((Component)stack.m_41786_().m_6881_().m_130940_(ChatFormatting.GRAY)));
                    ++shown;
                }
            }
            lines.add((Component)Component.m_237115_((String)"magicconstruction.tooltip.shift_pouch").m_130940_(ChatFormatting.DARK_GRAY));
        }
    }

    public static NonNullList<ItemStack> getPouchContents(ItemStack wand) {
        NonNullList contents = NonNullList.m_122779_();
        CompoundTag tag = wand.m_41784_();
        if (tag.m_128441_(TAG_POUCH)) {
            ListTag list = tag.m_128437_(TAG_POUCH, 10);
            for (int i = 0; i < list.size(); ++i) {
                CompoundTag itemTag = list.m_128728_(i);
                ItemStack stack = ItemStack.m_41712_((CompoundTag)itemTag);
                if (stack.m_41619_()) continue;
                contents.add((Object)stack);
            }
        }
        return contents;
    }

    public static void setPouchContents(ItemStack wand, NonNullList<ItemStack> contents) {
        CompoundTag tag = wand.m_41784_();
        ListTag list = new ListTag();
        for (ItemStack stack : contents) {
            if (stack.m_41619_()) continue;
            CompoundTag itemTag = new CompoundTag();
            stack.m_41739_(itemTag);
            list.add((Object)itemTag);
        }
        tag.m_128365_(TAG_POUCH, (Tag)list);
    }

    public static ItemStack addToPouchContents(ItemStack wand, ItemStack toAdd) {
        int canAddTotal;
        int currentTotal;
        NonNullList<ItemStack> contents = ItemWand.getPouchContents(wand);
        int remaining = toAdd.m_41613_();
        int maxStack = toAdd.m_41741_();
        int capacity = ItemWand.getPouchCapacity(wand);
        int availableSpace = capacity - (currentTotal = ItemWand.countPouchItems(contents));
        if (availableSpace <= 0) {
            return toAdd.m_41777_();
        }
        int toAddNow = canAddTotal = Math.min(remaining, availableSpace);
        for (ItemStack stack : contents) {
            int canAdd;
            if (toAddNow <= 0) break;
            if (!ItemStack.m_150942_((ItemStack)stack, (ItemStack)toAdd) || (canAdd = maxStack - stack.m_41613_()) <= 0) continue;
            int toTransfer = Math.min(canAdd, toAddNow);
            stack.m_41769_(toTransfer);
            toAddNow -= toTransfer;
        }
        while (toAddNow > 0) {
            ItemStack newStack = toAdd.m_41777_();
            int stackSize = Math.min(toAddNow, maxStack);
            newStack.m_41764_(stackSize);
            contents.add((Object)newStack);
            toAddNow -= stackSize;
        }
        ItemWand.setPouchContents(wand, contents);
        int leftover = remaining - canAddTotal;
        if (leftover > 0) {
            ItemStack result = toAdd.m_41777_();
            result.m_41764_(leftover);
            return result;
        }
        return ItemStack.f_41583_;
    }

    public static boolean consumeFromPouch(ItemStack wand, Item item, int amount) {
        NonNullList<ItemStack> contents = ItemWand.getPouchContents(wand);
        for (int i = 0; i < contents.size(); ++i) {
            ItemStack stack = (ItemStack)contents.get(i);
            if (stack.m_41720_() != item || stack.m_41613_() < amount) continue;
            stack.m_41774_(amount);
            if (stack.m_41619_()) {
                contents.remove(i);
            }
            ItemWand.setPouchContents(wand, contents);
            return true;
        }
        return false;
    }

    public static int countInPouch(ItemStack wand, Item item) {
        NonNullList<ItemStack> contents = ItemWand.getPouchContents(wand);
        for (ItemStack stack : contents) {
            if (stack.m_41720_() != item) continue;
            return stack.m_41613_();
        }
        return 0;
    }

    private static int countPouchItems(NonNullList<ItemStack> contents) {
        int total = 0;
        for (ItemStack stack : contents) {
            total += stack.m_41613_();
        }
        return total;
    }
}

