/*
 * Decompiled with CFR 0.152.
 */
package axdev.magicconstruction.wand;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class LedgeDetector {
    private static final double MAX_DISTANCE = 6.0;
    private static final double STEP = 0.25;

    @Nullable
    public static BlockHitResult detectLedge(Player player, Level world) {
        Vec3 eyePos = player.m_20299_(1.0f);
        Vec3 lookVec = player.m_20154_();
        for (double d = 1.0; d <= 6.0; d += 0.25) {
            Vec3 checkPos = eyePos.m_82549_(lookVec.m_82490_(d));
            BlockPos blockPos = new BlockPos((int)Math.floor(checkPos.f_82479_), (int)Math.floor(checkPos.f_82480_), (int)Math.floor(checkPos.f_82481_));
            if (!world.m_46859_(blockPos)) {
                return null;
            }
            BlockHitResult ledge = LedgeDetector.findAdjacentLedge(world, checkPos, blockPos, lookVec);
            if (ledge == null) continue;
            return ledge;
        }
        return null;
    }

    @Nullable
    private static BlockHitResult findAdjacentLedge(Level world, Vec3 checkPos, BlockPos airPos, Vec3 lookVec) {
        Direction[] searchOrder;
        Direction primaryDir = LedgeDetector.getPrimaryLookDirection(lookVec);
        for (Direction dir : searchOrder = LedgeDetector.getSearchOrder(primaryDir, lookVec)) {
            BlockPos adjacentPos = airPos.m_121945_(dir);
            if (world.m_46859_(adjacentPos)) continue;
            BlockPos placePos = airPos;
            Direction hitFace = dir.m_122424_();
            if (!LedgeDetector.isValidLedgePlacement(world, placePos, adjacentPos)) continue;
            Vec3 hitLocation = Vec3.m_82512_((Vec3i)adjacentPos).m_82520_((double)hitFace.m_122429_() * 0.5, (double)hitFace.m_122430_() * 0.5, (double)hitFace.m_122431_() * 0.5);
            return new BlockHitResult(hitLocation, hitFace, adjacentPos, false);
        }
        return null;
    }

    private static Direction getPrimaryLookDirection(Vec3 lookVec) {
        double absX = Math.abs(lookVec.f_82479_);
        double absY = Math.abs(lookVec.f_82480_);
        double absZ = Math.abs(lookVec.f_82481_);
        if (absY >= absX && absY >= absZ) {
            return lookVec.f_82480_ > 0.0 ? Direction.UP : Direction.DOWN;
        }
        if (absX >= absZ) {
            return lookVec.f_82479_ > 0.0 ? Direction.EAST : Direction.WEST;
        }
        return lookVec.f_82481_ > 0.0 ? Direction.SOUTH : Direction.NORTH;
    }

    private static Direction[] getSearchOrder(Direction primary, Vec3 lookVec) {
        Direction[] all = Direction.values();
        Direction[] result = new Direction[6];
        int idx = 0;
        for (Direction dir : all) {
            if (dir == primary || dir == primary.m_122424_()) continue;
            result[idx++] = dir;
        }
        result[idx++] = primary;
        result[idx] = primary.m_122424_();
        return result;
    }

    private static boolean isValidLedgePlacement(Level world, BlockPos placePos, BlockPos supportPos) {
        if (!world.m_46859_(placePos)) {
            return false;
        }
        return !world.m_46859_(supportPos);
    }
}

