/*
 * Decompiled with CFR 0.152.
 */
package axdev.magicconstruction.wand;

import axdev.magicconstruction.basics.ReplacementRegistry;
import axdev.magicconstruction.basics.WandUtil;
import axdev.magicconstruction.items.wand.ItemWand;
import axdev.magicconstruction.wand.undo.ISnapshot;
import axdev.magicconstruction.wand.undo.PlaceSnapshot;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class PlaceAction {
    public static List<ISnapshot> getSnapshots(Level world, Player player, BlockHitResult rayTraceResult, ItemStack wand, BlockItem targetItem, int limit) {
        LinkedList<ISnapshot> placeSnapshots = new LinkedList<ISnapshot>();
        LinkedList<BlockPos> candidates = new LinkedList<BlockPos>();
        HashSet<BlockPos> allCandidates = new HashSet<BlockPos>();
        Direction placeDirection = rayTraceResult.m_82434_();
        BlockState targetBlock = world.m_8055_(rayTraceResult.m_82425_());
        BlockPos startingPoint = rayTraceResult.m_82425_().m_121955_(placeDirection.m_122436_());
        candidates.add(startingPoint);
        int availableItems = PlaceAction.countAvailableItems(player, wand, targetItem);
        while (!candidates.isEmpty() && placeSnapshots.size() < limit && placeSnapshots.size() < availableItems) {
            BlockPos currentCandidate = (BlockPos)candidates.removeFirst();
            try {
                PlaceSnapshot snapshot;
                BlockPos supportingPoint = currentCandidate.m_121955_(placeDirection.m_122424_().m_122436_());
                BlockState candidateSupportingBlock = world.m_8055_(supportingPoint);
                if (!PlaceAction.matchBlocks(targetBlock.m_60734_(), candidateSupportingBlock.m_60734_()) || !allCandidates.add(currentCandidate) || !WandUtil.isPositionPlaceable(world, player, currentCandidate, true) || (snapshot = PlaceAction.createSnapshot(world, player, rayTraceResult, currentCandidate, targetItem, candidateSupportingBlock)) == null) continue;
                placeSnapshots.add(snapshot);
                PlaceAction.addNeighbors(candidates, currentCandidate, placeDirection);
            }
            catch (Exception exception) {}
        }
        return placeSnapshots;
    }

    private static int countAvailableItems(Player player, ItemStack wand, BlockItem targetItem) {
        if (player.m_7500_()) {
            return Integer.MAX_VALUE;
        }
        int count = 0;
        if (ItemWand.hasPouch(wand)) {
            count += ItemWand.countInPouch(wand, (Item)targetItem);
        }
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            ItemStack stack = player.m_150109_().m_8020_(i);
            if (stack.m_41720_() != targetItem) continue;
            count += stack.m_41613_();
        }
        return count;
    }

    private static boolean matchBlocks(Block b1, Block b2) {
        return b1 == b2 || ReplacementRegistry.matchBlocks(b1, b2);
    }

    private static PlaceSnapshot createSnapshot(Level world, Player player, BlockHitResult rayTraceResult, BlockPos pos, BlockItem item, BlockState supportingBlock) {
        BlockHitResult blockRayTraceResult = new BlockHitResult(Vec3.m_82512_((Vec3i)pos), rayTraceResult.m_82434_(), pos, false);
        UseOnContext useContext = new UseOnContext(player, player.m_7655_(), blockRayTraceResult);
        BlockPlaceContext context = new BlockPlaceContext(useContext);
        BlockState placementState = item.m_40614_().m_5573_(context);
        if (placementState == null) {
            return null;
        }
        if (!WandUtil.isTEAllowed(placementState)) {
            return null;
        }
        return new PlaceSnapshot(placementState, pos, new ItemStack((ItemLike)item));
    }

    private static void addNeighbors(LinkedList<BlockPos> candidates, BlockPos current, Direction placeDirection) {
        switch (placeDirection) {
            case DOWN: 
            case UP: {
                candidates.add(current.m_121955_(Direction.NORTH.m_122436_()));
                candidates.add(current.m_121955_(Direction.SOUTH.m_122436_()));
                candidates.add(current.m_121955_(Direction.EAST.m_122436_()));
                candidates.add(current.m_121955_(Direction.WEST.m_122436_()));
                break;
            }
            case NORTH: 
            case SOUTH: {
                candidates.add(current.m_121955_(Direction.EAST.m_122436_()));
                candidates.add(current.m_121955_(Direction.WEST.m_122436_()));
                candidates.add(current.m_121955_(Direction.UP.m_122436_()));
                candidates.add(current.m_121955_(Direction.DOWN.m_122436_()));
                break;
            }
            case EAST: 
            case WEST: {
                candidates.add(current.m_121955_(Direction.NORTH.m_122436_()));
                candidates.add(current.m_121955_(Direction.SOUTH.m_122436_()));
                candidates.add(current.m_121955_(Direction.UP.m_122436_()));
                candidates.add(current.m_121955_(Direction.DOWN.m_122436_()));
            }
        }
    }
}

