/*
 * Decompiled with CFR 0.152.
 */
package axdev.magicconstruction.wand;

import axdev.magicconstruction.MagicConstruction;
import axdev.magicconstruction.basics.ModStats;
import axdev.magicconstruction.items.wand.ItemWand;
import axdev.magicconstruction.wand.PlaceAction;
import axdev.magicconstruction.wand.undo.ISnapshot;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class WandJob {
    public final Player player;
    public final Level world;
    public final BlockHitResult rayTraceResult;
    public final ItemStack wand;
    public final ItemWand wandItem;
    private List<ISnapshot> placeSnapshots;

    public WandJob(Player player, Level world, BlockHitResult rayTraceResult, ItemStack wand) {
        this.player = player;
        this.world = world;
        this.rayTraceResult = rayTraceResult;
        this.placeSnapshots = new ArrayList<ISnapshot>();
        this.wand = wand;
        this.wandItem = (ItemWand)wand.m_41720_();
    }

    @Nullable
    private BlockItem getTargetItem() {
        Item tgitem = this.world.m_8055_(this.rayTraceResult.m_82425_()).m_60734_().m_5456_();
        if (!(tgitem instanceof BlockItem)) {
            return null;
        }
        return (BlockItem)tgitem;
    }

    public void getSnapshots() {
        if (this.rayTraceResult.m_6662_() != HitResult.Type.BLOCK) {
            return;
        }
        int limit = Math.min(this.wandItem.remainingDurability(this.wand), this.wandItem.getLimit());
        BlockItem targetItem = this.getTargetItem();
        if (targetItem == null) {
            return;
        }
        this.placeSnapshots = PlaceAction.getSnapshots(this.world, this.player, this.rayTraceResult, this.wand, targetItem, limit);
    }

    public Set<BlockPos> getBlockPositions() {
        return this.placeSnapshots.stream().map(ISnapshot::getPos).collect(Collectors.toSet());
    }

    public int blockCount() {
        return this.placeSnapshots.size();
    }

    public boolean doIt() {
        ArrayList<ISnapshot> executed = new ArrayList<ISnapshot>();
        BlockItem targetItem = this.getTargetItem();
        for (ISnapshot snapshot : this.placeSnapshots) {
            if (this.wand.m_41619_() || this.wandItem.remainingDurability(this.wand) == 0) break;
            if (!snapshot.execute(this.world, this.player, this.rayTraceResult)) continue;
            if (this.player.m_7500_()) {
                executed.add(snapshot);
            } else {
                boolean consumed = this.consumeItem(targetItem);
                if (consumed) {
                    executed.add(snapshot);
                    this.wand.m_41622_(1, (LivingEntity)this.player, p -> {});
                } else {
                    snapshot.forceRestore(this.world);
                }
            }
            this.player.m_36220_(ModStats.USE_WAND);
        }
        this.placeSnapshots = executed;
        if (!this.placeSnapshots.isEmpty()) {
            SoundType sound = this.placeSnapshots.get(0).getBlockState().m_60827_();
            this.world.m_5594_(null, this.player.m_20183_(), sound.m_56777_(), SoundSource.BLOCKS, sound.f_56731_, sound.f_56732_);
            MagicConstruction.instance.undoHistory.add(this.player, this.world, this.placeSnapshots);
        }
        return !this.placeSnapshots.isEmpty();
    }

    private boolean consumeItem(BlockItem targetItem) {
        if (ItemWand.hasPouch(this.wand) && ItemWand.consumeFromPouch(this.wand, (Item)targetItem, 1)) {
            return true;
        }
        for (int i = 0; i < this.player.m_150109_().m_6643_(); ++i) {
            ItemStack stack = this.player.m_150109_().m_8020_(i);
            if (stack.m_41720_() != targetItem || stack.m_41613_() <= 0) continue;
            stack.m_41774_(1);
            if (stack.m_41619_()) {
                this.player.m_150109_().m_6836_(i, ItemStack.f_41583_);
            }
            return true;
        }
        return false;
    }
}

