/*
 * Decompiled with CFR 0.152.
 */
package axdev.magicconstruction.wand.undo;

import axdev.magicconstruction.basics.WandUtil;
import axdev.magicconstruction.wand.WandItemUseContext;
import axdev.magicconstruction.wand.undo.ISnapshot;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;

public class PlaceSnapshot
implements ISnapshot {
    private BlockState block;
    private final BlockPos pos;
    private final ItemStack requiredItem;

    public PlaceSnapshot(BlockState block, BlockPos pos, ItemStack requiredItem) {
        this.block = block;
        this.pos = pos;
        this.requiredItem = requiredItem;
    }

    @Override
    public BlockPos getPos() {
        return this.pos;
    }

    @Override
    public BlockState getBlockState() {
        return this.block;
    }

    @Override
    public ItemStack getRequiredItems() {
        return this.requiredItem;
    }

    @Override
    public boolean execute(Level world, Player player, BlockHitResult rayTraceResult) {
        BlockItem item = (BlockItem)this.requiredItem.m_41720_();
        WandItemUseContext ctx = new WandItemUseContext(world, player, rayTraceResult, this.pos, item);
        BlockState newState = item.m_40614_().m_5573_((BlockPlaceContext)ctx);
        if (newState == null || !newState.m_60710_((LevelReader)world, this.pos)) {
            newState = this.block;
        }
        if (!WandUtil.isTEAllowed(newState)) {
            return false;
        }
        if (WandUtil.entitiesCollidingWithBlock(world, newState, this.pos)) {
            return false;
        }
        this.block = newState;
        return WandUtil.placeBlock(world, player, this.block, this.pos, item);
    }

    @Override
    public boolean canRestore(Level world, Player player) {
        BlockState currentState = world.m_8055_(this.pos);
        if (currentState.m_60795_()) {
            return false;
        }
        return currentState.m_60734_() == this.block.m_60734_();
    }

    @Override
    public boolean restore(Level world, Player player) {
        BlockState currentState = world.m_8055_(this.pos);
        if (currentState.m_60795_()) {
            return false;
        }
        if (currentState.m_60734_() != this.block.m_60734_()) {
            return false;
        }
        return WandUtil.removeBlock(world, player, this.block, this.pos);
    }

    @Override
    public void forceRestore(Level world) {
        world.m_7471_(this.pos, false);
    }
}

