/*
 * Decompiled with CFR 0.152.
 */
package axdev.magicconstruction.client;

import axdev.magicconstruction.containers.BlockPouchScreenHandler;
import axdev.magicconstruction.items.wand.ItemWand;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_465;

public class BlockPouchScreen
extends class_465<BlockPouchScreenHandler> {
    private final int rows;
    private final int pouchCapacity;
    private final int pouchSize;
    private int currentItems = 0;
    private static final int BG_COLOR = -3750202;
    private static final int BORDER_WHITE = -1;
    private static final int BORDER_DARK = -11184811;
    private static final int BORDER_DARKER = -13158601;
    private static final int SLOT_BG = -7631989;
    private static final int SLOT_BORDER_DARK = -13158601;
    private static final int SLOT_BORDER_LIGHT = -1;
    private static final int TEXT_DARK = -12566464;

    public BlockPouchScreen(BlockPouchScreenHandler handler, class_1661 playerInv, class_2561 title) {
        super((class_1703)handler, playerInv, title);
        this.pouchSize = handler.getPouchSize();
        this.rows = (int)Math.ceil((double)this.pouchSize / 9.0);
        this.field_2792 = 176;
        this.field_2779 = 18 + this.rows * 18 + 14 + 14 + 54 + 4 + 18 + 8 + 2;
        this.field_25270 = 18 + this.rows * 18 + 14 + 4 + 2;
        this.pouchCapacity = ItemWand.getPouchCapacity(playerInv.field_7546.method_6047());
    }

    protected void method_2389(class_332 context, float delta, int mouseX, int mouseY) {
        int slotY;
        int slotX;
        int col;
        int x = (this.field_22789 - this.field_2792) / 2;
        int y = (this.field_22790 - this.field_2779) / 2;
        this.drawPanel(context, x, y, this.field_2792, this.field_2779);
        int pouchY = y + 17;
        for (int row = 0; row < this.rows; ++row) {
            for (int col2 = 0; col2 < 9; ++col2) {
                int index = row * 9 + col2;
                if (index >= this.pouchSize) continue;
                int slotX2 = x + 7 + col2 * 18;
                int slotY2 = pouchY + row * 18;
                this.drawSlot(context, slotX2, slotY2);
            }
        }
        int capacityBarY = pouchY + this.rows * 18 + 4;
        this.drawCapacityBar(context, x + 7, capacityBarY, 162);
        int invY = capacityBarY + 14 + 12 + 2;
        for (int row = 0; row < 3; ++row) {
            for (col = 0; col < 9; ++col) {
                slotX = x + 7 + col * 18;
                slotY = invY + row * 18;
                this.drawSlot(context, slotX, slotY);
            }
        }
        int hotbarY = invY + 58;
        for (col = 0; col < 9; ++col) {
            slotX = x + 7 + col * 18;
            slotY = hotbarY;
            this.drawSlot(context, slotX, slotY);
        }
    }

    private void drawPanel(class_332 context, int x, int y, int width, int height) {
        context.method_25294(x, y, x + width, y + height, -3750202);
        context.method_25294(x, y, x + width - 1, y + 1, -1);
        context.method_25294(x, y, x + 1, y + height - 1, -1);
        context.method_25294(x + 1, y + 1, x + width - 2, y + 2, -1);
        context.method_25294(x + 1, y + 1, x + 2, y + height - 2, -1);
        context.method_25294(x + width - 2, y + 2, x + width - 1, y + height - 1, -11184811);
        context.method_25294(x + 2, y + height - 2, x + width - 1, y + height - 1, -11184811);
        context.method_25294(x + width - 1, y + 1, x + width, y + height, -13158601);
        context.method_25294(x + 1, y + height - 1, x + width, y + height, -13158601);
    }

    private void drawSlot(class_332 context, int x, int y) {
        context.method_25294(x, y, x + 18, y + 18, -7631989);
        context.method_25294(x, y, x + 17, y + 1, -13158601);
        context.method_25294(x, y, x + 1, y + 17, -13158601);
        context.method_25294(x + 17, y + 1, x + 18, y + 18, -1);
        context.method_25294(x + 1, y + 17, x + 18, y + 18, -1);
    }

    private void drawCapacityBar(class_332 context, int x, int y, int width) {
        this.currentItems = 0;
        class_2371<class_1799> contents = ItemWand.getPouchContents(this.field_22787.field_1724.method_6047());
        for (class_1799 stack : contents) {
            this.currentItems += stack.method_7947();
        }
        context.method_25294(x, y, x + width, y + 10, -13158601);
        context.method_25294(x + 1, y + 1, x + width - 1, y + 9, -7631989);
        float fillPercent = this.pouchCapacity > 0 ? (float)this.currentItems / (float)this.pouchCapacity : 0.0f;
        int fillWidth = (int)((float)(width - 4) * fillPercent);
        if (fillWidth > 0) {
            int barColor;
            int n = fillPercent > 0.9f ? -1618884 : (barColor = fillPercent > 0.7f ? -812014 : -11163051);
            int barColorDark = fillPercent > 0.9f ? -4179669 : (fillPercent > 0.7f ? -2717424 : -12748227);
            context.method_25294(x + 2, y + 2, x + 2 + fillWidth, y + 8, barColor);
            context.method_25294(x + 2, y + 6, x + 2 + fillWidth, y + 8, barColorDark);
        }
        String capacityText = this.currentItems + " / " + this.pouchCapacity;
        int textWidth = this.field_22793.method_1727(capacityText);
        context.method_51433(this.field_22793, capacityText, x + (width - textWidth) / 2, y + 1, -1, false);
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        this.method_2380(context, mouseX, mouseY);
    }

    protected void method_2388(class_332 context, int mouseX, int mouseY) {
        context.method_51439(this.field_22793, this.field_22785, this.field_25267, 6, -12566464, false);
        String tierText = this.getTierText();
        int tierTextX = this.field_2792 - this.field_22793.method_1727(tierText) - 7;
        context.method_51433(this.field_22793, tierText, tierTextX, 6, -12566464, false);
        context.method_51439(this.field_22793, this.field_29347, this.field_25269, this.field_25270, -12566464, false);
    }

    private String getTierText() {
        int tier = ItemWand.getPouchTier(this.field_22787.field_1724.method_6047());
        return switch (tier) {
            case 1 -> "Basic";
            case 2 -> "Iron";
            case 3 -> "Gold";
            case 4 -> "Diamond";
            default -> "";
        };
    }
}

