/*
 * Decompiled with CFR 0.152.
 */
package axdev.magicconstruction.client;

import axdev.magicconstruction.basics.WandUtil;
import axdev.magicconstruction.items.wand.ItemWand;
import axdev.magicconstruction.wand.LedgeDetector;
import axdev.magicconstruction.wand.WandJob;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Set;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_3965;
import net.minecraft.class_4587;
import net.minecraft.class_746;
import net.minecraft.class_757;

public class RenderBlockPreview {
    private static final long UNDO_PREVIEW_TIMEOUT = 3000L;
    private static WandJob wandJob;
    private static WandJob ledgeWandJob;
    private static class_3965 cachedRayTrace;
    private static class_3965 cachedLedgeResult;
    private static Set<class_2338> undoBlocks;
    private static long undoBlocksTimestamp;

    public static void register() {
        WorldRenderEvents.BEFORE_BLOCK_OUTLINE.register((context, hitResult) -> {
            class_310 mc = class_310.method_1551();
            if (mc.field_1724 == null) {
                return true;
            }
            class_746 player = mc.field_1724;
            class_1799 wand = WandUtil.holdingWand((class_1657)player);
            if (wand == null) {
                return true;
            }
            if (hitResult != null && hitResult.method_17783() == class_239.class_240.field_1332) {
                class_3965 blockHit = (class_3965)hitResult;
                RenderBlockPreview.renderBlockHighlight(context, (class_1657)player, wand, blockHit);
                return false;
            }
            return true;
        });
        WorldRenderEvents.AFTER_TRANSLUCENT.register(context -> {
            Set<class_2338> blocks;
            class_310 mc = class_310.method_1551();
            if (mc.field_1724 == null) {
                return;
            }
            class_746 player = mc.field_1724;
            class_1799 wand = WandUtil.holdingWand((class_1657)player);
            if (undoBlocks != null && !undoBlocks.isEmpty()) {
                if (RenderBlockPreview.isUndoPreviewExpired()) {
                    RenderBlockPreview.clearUndoBlocks();
                } else {
                    RenderBlockPreview.renderBlocks(context, (class_1657)player, undoBlocks, 1.0f, 0.0f, 0.0f);
                    return;
                }
            }
            if (wand == null) {
                return;
            }
            if (mc.field_1765 != null && mc.field_1765.method_17783() == class_239.class_240.field_1332) {
                return;
            }
            class_3965 ledgeResult = LedgeDetector.detectLedge((class_1657)player, player.method_37908());
            if (ledgeResult == null) {
                ledgeWandJob = null;
                cachedLedgeResult = null;
                return;
            }
            if (ledgeWandJob == null || cachedLedgeResult == null || !RenderBlockPreview.compareRTR(cachedLedgeResult, ledgeResult) || !RenderBlockPreview.ledgeWandJob.wand.equals(wand)) {
                ledgeWandJob = ItemWand.getWandJob((class_1657)player, player.method_37908(), ledgeResult, wand);
                cachedLedgeResult = ledgeResult;
            }
            if ((blocks = ledgeWandJob.getBlockPositions()) == null || blocks.isEmpty()) {
                return;
            }
            RenderBlockPreview.renderBlocks(context, (class_1657)player, blocks, 0.2f, 0.6f, 1.0f);
        });
    }

    private static void renderBlockHighlight(WorldRenderContext context, class_1657 player, class_1799 wand, class_3965 rtr) {
        Set<class_2338> blocks;
        float colorR = 0.2f;
        float colorG = 0.6f;
        float colorB = 1.0f;
        if (!player.method_5715()) {
            if (wandJob == null || !RenderBlockPreview.compareRTR(cachedRayTrace, rtr) || !RenderBlockPreview.wandJob.wand.equals(wand) || wandJob.getBlockPositions().size() < 2) {
                wandJob = ItemWand.getWandJob(player, player.method_37908(), rtr, wand);
                cachedRayTrace = rtr;
            }
            blocks = wandJob.getBlockPositions();
        } else if (undoBlocks != null && !undoBlocks.isEmpty() && !RenderBlockPreview.isUndoPreviewExpired()) {
            blocks = undoBlocks;
            colorR = 1.0f;
            colorG = 0.0f;
            colorB = 0.0f;
        } else {
            RenderBlockPreview.clearUndoBlocks();
            return;
        }
        if (blocks == null || blocks.isEmpty()) {
            return;
        }
        RenderBlockPreview.renderBlocks(context, player, blocks, colorR, colorG, colorB);
    }

    private static void renderBlocks(WorldRenderContext context, class_1657 player, Set<class_2338> blocks, float colorR, float colorG, float colorB) {
        class_4587 matrices = context.matrixStack();
        if (matrices == null) {
            return;
        }
        class_243 camPos = context.camera().method_19326();
        class_289 tessellator = class_289.method_1348();
        class_287 buffer = tessellator.method_1349();
        RenderSystem.setShader(class_757::method_34540);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableDepthTest();
        RenderSystem.lineWidth((float)2.0f);
        matrices.method_22903();
        buffer.method_1328(class_293.class_5596.field_29344, class_290.field_1576);
        for (class_2338 block : blocks) {
            class_238 aabb = new class_238(block).method_989(-camPos.field_1352, -camPos.field_1351, -camPos.field_1350);
            RenderBlockPreview.drawBox(buffer, matrices, aabb, colorR, colorG, colorB, 0.4f);
        }
        tessellator.method_1350();
        RenderSystem.enableDepthTest();
        RenderSystem.disableBlend();
        matrices.method_22909();
    }

    private static void drawBox(class_287 buffer, class_4587 matrices, class_238 box, float red, float green, float blue, float alpha) {
        float minX = (float)box.field_1323;
        float minY = (float)box.field_1322;
        float minZ = (float)box.field_1321;
        float maxX = (float)box.field_1320;
        float maxY = (float)box.field_1325;
        float maxZ = (float)box.field_1324;
        buffer.method_22918(matrices.method_23760().method_23761(), minX, minY, minZ).method_22915(red, green, blue, alpha).method_1344();
        buffer.method_22918(matrices.method_23760().method_23761(), maxX, minY, minZ).method_22915(red, green, blue, alpha).method_1344();
        buffer.method_22918(matrices.method_23760().method_23761(), minX, minY, minZ).method_22915(red, green, blue, alpha).method_1344();
        buffer.method_22918(matrices.method_23760().method_23761(), minX, maxY, minZ).method_22915(red, green, blue, alpha).method_1344();
        buffer.method_22918(matrices.method_23760().method_23761(), minX, minY, minZ).method_22915(red, green, blue, alpha).method_1344();
        buffer.method_22918(matrices.method_23760().method_23761(), minX, minY, maxZ).method_22915(red, green, blue, alpha).method_1344();
        buffer.method_22918(matrices.method_23760().method_23761(), maxX, maxY, maxZ).method_22915(red, green, blue, alpha).method_1344();
        buffer.method_22918(matrices.method_23760().method_23761(), minX, maxY, maxZ).method_22915(red, green, blue, alpha).method_1344();
        buffer.method_22918(matrices.method_23760().method_23761(), maxX, maxY, maxZ).method_22915(red, green, blue, alpha).method_1344();
        buffer.method_22918(matrices.method_23760().method_23761(), maxX, minY, maxZ).method_22915(red, green, blue, alpha).method_1344();
        buffer.method_22918(matrices.method_23760().method_23761(), maxX, maxY, maxZ).method_22915(red, green, blue, alpha).method_1344();
        buffer.method_22918(matrices.method_23760().method_23761(), maxX, maxY, minZ).method_22915(red, green, blue, alpha).method_1344();
        buffer.method_22918(matrices.method_23760().method_23761(), minX, maxY, minZ).method_22915(red, green, blue, alpha).method_1344();
        buffer.method_22918(matrices.method_23760().method_23761(), maxX, maxY, minZ).method_22915(red, green, blue, alpha).method_1344();
        buffer.method_22918(matrices.method_23760().method_23761(), minX, maxY, minZ).method_22915(red, green, blue, alpha).method_1344();
        buffer.method_22918(matrices.method_23760().method_23761(), minX, maxY, maxZ).method_22915(red, green, blue, alpha).method_1344();
        buffer.method_22918(matrices.method_23760().method_23761(), maxX, minY, minZ).method_22915(red, green, blue, alpha).method_1344();
        buffer.method_22918(matrices.method_23760().method_23761(), maxX, maxY, minZ).method_22915(red, green, blue, alpha).method_1344();
        buffer.method_22918(matrices.method_23760().method_23761(), maxX, minY, minZ).method_22915(red, green, blue, alpha).method_1344();
        buffer.method_22918(matrices.method_23760().method_23761(), maxX, minY, maxZ).method_22915(red, green, blue, alpha).method_1344();
        buffer.method_22918(matrices.method_23760().method_23761(), minX, minY, maxZ).method_22915(red, green, blue, alpha).method_1344();
        buffer.method_22918(matrices.method_23760().method_23761(), maxX, minY, maxZ).method_22915(red, green, blue, alpha).method_1344();
        buffer.method_22918(matrices.method_23760().method_23761(), minX, minY, maxZ).method_22915(red, green, blue, alpha).method_1344();
        buffer.method_22918(matrices.method_23760().method_23761(), minX, maxY, maxZ).method_22915(red, green, blue, alpha).method_1344();
    }

    public static class_3965 getLedgeResult(class_1657 player) {
        class_310 mc = class_310.method_1551();
        if (mc.field_1765 != null && mc.field_1765.method_17783() == class_239.class_240.field_1332) {
            return null;
        }
        return LedgeDetector.detectLedge(player, player.method_37908());
    }

    public static void reset() {
        wandJob = null;
        ledgeWandJob = null;
        cachedRayTrace = null;
        cachedLedgeResult = null;
    }

    private static boolean compareRTR(class_3965 rtr1, class_3965 rtr2) {
        if (rtr1 == null || rtr2 == null) {
            return false;
        }
        return rtr1.method_17777().equals((Object)rtr2.method_17777()) && rtr1.method_17780().equals((Object)rtr2.method_17780());
    }

    public static void setUndoBlocks(Set<class_2338> blocks) {
        undoBlocks = blocks;
        undoBlocksTimestamp = System.currentTimeMillis();
    }

    private static boolean isUndoPreviewExpired() {
        return System.currentTimeMillis() - undoBlocksTimestamp >= 3000L;
    }

    private static void clearUndoBlocks() {
        undoBlocks = null;
        undoBlocksTimestamp = 0L;
    }
}

