/*
 * Decompiled with CFR 0.152.
 */
package axdev.magicconstruction.items.wand;

import axdev.magicconstruction.containers.BlockPouchScreenHandler;
import axdev.magicconstruction.wand.LedgeDetector;
import axdev.magicconstruction.wand.WandJob;
import java.util.List;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3908;
import net.minecraft.class_3965;

public class ItemWand
extends class_1792 {
    private static final String TAG_POUCH = "block_pouch";
    private static final String TAG_POUCH_TIER = "pouch_tier";
    private static final int[] POUCH_CAPACITIES = new int[]{0, 128, 256, 512, 2048};
    private final int limit;
    private final class_1792 repairItem;

    public ItemWand(class_1792.class_1793 settings, int limit, class_1792 repairItem) {
        super(settings);
        this.limit = limit;
        this.repairItem = repairItem;
    }

    public int getLimit() {
        return this.limit;
    }

    public static int getPouchTier(class_1799 wand) {
        class_2487 tag = wand.method_7948();
        return tag.method_10550(TAG_POUCH_TIER);
    }

    public static void setPouchTier(class_1799 wand, int tier) {
        class_2487 tag = wand.method_7948();
        tag.method_10569(TAG_POUCH_TIER, tier);
    }

    public static int getPouchCapacity(class_1799 wand) {
        int tier = ItemWand.getPouchTier(wand);
        if (tier < 0 || tier >= POUCH_CAPACITIES.length) {
            return 0;
        }
        return POUCH_CAPACITIES[tier];
    }

    public static boolean hasPouch(class_1799 wand) {
        return ItemWand.getPouchTier(wand) > 0;
    }

    public class_1269 method_7884(class_1838 context) {
        class_1657 player = context.method_8036();
        class_1268 hand = context.method_20287();
        class_1937 world = context.method_8045();
        if (world.field_9236 || player == null) {
            return class_1269.field_5814;
        }
        class_1799 stack = player.method_5998(hand);
        if (player.method_5715()) {
            if (ItemWand.hasPouch(stack)) {
                this.openPouchGui(player, stack);
                return class_1269.field_5812;
            }
            return class_1269.field_5811;
        }
        WandJob job = ItemWand.getWandJob(player, world, new class_3965(context.method_17698(), context.method_8038(), context.method_8037(), false), stack);
        return job.doIt() ? class_1269.field_5812 : class_1269.field_5814;
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, class_1268 hand) {
        WandJob job;
        class_3965 ledgeHit;
        class_1799 stack = player.method_5998(hand);
        if (player.method_5715()) {
            if (ItemWand.hasPouch(stack)) {
                if (!world.field_9236) {
                    this.openPouchGui(player, stack);
                }
                return class_1271.method_22427((Object)stack);
            }
            return class_1271.method_22430((Object)stack);
        }
        if (!world.field_9236 && (ledgeHit = LedgeDetector.detectLedge(player, world)) != null && (job = ItemWand.getWandJob(player, world, ledgeHit, stack)).doIt()) {
            return class_1271.method_22427((Object)stack);
        }
        return class_1271.method_22430((Object)stack);
    }

    private void openPouchGui(class_1657 player, final class_1799 wand) {
        player.method_17355((class_3908)new ExtendedScreenHandlerFactory(){

            public class_2561 method_5476() {
                return class_2561.method_43471((String)"magicconstruction.gui.block_pouch");
            }

            public class_1703 createMenu(int syncId, class_1661 playerInv, class_1657 p) {
                return new BlockPouchScreenHandler(syncId, playerInv, wand);
            }

            public void writeScreenOpeningData(class_3222 player, class_2540 buf) {
            }
        });
    }

    public static WandJob getWandJob(class_1657 player, class_1937 world, class_3965 rayTraceResult, class_1799 wand) {
        WandJob wandJob = new WandJob(player, world, rayTraceResult, wand);
        wandJob.getSnapshots();
        return wandJob;
    }

    public boolean method_7878(class_1799 stack, class_1799 ingredient) {
        return ingredient.method_7909() == this.repairItem;
    }

    public int remainingDurability(class_1799 stack) {
        return stack.method_7936() - stack.method_7919();
    }

    public void method_7851(class_1799 stack, class_1937 world, List<class_2561> tooltip, class_1836 context) {
        tooltip.add((class_2561)class_2561.method_43469((String)"magicconstruction.tooltip.blocks", (Object[])new Object[]{this.limit}).method_27692(class_124.field_1080));
        if (ItemWand.hasPouch(stack)) {
            class_2371<class_1799> contents = ItemWand.getPouchContents(stack);
            int total = ItemWand.countPouchItems(contents);
            int capacity = ItemWand.getPouchCapacity(stack);
            tooltip.add((class_2561)class_2561.method_43469((String)"magicconstruction.tooltip.pouch", (Object[])new Object[]{total, capacity}).method_27692(class_124.field_1075));
        }
    }

    public static class_2371<class_1799> getPouchContents(class_1799 wand) {
        class_2371 contents = class_2371.method_10211();
        class_2487 tag = wand.method_7948();
        if (tag.method_10545(TAG_POUCH)) {
            class_2499 list = tag.method_10554(TAG_POUCH, 10);
            for (int i = 0; i < list.size(); ++i) {
                class_2487 itemTag = list.method_10602(i);
                class_1799 stack = class_1799.method_7915((class_2487)itemTag);
                if (stack.method_7960()) continue;
                contents.add((Object)stack);
            }
        }
        return contents;
    }

    public static void setPouchContents(class_1799 wand, class_2371<class_1799> contents) {
        class_2487 tag = wand.method_7948();
        class_2499 list = new class_2499();
        for (class_1799 stack : contents) {
            if (stack.method_7960()) continue;
            class_2487 itemTag = new class_2487();
            stack.method_7953(itemTag);
            list.add((Object)itemTag);
        }
        tag.method_10566(TAG_POUCH, (class_2520)list);
    }

    public static boolean consumeFromPouch(class_1799 wand, class_1792 item, int amount) {
        class_2371<class_1799> contents = ItemWand.getPouchContents(wand);
        for (int i = 0; i < contents.size(); ++i) {
            class_1799 stack = (class_1799)contents.get(i);
            if (stack.method_7909() != item || stack.method_7947() < amount) continue;
            stack.method_7934(amount);
            if (stack.method_7960()) {
                contents.remove(i);
            }
            ItemWand.setPouchContents(wand, contents);
            return true;
        }
        return false;
    }

    public static int countInPouch(class_1799 wand, class_1792 item) {
        class_2371<class_1799> contents = ItemWand.getPouchContents(wand);
        for (class_1799 stack : contents) {
            if (stack.method_7909() != item) continue;
            return stack.method_7947();
        }
        return 0;
    }

    private static int countPouchItems(class_2371<class_1799> contents) {
        int total = 0;
        for (class_1799 stack : contents) {
            total += stack.method_7947();
        }
        return total;
    }
}

