/*
 * Decompiled with CFR 0.152.
 */
package axdev.magicconstruction.wand.undo;

import axdev.magicconstruction.network.PacketUndoBlocks;
import axdev.magicconstruction.wand.undo.ISnapshot;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public class UndoHistory {
    private static final long CONFIRM_TIMEOUT = 3000L;
    private final Map<UUID, PlayerHistory> history = new HashMap<UUID, PlayerHistory>();

    private PlayerHistory getHistory(class_1657 player) {
        return this.history.computeIfAbsent(player.method_5667(), k -> new PlayerHistory());
    }

    public void add(class_1657 player, class_1937 world, List<ISnapshot> snapshots) {
        PlayerHistory ph = this.getHistory(player);
        ph.entries.add(new UndoEntry(world, snapshots));
        ph.pendingConfirm = false;
        ph.lastUndoRequest = 0L;
        while (ph.entries.size() > 5) {
            ph.entries.remove(0);
        }
    }

    public void tryUndo(class_1657 player, class_1937 world, class_1799 wand) {
        PlayerHistory ph = this.getHistory(player);
        if (ph.entries.isEmpty()) {
            player.method_7353((class_2561)class_2561.method_43471((String)"magicconstruction.message.undo_empty").method_27692(class_124.field_1061), true);
            return;
        }
        long now = System.currentTimeMillis();
        if (ph.pendingConfirm && now - ph.lastUndoRequest < 3000L) {
            this.executeUndo(player, world, ph);
        } else {
            ph.pendingConfirm = true;
            ph.lastUndoRequest = now;
            this.sendUndoPreview(player, ph);
            player.method_7353((class_2561)class_2561.method_43471((String)"magicconstruction.message.undo_confirm").method_27692(class_124.field_1054), true);
        }
    }

    private void executeUndo(class_1657 player, class_1937 world, PlayerHistory ph) {
        UndoEntry entry = null;
        for (int i = ph.entries.size() - 1; i >= 0; --i) {
            if (!ph.entries.get((int)i).world.method_27983().equals(world.method_27983())) continue;
            entry = ph.entries.remove(i);
            break;
        }
        ph.pendingConfirm = false;
        ph.lastUndoRequest = 0L;
        if (entry == null) {
            player.method_7353((class_2561)class_2561.method_43471((String)"magicconstruction.message.undo_empty").method_27692(class_124.field_1061), true);
            return;
        }
        int undoneCount = 0;
        int skippedCount = 0;
        for (ISnapshot snapshot : entry.snapshots) {
            if (snapshot.canRestore(world)) {
                class_1799 returned = snapshot.restore(world);
                if (returned.method_7960()) continue;
                if (!player.method_31548().method_7394(returned)) {
                    player.method_7328(returned, false);
                }
                ++undoneCount;
                continue;
            }
            ++skippedCount;
        }
        if (undoneCount > 0) {
            if (skippedCount > 0) {
                player.method_7353((class_2561)class_2561.method_43469((String)"magicconstruction.message.undo_partial", (Object[])new Object[]{undoneCount, skippedCount}).method_27692(class_124.field_1054), true);
            } else {
                player.method_7353((class_2561)class_2561.method_43469((String)"magicconstruction.message.undo_success", (Object[])new Object[]{undoneCount}).method_27692(class_124.field_1060), true);
            }
        } else {
            player.method_7353((class_2561)class_2561.method_43471((String)"magicconstruction.message.undo_failed").method_27692(class_124.field_1061), true);
        }
        this.clearUndoPreview(player);
    }

    private void sendUndoPreview(class_1657 player, PlayerHistory ph) {
        if (ph.entries.isEmpty()) {
            return;
        }
        UndoEntry entry = ph.entries.get(ph.entries.size() - 1);
        if (!entry.world.method_27983().equals(player.method_37908().method_27983())) {
            return;
        }
        Set<class_2338> positions = entry.snapshots.stream().map(ISnapshot::getPos).collect(Collectors.toSet());
        if (player instanceof class_3222) {
            class_3222 sp = (class_3222)player;
            PacketUndoBlocks.send(sp, positions);
        }
    }

    private void clearUndoPreview(class_1657 player) {
        if (player instanceof class_3222) {
            class_3222 sp = (class_3222)player;
            PacketUndoBlocks.send(sp, Collections.emptySet());
        }
    }

    public boolean hasPendingConfirm(class_1657 player) {
        PlayerHistory ph = this.getHistory(player);
        if (!ph.pendingConfirm) {
            return false;
        }
        long now = System.currentTimeMillis();
        if (now - ph.lastUndoRequest >= 3000L) {
            ph.pendingConfirm = false;
            return false;
        }
        return true;
    }

    private static class PlayerHistory {
        public final LinkedList<UndoEntry> entries = new LinkedList();
        public boolean pendingConfirm = false;
        public long lastUndoRequest = 0L;

        private PlayerHistory() {
        }
    }

    private static class UndoEntry {
        public final class_1937 world;
        public final List<ISnapshot> snapshots;

        UndoEntry(class_1937 world, List<ISnapshot> snapshots) {
            this.world = world;
            this.snapshots = snapshots;
        }
    }
}

