/*
 * Decompiled with CFR 0.152.
 */
package me.kall.duplicationless.mixin.event;

import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import me.kall.duplicationless.event.EntityChunkChangeEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Entity.class})
public abstract class EntityMixin {
    @Shadow
    public abstract ChunkPos chunkPosition();

    @Inject(method={"setPosRaw(DDD)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/ChunkPos;<init>(Lnet/minecraft/core/BlockPos;)V")})
    private void beforeChunkPosUpdate(CallbackInfo ci) {
        NeoForge.EVENT_BUS.post((Event)new EntityChunkChangeEvent.Before((Entity)this));
    }

    @WrapMethod(method={"setPosRaw(DDD)V"})
    private void onChunkUpdate(double x, double y, double z, @NotNull Operation<Void> original) {
        long before = this.chunkPosition().toLong();
        original.call(new Object[]{x, y, z});
        long after = this.chunkPosition().toLong();
        if (before == after) {
            return;
        }
        NeoForge.EVENT_BUS.post((Event)new EntityChunkChangeEvent.After((Entity)this));
    }
}

