/*
 * Decompiled with CFR 0.152.
 */
package me.kall.duplicationless.mixin.event;

import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import me.kall.duplicationless.event.BlockChangeEvent;
import me.kall.duplicationless.event.ChunkTickEvent;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerLevel.class})
public abstract class ServerLevelMixin {
    @Inject(method={"onBlockStateChange(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/block/state/BlockState;)V"}, at={@At(value="TAIL")})
    private void onBlockChange(BlockPos pos, BlockState blockState, BlockState newState, CallbackInfo ci) {
        NeoForge.EVENT_BUS.post((Event)new BlockChangeEvent((ServerLevel)this, blockState, newState, pos));
    }

    @WrapMethod(method={"tickChunk(Lnet/minecraft/world/level/chunk/LevelChunk;I)V"})
    private void onChunkTick(LevelChunk chunk, int randomTickSpeed, Operation<Void> original) {
        ServerLevel level = (ServerLevel)this;
        NeoForge.EVENT_BUS.post((Event)new ChunkTickEvent.Pre(chunk, level, randomTickSpeed));
        original.call(new Object[]{chunk, randomTickSpeed});
        NeoForge.EVENT_BUS.post((Event)new ChunkTickEvent.Post(chunk, level, randomTickSpeed));
    }
}

