/*
 * Decompiled with CFR 0.152.
 */
package me.kall.duplicationless.network;

import me.kall.duplicationless.network.ParticleManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record ParticlePacket(byte particle, int entity) implements CustomPacketPayload
{
    public static final StreamCodec<FriendlyByteBuf, ParticlePacket> CODEC = CustomPacketPayload.codec(ParticlePacket::encode, ParticlePacket::new);
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"duplicationless", (String)"particle");
    public static final CustomPacketPayload.Type<ParticlePacket> TYPE = new CustomPacketPayload.Type(ID);

    public ParticlePacket(@NotNull FriendlyByteBuf buf) {
        this(buf.readByte(), buf.readInt());
    }

    private void encode(@NotNull FriendlyByteBuf buf) {
        buf.writeInt(this.entity);
        buf.writeByte(this.particle);
    }

    private static void handle(ParticlePacket packet, @NotNull IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            Minecraft minecraft = Minecraft.getInstance();
            ClientLevel level = minecraft.level;
            if (level == null) {
                return;
            }
            Entity target = level.getEntity(packet.entity);
            if (target == null) {
                return;
            }
            ParticleOptions particleOptions = (ParticleOptions)ParticleManager.PARTICLES.get(packet.particle);
            if (particleOptions == null) {
                return;
            }
            minecraft.particleEngine.createTrackingEmitter(target, particleOptions);
        });
    }

    public static void register(@NotNull RegisterPayloadHandlersEvent event, String version) {
        event.registrar(version).playToClient(TYPE, CODEC, ParticlePacket::handle);
    }

    public static void send(@NotNull Entity entity, byte particle) {
        if (entity.level().isClientSide()) {
            return;
        }
        PacketDistributor.sendToPlayersTrackingEntity((Entity)entity, (CustomPacketPayload)new ParticlePacket(particle, entity.getId()), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

