/*
 * Decompiled with CFR 0.152.
 */
package me.kall.duplicationless.util;

import it.unimi.dsi.fastutil.longs.LongConsumer;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ChunkPos;
import org.jetbrains.annotations.NotNull;

public final class Positions {
    public static long nearestOne(@NotNull Set<Long> positions, @NotNull BlockPos target) {
        return Positions.nearestOne(positions, target.getX(), target.getY(), target.getZ());
    }

    public static long nearestOne(@NotNull Set<Long> positions, long target) {
        return Positions.nearestOne(positions, BlockPos.getX((long)target), BlockPos.getY((long)target), BlockPos.getZ((long)target));
    }

    public static long nearestOne(@NotNull Set<Long> positions, int targetX, int targetY, int targetZ) {
        if (positions.isEmpty()) {
            throw new IllegalArgumentException("Cannot find nearest one from empty positions set.");
        }
        long nearest = 0L;
        long minDistSq = Long.MAX_VALUE;
        for (long next : positions) {
            int z;
            long distZ;
            int y;
            long distY;
            int x = BlockPos.getX((long)next);
            long distX = x - targetX;
            long distSq = distX * distX + (distY = (long)((y = BlockPos.getY((long)next)) - targetY)) * distY + (distZ = (long)((z = BlockPos.getZ((long)next)) - targetZ)) * distZ;
            if (distSq >= minDistSq) continue;
            minDistSq = distSq;
            nearest = next;
        }
        return nearest;
    }

    public static long toChunk(@NotNull BlockPos pos) {
        return ChunkPos.asLong((int)SectionPos.blockToSectionCoord((int)pos.getX()), (int)SectionPos.blockToSectionCoord((int)pos.getZ()));
    }

    public static long toChunk(long blockPos) {
        return ChunkPos.asLong((int)SectionPos.blockToSectionCoord((int)BlockPos.getX((long)blockPos)), (int)SectionPos.blockToSectionCoord((int)BlockPos.getZ((long)blockPos)));
    }

    public static long toChunk(int blockX, int blockZ) {
        return ChunkPos.asLong((int)SectionPos.blockToSectionCoord((int)blockX), (int)SectionPos.blockToSectionCoord((int)blockZ));
    }

    public static long toChunk(double x, double z) {
        return ChunkPos.asLong((int)SectionPos.blockToSectionCoord((int)Mth.floor((double)x)), (int)SectionPos.blockToSectionCoord((int)Mth.floor((double)z)));
    }

    public static void iterateAround(@NotNull ChunkPos centerChunk, int radius, LongConsumer action) {
        Positions.iterateAround(centerChunk.x, centerChunk.z, radius, action);
    }

    public static void iterateAround(long centerChunk, int radius, LongConsumer action) {
        Positions.iterateAround(ChunkPos.getX((long)centerChunk), ChunkPos.getZ((long)centerChunk), radius, action);
    }

    public static void iterateAround(int chunkX, int chunkZ, int radius, LongConsumer action) {
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dz = -radius; dz <= radius; ++dz) {
                action.accept(ChunkPos.asLong((int)(chunkX + dx), (int)(chunkZ + dz)));
            }
        }
    }
}

