/*
 * Decompiled with CFR 0.152.
 */
package me.kall.duplicationless.util;

import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

public class RegistryEntries {
    public static Item item(ResourceLocation id) {
        return (Item)BuiltInRegistries.ITEM.getOptional(id).orElseThrow(() -> new IllegalStateException("Missing key in Item: " + String.valueOf(id)));
    }

    public static EntityType<?> entityType(ResourceLocation id) {
        return (EntityType)BuiltInRegistries.ENTITY_TYPE.getOptional(id).orElseThrow(() -> new IllegalStateException("Missing key in EntityType: " + String.valueOf(id)));
    }

    public static Block block(ResourceLocation id) {
        return (Block)BuiltInRegistries.BLOCK.getOptional(id).orElseThrow(() -> new IllegalStateException("Missing key in Block: " + String.valueOf(id)));
    }

    public static Enchantment enchantment(ResourceLocation id) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server == null) {
            throw new IllegalStateException("Server unavailable. Cannot get enchantment " + id.toString());
        }
        return (Enchantment)server.registryAccess().registryOrThrow(Registries.ENCHANTMENT).getOptional(id).orElseThrow(() -> new IllegalStateException("Missing key in Enchantment: " + String.valueOf(id)));
    }
}

