/*
 * Decompiled with CFR 0.152.
 */
package me.kall.sacrifice;

import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import me.kall.duplicationless.config.JsonConfig;
import me.kall.sacrifice.ext.SacrificeItem;
import me.kall.sacrifice.ext.Unattackable;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import org.jetbrains.annotations.NotNull;

@Mod(value="sacrifice")
@EventBusSubscriber(modid="sacrifice")
public final class Sacrifice {
    public static final String MOD_ID = "sacrifice";
    private static final JsonConfig CONFIG = JsonConfig.create((String)"sacrifice", (String)"1").put("SacrificeItemsLifespan", (Object)12000).put("InvulnerabilityTickCountAfterSacrificing", (Object)200).put("SacrificeItemsProjectileDamageAmount", (Object)Float.valueOf(2.0f)).put("SacrificableInventoryItemsPercent", (Object)Float.valueOf(0.5f)).initialize();
    public static final int LIFESPAN = CONFIG.getInt("SacrificeItemsLifespan");
    public static final int INVULNERABILITY = CONFIG.getInt("InvulnerabilityTickCountAfterSacrificing");
    public static final float DAMAGE = CONFIG.getFloat("SacrificeItemsProjectileDamageAmount");
    public static final float PERCENT = CONFIG.getFloat("SacrificableInventoryItemsPercent");

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void reachDeath(LivingDamageEvent.Pre event) {
        long totalSlots;
        LivingEntity entity = event.getEntity();
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        if (entity.getHealth() > event.getNewDamage()) {
            return;
        }
        Inventory inventory = ((ServerPlayer)entity).getInventory();
        Level level = entity.level();
        ThreadLocalRandom random = ThreadLocalRandom.current();
        double x = entity.getX();
        double y = entity.getY();
        double z = entity.getZ();
        long filledSlots = inventory.items.stream().filter(stack -> !stack.isEmpty()).count() + inventory.armor.stream().filter(stack -> !stack.isEmpty()).count() + inventory.offhand.stream().filter(stack -> !stack.isEmpty()).count();
        if ((float)filledSlots / (float)(totalSlots = (long)inventory.getContainerSize()) > PERCENT) {
            int i = 0;
            while ((long)i < totalSlots) {
                ItemStack stack2 = inventory.getItem(i);
                if (!stack2.isEmpty()) {
                    ItemEntity itemEntity = new ItemEntity(level, x, y, z, stack2.copy());
                    itemEntity.lifespan = LIFESPAN;
                    itemEntity.setThrower((Entity)entity);
                    itemEntity.setDeltaMovement(((Random)random).nextDouble() - 0.5, 0.3 + ((Random)random).nextDouble() * 0.3, ((Random)random).nextDouble() - 0.5);
                    itemEntity.setPickUpDelay(40);
                    SacrificeItem.cast(itemEntity).sacrifice$set(true);
                    level.addFreshEntity((Entity)itemEntity);
                    inventory.setItem(i, ItemStack.EMPTY);
                }
                ++i;
            }
            ((Unattackable)entity).sacrifice$setUnattackableTickCount(INVULNERABILITY);
            event.setNewDamage(0.0f);
        }
    }

    public static boolean isMoving(@NotNull ItemEntity item) {
        Vec3 deltaMovement = item.getDeltaMovement();
        return Math.abs(deltaMovement.x) > 0.02 || Math.abs(deltaMovement.z) > 0.02;
    }

    @SubscribeEvent
    public static void attackPlayer(@NotNull LivingIncomingDamageEvent event) {
        LivingEntity entity = event.getEntity();
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        if (((Unattackable)entity).sacrifice$isUnattackable()) {
            event.setCanceled(true);
        }
    }
}

