/*
 * Decompiled with CFR 0.152.
 */
package me.kall.sacrifice.mixin;

import me.kall.sacrifice.Sacrifice;
import me.kall.sacrifice.ext.SacrificeItem;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ItemEntity.class})
public abstract class ItemEntityMixin
implements SacrificeItem {
    @Unique
    private boolean sacrifice$isSacrifice;

    @Inject(method={"tick()V"}, at={@At(value="RETURN")})
    private void tickPickable(CallbackInfo ci) {
        Entity owner;
        ItemEntity entity = (ItemEntity)this;
        Level level = entity.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        if (this.sacrifice$get() && Sacrifice.isMoving(entity) && (owner = entity.getOwner()) instanceof LivingEntity) {
            DamageSource damageSource = level.damageSources().mobProjectile((Entity)entity, (LivingEntity)owner);
            for (Entity target : level.getEntities((Entity)entity, entity.getBoundingBox(), Entity::isAlive)) {
                target.hurt(damageSource, Sacrifice.DAMAGE);
            }
        }
    }

    @Override
    public boolean sacrifice$get() {
        return this.sacrifice$isSacrifice;
    }

    @Override
    public void sacrifice$set(boolean isSacrifice) {
        this.sacrifice$isSacrifice = isSacrifice;
    }
}

