/*
 * Decompiled with CFR 0.152.
 */
package me.kall.duplicationless.util;

import it.unimi.dsi.fastutil.longs.LongConsumer;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ChunkPos;
import org.jetbrains.annotations.NotNull;

public final class Positions {
    public static long nearestOne(@NotNull Set<Long> positions, @NotNull BlockPos target) {
        return Positions.nearestOne(positions, target.m_123341_(), target.m_123342_(), target.m_123343_());
    }

    public static long nearestOne(@NotNull Set<Long> positions, long target) {
        return Positions.nearestOne(positions, BlockPos.m_121983_((long)target), BlockPos.m_122008_((long)target), BlockPos.m_122015_((long)target));
    }

    public static long nearestOne(@NotNull Set<Long> positions, int targetX, int targetY, int targetZ) {
        if (positions.isEmpty()) {
            throw new IllegalArgumentException("Cannot find nearest one from empty positions set.");
        }
        long nearest = 0L;
        long minDistSq = Long.MAX_VALUE;
        for (long next : positions) {
            int z;
            long distZ;
            int y;
            long distY;
            int x = BlockPos.m_121983_((long)next);
            long distX = x - targetX;
            long distSq = distX * distX + (distY = (long)((y = BlockPos.m_122008_((long)next)) - targetY)) * distY + (distZ = (long)((z = BlockPos.m_122015_((long)next)) - targetZ)) * distZ;
            if (distSq >= minDistSq) continue;
            minDistSq = distSq;
            nearest = next;
        }
        return nearest;
    }

    public static long toChunk(@NotNull BlockPos pos) {
        return ChunkPos.m_45589_((int)SectionPos.m_123171_((int)pos.m_123341_()), (int)SectionPos.m_123171_((int)pos.m_123343_()));
    }

    public static long toChunk(long blockPos) {
        return ChunkPos.m_45589_((int)SectionPos.m_123171_((int)BlockPos.m_121983_((long)blockPos)), (int)SectionPos.m_123171_((int)BlockPos.m_122015_((long)blockPos)));
    }

    public static long toChunk(int blockX, int blockZ) {
        return ChunkPos.m_45589_((int)SectionPos.m_123171_((int)blockX), (int)SectionPos.m_123171_((int)blockZ));
    }

    public static long toChunk(double x, double z) {
        return ChunkPos.m_45589_((int)SectionPos.m_123171_((int)Mth.m_14107_((double)x)), (int)SectionPos.m_123171_((int)Mth.m_14107_((double)z)));
    }

    public static void iterateAround(@NotNull ChunkPos centerChunk, int radius, LongConsumer action) {
        Positions.iterateAround(centerChunk.f_45578_, centerChunk.f_45579_, radius, action);
    }

    public static void iterateAround(long centerChunk, int radius, LongConsumer action) {
        Positions.iterateAround(ChunkPos.m_45592_((long)centerChunk), ChunkPos.m_45602_((long)centerChunk), radius, action);
    }

    public static void iterateAround(int chunkX, int chunkZ, int radius, LongConsumer action) {
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dz = -radius; dz <= radius; ++dz) {
                action.accept(ChunkPos.m_45589_((int)(chunkX + dx), (int)(chunkZ + dz)));
            }
        }
    }
}

