/*
 * Decompiled with CFR 0.152.
 */
package me.kall.sacrifice.mixin;

import java.util.UUID;
import me.kall.sacrifice.Sacrifice;
import me.kall.sacrifice.ext.SacrificeItem;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ItemEntity.class})
public abstract class ItemEntityMixin
implements SacrificeItem {
    @Unique
    private boolean sacrifice$isSacrifice;

    @Inject(method={"tick"}, at={@At(value="RETURN")})
    private void tickPickable(CallbackInfo ci) {
        ItemEntity entity = (ItemEntity)this;
        Level level = entity.f_19853_;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        if (this.sacrifice$get() && Sacrifice.isMoving(entity)) {
            UUID owner = entity.m_32056_();
            if (owner == null) {
                return;
            }
            Entity source = ((ServerLevel)level).m_8791_(owner);
            if (source instanceof LivingEntity) {
                DamageSource damageSource = DamageSource.m_19340_((Entity)entity, (LivingEntity)((LivingEntity)source));
                for (Entity target : level.m_6249_((Entity)entity, entity.m_20191_(), Entity::m_6084_)) {
                    target.m_6469_(damageSource, Sacrifice.DAMAGE);
                }
            }
        }
    }

    @Override
    public boolean sacrifice$get() {
        return this.sacrifice$isSacrifice;
    }

    @Override
    public void sacrifice$set(boolean isSacrifice) {
        this.sacrifice$isSacrifice = isSacrifice;
    }
}

