/*
 * Decompiled with CFR 0.152.
 */
package me.kall.duplicationless.data;

import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.ints.IntSets;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Function;
import java.util.function.Predicate;
import me.kall.duplicationless.ext.RegistryEntry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.EntityLeaveWorldEvent;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnmodifiableView;

@Mod.EventBusSubscriber(modid="duplicationless")
public final class EntityTracker {
    private static final Logger LOGGER = LogManager.getLogger(EntityTracker.class);
    private static final Object2ObjectMap<ResourceLocation, Long2ObjectMap<EntityStorage>> ENTITIES = new Object2ObjectOpenHashMap();
    private static final Object2ObjectMap<ResourceLocation, Predicate<Entity>> FILTERS = new Object2ObjectOpenHashMap();
    private static final ConcurrentLinkedQueue<Runnable> UPDATE_TASKS = new ConcurrentLinkedQueue();

    @NotNull
    public static @UnmodifiableView IntSet getEntities(@NotNull ServerLevel level, long chunkPos) {
        return EntityTracker.getInternal(level, chunkPos, entityStorage -> entityStorage.entities);
    }

    @NotNull
    public static @UnmodifiableView IntSet getEntities(@NotNull ServerLevel level, long chunkPos, EntityType<?> type) {
        return EntityTracker.getInternal(level, chunkPos, entityStorage -> {
            ResourceLocation id = RegistryEntry.get(type);
            if (id.equals((Object)RegistryEntry.NONE)) {
                return null;
            }
            if (entityStorage.entitiesByType == null) {
                return null;
            }
            return (IntSet)entityStorage.entitiesByType.get((Object)id);
        });
    }

    @NotNull
    public static @UnmodifiableView IntSet getEntities(@NotNull ServerLevel level, long chunkPos, ResourceLocation filter) {
        return EntityTracker.getInternal(level, chunkPos, entityStorage -> entityStorage.entitiesByFilter == null ? null : (IntSet)entityStorage.entitiesByFilter.get((Object)filter));
    }

    @NotNull
    private static @UnmodifiableView IntSet getInternal(@NotNull ServerLevel level, long chunkPos, Function<EntityStorage, @Nullable IntSet> extractor) {
        if (!level.m_142572_().m_18695_()) {
            throw new UnsupportedOperationException("EntityTracker is only available on the server thread!");
        }
        Long2ObjectMap chunks = (Long2ObjectMap)ENTITIES.get((Object)level.m_46472_().m_135782_());
        if (chunks == null || chunks.isEmpty()) {
            return IntSets.emptySet();
        }
        EntityStorage storage = (EntityStorage)chunks.get(chunkPos);
        if (storage == null) {
            return IntSets.emptySet();
        }
        IntSet set = extractor.apply(storage);
        if (set == null || set.isEmpty()) {
            return IntSets.emptySet();
        }
        return IntSets.unmodifiable((IntSet)set);
    }

    private static void update(@NotNull Entity entity, @NotNull ServerLevel level, boolean add) {
        Filterable filterable;
        long chunkPos = entity.m_146902_().m_45588_();
        ResourceLocation dim = level.m_46472_().m_135782_();
        int id = entity.m_142049_();
        ResourceLocation entityType = RegistryEntry.get(entity.m_6095_());
        boolean isNone = entityType.equals((Object)RegistryEntry.NONE);
        if (entity instanceof Filterable && !(filterable = (Filterable)entity).filter$initialized()) {
            filterable.filter$initialize(FILTERS);
        }
        ObjectList<ResourceLocation> filters = Filterable.getMatched(entity);
        UPDATE_TASKS.add(() -> {
            Long2ObjectMap chunks = (Long2ObjectMap)ENTITIES.computeIfAbsent((Object)dim, key -> new Long2ObjectOpenHashMap());
            EntityStorage entityStorage = (EntityStorage)chunks.computeIfAbsent(chunkPos, key -> new EntityStorage());
            if (add) {
                entityStorage.add(id, entityType, isNone, filters);
            } else {
                entityStorage.remove(id, entityType, isNone, filters);
                if (entityStorage.isEmpty()) {
                    chunks.remove(chunkPos);
                    if (chunks.isEmpty()) {
                        ENTITIES.remove((Object)dim);
                    }
                }
            }
        });
    }

    @SubscribeEvent
    public static void filterRegistry(@NotNull ServerAboutToStartEvent event) {
        MinecraftForge.EVENT_BUS.post((Event)new EntityFilterRegistryEvent());
        LOGGER.info("Duplicationless Entity Tracker has initialized successfully.");
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onJoin(@NotNull EntityJoinWorldEvent event) {
        Entity entity = event.getEntity();
        Level level = event.getWorld();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            EntityTracker.update(entity, level2, true);
        }
    }

    @SubscribeEvent
    public static void onLeave(@NotNull EntityLeaveWorldEvent event) {
        Entity entity = event.getEntity();
        Level level = event.getWorld();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            EntityTracker.update(entity, level2, false);
        }
    }

    @SubscribeEvent
    public static void beforeChunkChange( @NotNull EntityChunkChangeEvent.Before event) {
        Entity entity = event.getEntity();
        Level level = entity.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            EntityTracker.update(entity, level2, false);
        }
    }

    @SubscribeEvent
    public static void afterChunkChange( @NotNull EntityChunkChangeEvent.After event) {
        Entity entity = event.getEntity();
        Level level = entity.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            EntityTracker.update(entity, level2, true);
        }
    }

    @SubscribeEvent
    public static void taskUpdate(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull TickEvent.ServerTickEvent event) {
        if (event.phase.equals((Object)TickEvent.Phase.START)) {
            Runnable task;
            while ((task = UPDATE_TASKS.poll()) != null) {
                task.run();
            }
        }
    }

    private static final class EntityStorage {
        @Nullable
        IntSet entities;
        @Nullable
        Object2ObjectMap<ResourceLocation, IntSet> entitiesByType;
        @Nullable
        Object2ObjectMap<ResourceLocation, IntSet> entitiesByFilter;

        private EntityStorage() {
        }

        boolean isEmpty() {
            return this.entities == null && this.entitiesByType == null && this.entitiesByFilter == null;
        }

        void add(int entityId, ResourceLocation type, boolean isNone, @Nullable ObjectList<ResourceLocation> matched) {
            this.updateEntities(entityId, true);
            if (!isNone) {
                if (this.entitiesByType == null) {
                    this.entitiesByType = new Object2ObjectOpenHashMap();
                }
                EntityStorage.update(this.entitiesByType, type, entityId, true);
            }
            if (matched != null && !matched.isEmpty()) {
                if (this.entitiesByFilter == null) {
                    this.entitiesByFilter = new Object2ObjectOpenHashMap();
                }
                for (ResourceLocation filterId : matched) {
                    EntityStorage.update(this.entitiesByFilter, filterId, entityId, true);
                }
            }
        }

        void remove(int entityId, ResourceLocation type, boolean isNone, @Nullable ObjectList<ResourceLocation> matched) {
            this.updateEntities(entityId, false);
            if (!isNone && this.entitiesByType != null) {
                EntityStorage.update(this.entitiesByType, type, entityId, false);
                if (this.entitiesByType.isEmpty()) {
                    this.entitiesByType = null;
                }
            }
            if (matched != null && !matched.isEmpty() && this.entitiesByFilter != null) {
                for (ResourceLocation filterId : matched) {
                    EntityStorage.update(this.entitiesByFilter, filterId, entityId, false);
                }
                if (this.entitiesByFilter.isEmpty()) {
                    this.entitiesByFilter = null;
                }
            }
        }

        private void updateEntities(int entityId, boolean add) {
            if (add) {
                if (this.entities == null) {
                    this.entities = new IntOpenHashSet();
                }
                this.entities.add(entityId);
            } else if (this.entities != null) {
                this.entities.remove(entityId);
                if (this.entities.isEmpty()) {
                    this.entities = null;
                }
            }
        }

        private static void update(Object2ObjectMap<ResourceLocation, IntSet> map, ResourceLocation key, int entityId, boolean add) {
            if (add) {
                ((IntSet)map.computeIfAbsent((Object)key, k -> new IntOpenHashSet())).add(entityId);
            } else {
                IntSet set = (IntSet)map.get((Object)key);
                if (set != null) {
                    set.remove(entityId);
                    if (set.isEmpty()) {
                        map.remove((Object)key);
                    }
                }
            }
        }
    }

    @ApiStatus.Internal
    public static interface Filterable {
        public ObjectList<ResourceLocation> filter$matched();

        public void filter$initialize(Object2ObjectMap<ResourceLocation, Predicate<Entity>> var1);

        public boolean filter$initialized();

        public static ObjectList<ResourceLocation> getMatched(Entity entity) {
            return ((Filterable)entity).filter$matched();
        }
    }

    public static final class EntityFilterRegistryEvent
    extends Event {
        public void register(ResourceLocation filterId, Predicate<Entity> filter) {
            if (FILTERS.containsKey((Object)filterId)) {
                LOGGER.warn("[EntityTracker] Duplicate filter ID detected: {}. This is normal if you are creating multiple singleplayer worlds. Overriding.", (Object)filterId.toString());
            }
            FILTERS.put((Object)filterId, filter);
        }

        public void register(ResourceLocation filterId, @NotNull Class<?> entityClass) {
            this.register(filterId, entityClass::isInstance);
        }
    }
}

