/*
 * Decompiled with CFR 0.152.
 */
package me.kall.duplicationless.data;

import it.unimi.dsi.fastutil.longs.Long2ObjectArrayMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMaps;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import me.kall.duplicationless.ext.DataRebuilder;
import me.kall.duplicationless.util.Executor;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.LongNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.WorldSavedData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ChunkData<DATA, TYPE>
extends WorldSavedData {
    public ChunkData(String string) {
        super(string);
    }

    @NotNull
    public abstract Object2ObjectMap<ResourceLocation, Long2ObjectMap<Set<DATA>>> data();

    public abstract boolean dataTrustable();

    @Nullable
    public abstract Predicate<TYPE> validation();

    public abstract BiFunction<DATA, ServerWorld, TYPE> dataToType();

    public abstract Function<DATA, INBT> dataToTag();

    public abstract Function<INBT, DATA> tagToData();

    public abstract int dataTagType();

    @NotNull
    private Long2ObjectMap<Set<DATA>> getLevelData(@NotNull ResourceLocation dim) {
        return (Long2ObjectMap)this.data().computeIfAbsent((Object)dim, d -> new Long2ObjectOpenHashMap());
    }

    @NotNull
    private ResourceLocation dim(@NotNull ServerWorld level) {
        return level.func_234923_W_().func_240901_a_();
    }

    public void rebuild(ServerWorld level) {
        Predicate<TYPE> validation = this.validation();
        if (this.dataTrustable() || validation == null) {
            return;
        }
        ResourceLocation dim = this.dim(level);
        Long2ObjectMap<Set<DATA>> map = this.getLevelData(dim);
        Long2ObjectArrayMap copy = new Long2ObjectArrayMap(map.size());
        ObjectIterator origin = Long2ObjectMaps.fastIterator(map);
        while (origin.hasNext()) {
            Long2ObjectMap.Entry entry = (Long2ObjectMap.Entry)origin.next();
            copy.put(entry.getLongKey(), (Object)new ObjectArrayList((Collection)entry.getValue()));
        }
        map.clear();
        BiFunction<DATA, ServerWorld, TYPE> function = this.dataToType();
        ObjectIterator copied = Long2ObjectMaps.fastIterator((Long2ObjectMap)copy);
        while (copied.hasNext()) {
            Long2ObjectMap.Entry entry = (Long2ObjectMap.Entry)copied.next();
            long chunk = entry.getLongKey();
            List dataList = (List)entry.getValue();
            for (int i = 0; i < dataList.size(); ++i) {
                Object data = dataList.get(i);
                TYPE type = function.apply(data, level);
                if (type == null || !validation.test(type)) continue;
                this.add(level, chunk, data);
            }
        }
    }

    public void rebuildChunk(final ServerWorld level, @NotNull ChunkPos chunkPos) {
        final int chunkX = chunkPos.field_77276_a;
        final int chunkZ = chunkPos.field_77275_b;
        final long chunk = chunkPos.func_201841_a();
        final Predicate<TYPE> validation = this.validation();
        final BiFunction<DATA, ServerWorld, TYPE> function = this.dataToType();
        final ResourceLocation dim = this.dim(level);
        if (this.dataTrustable() || validation == null) {
            return;
        }
        Runnable rebuildTask = new Runnable(){
            private int tries;

            @Override
            public void run() {
                if (this.tries >= 20) {
                    return;
                }
                if (level.func_217354_b(chunkX, chunkZ)) {
                    Chunk levelChunk = level.func_212866_a_(chunkX, chunkZ);
                    if (!((DataRebuilder)levelChunk).duplicationless$rebuilt()) {
                        ((DataRebuilder)levelChunk).duplicationless$setRebuilt();
                        Long2ObjectMap chunks = ChunkData.this.getLevelData(dim);
                        if (chunks.isEmpty()) {
                            return;
                        }
                        Set dataSet = (Set)chunks.get(chunk);
                        if (dataSet == null || dataSet.isEmpty()) {
                            return;
                        }
                        ObjectArrayList copy = new ObjectArrayList((Collection)dataSet);
                        dataSet.clear();
                        for (Object data : copy) {
                            Object type = function.apply(data, level);
                            if (type == null || !validation.test(type)) continue;
                            ChunkData.this.add(level, chunk, data);
                        }
                    }
                } else {
                    ++this.tries;
                    Executor.runAfter(1, this);
                }
            }
        };
        Executor.run(rebuildTask);
    }

    public void add(ServerWorld level, long chunk, DATA data) {
        if (((Set)this.getLevelData(this.dim(level)).computeIfAbsent(chunk, k -> new ObjectOpenHashSet())).add(data)) {
            this.func_76185_a();
        }
    }

    public void remove(ServerWorld level, long chunk, DATA data) {
        Long2ObjectMap<Set<DATA>> map = this.getLevelData(this.dim(level));
        Set s = (Set)map.get(chunk);
        if (s != null && s.remove(data)) {
            if (s.isEmpty()) {
                map.remove(chunk);
            }
            this.func_76185_a();
        }
    }

    public boolean has(ServerWorld level, long chunk, DATA data) {
        Set s = (Set)this.getLevelData(this.dim(level)).get(chunk);
        return s != null && s.contains(data);
    }

    @NotNull
    public Set<DATA> viewChunk(ServerWorld level, long chunk) {
        Set s = (Set)this.getLevelData(this.dim(level)).get(chunk);
        return s == null || s.isEmpty() ? Collections.emptySet() : Collections.unmodifiableSet(s);
    }

    @NotNull
    public Optional<DATA> pick(ServerWorld level, long chunk) {
        Set s = (Set)this.getLevelData(this.dim(level)).get(chunk);
        return s == null || s.isEmpty() || !s.iterator().hasNext() ? Optional.empty() : Optional.of(s.iterator().next());
    }

    @NotNull
    public CompoundNBT func_189551_b(@NotNull CompoundNBT tag) {
        ListNBT dimList = new ListNBT();
        Function<DATA, INBT> saveFunction = this.dataToTag();
        for (Object2ObjectMap.Entry dimEntry : this.data().object2ObjectEntrySet()) {
            CompoundNBT dimTag = new CompoundNBT();
            dimTag.func_74778_a("id", ((ResourceLocation)dimEntry.getKey()).toString());
            ListNBT chunkList = new ListNBT();
            for (Long2ObjectMap.Entry entry : ((Long2ObjectMap)dimEntry.getValue()).long2ObjectEntrySet()) {
                CompoundNBT chunkTag = new CompoundNBT();
                chunkTag.func_74772_a("chunk", entry.getLongKey());
                ListNBT dataList = new ListNBT();
                for (Object data : (Set)entry.getValue()) {
                    dataList.add((Object)saveFunction.apply(data));
                }
                chunkTag.func_218657_a("data", (INBT)dataList);
                chunkList.add((Object)chunkTag);
            }
            dimTag.func_218657_a("chunks", (INBT)chunkList);
            dimList.add((Object)dimTag);
        }
        tag.func_218657_a("dimensions", (INBT)dimList);
        return tag;
    }

    public void func_76184_a(@NotNull CompoundNBT tag) {
        this.data().clear();
        Function<INBT, DATA> loadFunction = this.tagToData();
        ListNBT dimList = tag.func_150295_c("dimensions", 10);
        for (int d = 0; d < dimList.size(); ++d) {
            CompoundNBT dimTag = dimList.func_150305_b(d);
            ResourceLocation dim = new ResourceLocation(dimTag.func_74779_i("id"));
            Long2ObjectMap<Set<DATA>> map = this.getLevelData(dim);
            ListNBT chunkList = dimTag.func_150295_c("chunks", 10);
            for (int i = 0; i < chunkList.size(); ++i) {
                CompoundNBT chunkTag = chunkList.func_150305_b(i);
                long chunk = chunkTag.func_74763_f("chunk");
                ListNBT dataList = chunkTag.func_150295_c("data", this.dataTagType());
                ObjectOpenHashSet set = new ObjectOpenHashSet();
                for (INBT dataTag : dataList) {
                    set.add(loadFunction.apply(dataTag));
                }
                map.put(chunk, (Object)set);
            }
        }
        this.func_76185_a();
    }

    @NotNull
    public static <DATA, TYPE> ChunkData<DATA, TYPE> get(@NotNull ServerWorld level, Supplier<ChunkData<DATA, TYPE>> constructor, String name) {
        return (ChunkData)level.func_217481_x().func_215752_a(constructor, name);
    }

    public static abstract class BlockData
    extends ChunkData<Long, BlockState> {
        public static final long ZERO = BlockPos.field_177992_a.func_218275_a();

        public BlockData(String string) {
            super(string);
        }

        @Override
        @NotNull
        public abstract Object2ObjectMap<ResourceLocation, Long2ObjectMap<Set<Long>>> data();

        @Override
        @Nullable
        public abstract Predicate<BlockState> validation();

        @Override
        public BiFunction<Long, ServerWorld, BlockState> dataToType() {
            return (pos, level) -> level.func_180495_p(BlockPos.func_218283_e((long)pos));
        }

        @Override
        public Function<Long, INBT> dataToTag() {
            return LongNBT::func_229698_a_;
        }

        @Override
        public Function<INBT, Long> tagToData() {
            return tag -> tag instanceof LongNBT ? ((LongNBT)tag).func_150291_c() : ZERO;
        }

        @Override
        public int dataTagType() {
            return 4;
        }
    }

    public static abstract class UUIDData
    extends ChunkData<UUID, Entity> {
        public UUIDData(String string) {
            super(string);
        }

        @Override
        @NotNull
        public abstract Object2ObjectMap<ResourceLocation, Long2ObjectMap<Set<UUID>>> data();

        @Override
        @Nullable
        public abstract Predicate<Entity> validation();

        @Override
        public BiFunction<UUID, ServerWorld, Entity> dataToType() {
            return (uuid, level) -> level.func_217461_a(uuid);
        }

        @Override
        public Function<UUID, INBT> dataToTag() {
            return uuid -> StringNBT.func_229705_a_((String)uuid.toString());
        }

        @Override
        public Function<INBT, UUID> tagToData() {
            return tag -> UUID.fromString(tag.func_150285_a_());
        }

        @Override
        public int dataTagType() {
            return 8;
        }
    }
}

