/*
 * Decompiled with CFR 0.152.
 */
package me.kall.duplicationless.mixin.event;

import me.kall.duplicationless.event.BlockChangeEvent;
import me.kall.duplicationless.event.ChunkTickEvent;
import me.kall.duplicationless.mixinextras.injector.wrapmethod.WrapMethod;
import me.kall.duplicationless.mixinextras.injector.wrapoperation.Operation;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerWorld.class})
public abstract class ServerLevelMixin {
    @Inject(method={"onBlockStateChange"}, at={@At(value="TAIL")})
    private void onBlockChange(BlockPos pos, BlockState blockState, BlockState newState, CallbackInfo ci) {
        MinecraftForge.EVENT_BUS.post((Event)new BlockChangeEvent((ServerWorld)this, blockState, newState, pos));
    }

    @WrapMethod(method={"tickChunk"})
    private void onChunkTick(Chunk chunk, int randomTickSpeed, Operation<Void> original) {
        ServerWorld level = (ServerWorld)this;
        MinecraftForge.EVENT_BUS.post((Event)new ChunkTickEvent.Pre(chunk, level, randomTickSpeed));
        original.call(chunk, randomTickSpeed);
        MinecraftForge.EVENT_BUS.post((Event)new ChunkTickEvent.Post(chunk, level, randomTickSpeed));
    }
}

