/*
 * Decompiled with CFR 0.152.
 */
package me.kall.duplicationless.network;

import java.util.Optional;
import java.util.function.Supplier;
import me.kall.duplicationless.network.ParticleManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import org.jetbrains.annotations.NotNull;

public class ParticlePacket {
    private final int entity;
    private final byte particle;

    public ParticlePacket(int entity, byte particle) {
        this.entity = entity;
        this.particle = particle;
    }

    private ParticlePacket(@NotNull PacketBuffer buf) {
        this.entity = buf.readInt();
        this.particle = buf.readByte();
    }

    private void encode(@NotNull PacketBuffer buf) {
        buf.writeInt(this.entity);
        buf.writeByte((int)this.particle);
    }

    private void handle(@NotNull Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            Minecraft minecraft = Minecraft.func_71410_x();
            ClientWorld level = minecraft.field_71441_e;
            if (level == null) {
                return;
            }
            Entity target = level.func_73045_a(this.entity);
            if (target == null) {
                return;
            }
            IParticleData particleOptions = (IParticleData)ParticleManager.PARTICLES.get(this.particle);
            if (particleOptions == null) {
                return;
            }
            minecraft.field_71452_i.func_199282_a(target, particleOptions);
        });
        context.setPacketHandled(true);
    }

    public static void register(@NotNull SimpleChannel instance, int id) {
        instance.registerMessage(id, ParticlePacket.class, ParticlePacket::encode, ParticlePacket::new, ParticlePacket::handle, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
    }

    public static void send(@NotNull SimpleChannel instance, @NotNull Entity entity, byte particle) {
        instance.send(PacketDistributor.TRACKING_ENTITY.with(() -> entity), (Object)new ParticlePacket(entity.func_145782_y(), particle));
    }
}

