/*
 * Decompiled with CFR 0.152.
 */
package me.kall.duplicationless.util;

import it.unimi.dsi.fastutil.longs.LongConsumer;
import java.util.Set;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.SectionPos;
import org.jetbrains.annotations.NotNull;

public final class Positions {
    public static long nearestOne(@NotNull Set<Long> positions, @NotNull BlockPos target) {
        return Positions.nearestOne(positions, target.func_177958_n(), target.func_177956_o(), target.func_177952_p());
    }

    public static long nearestOne(@NotNull Set<Long> positions, long target) {
        return Positions.nearestOne(positions, BlockPos.func_218290_b((long)target), BlockPos.func_218274_c((long)target), BlockPos.func_218282_d((long)target));
    }

    public static long nearestOne(@NotNull Set<Long> positions, int targetX, int targetY, int targetZ) {
        if (positions.isEmpty()) {
            throw new IllegalArgumentException("Cannot find nearest one from empty positions set.");
        }
        long nearest = 0L;
        long minDistSq = Long.MAX_VALUE;
        for (long next : positions) {
            int z;
            long distZ;
            int y;
            long distY;
            int x = BlockPos.func_218290_b((long)next);
            long distX = x - targetX;
            long distSq = distX * distX + (distY = (long)((y = BlockPos.func_218274_c((long)next)) - targetY)) * distY + (distZ = (long)((z = BlockPos.func_218282_d((long)next)) - targetZ)) * distZ;
            if (distSq >= minDistSq) continue;
            minDistSq = distSq;
            nearest = next;
        }
        return nearest;
    }

    public static long toChunk(@NotNull BlockPos pos) {
        return ChunkPos.func_77272_a((int)SectionPos.func_218159_a((int)pos.func_177958_n()), (int)SectionPos.func_218159_a((int)pos.func_177952_p()));
    }

    public static long toChunk(long blockPos) {
        return ChunkPos.func_77272_a((int)SectionPos.func_218159_a((int)BlockPos.func_218290_b((long)blockPos)), (int)SectionPos.func_218159_a((int)BlockPos.func_218282_d((long)blockPos)));
    }

    public static long toChunk(int blockX, int blockZ) {
        return ChunkPos.func_77272_a((int)SectionPos.func_218159_a((int)blockX), (int)SectionPos.func_218159_a((int)blockZ));
    }

    public static long toChunk(double x, double z) {
        return ChunkPos.func_77272_a((int)SectionPos.func_218159_a((int)MathHelper.func_76128_c((double)x)), (int)SectionPos.func_218159_a((int)MathHelper.func_76128_c((double)z)));
    }

    public static void iterateAround(@NotNull ChunkPos centerChunk, int radius, LongConsumer action) {
        Positions.iterateAround(centerChunk.field_77276_a, centerChunk.field_77275_b, radius, action);
    }

    public static void iterateAround(long centerChunk, int radius, LongConsumer action) {
        Positions.iterateAround(ChunkPos.func_212578_a((long)centerChunk), ChunkPos.func_212579_b((long)centerChunk), radius, action);
    }

    public static void iterateAround(int chunkX, int chunkZ, int radius, LongConsumer action) {
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dz = -radius; dz <= radius; ++dz) {
                action.accept(ChunkPos.func_77272_a((int)(chunkX + dx), (int)(chunkZ + dz)));
            }
        }
    }
}

