/*
 * Decompiled with CFR 0.152.
 */
package me.kall.sacrifice.mixin;

import java.util.UUID;
import me.kall.sacrifice.Sacrifice;
import me.kall.sacrifice.ext.SacrificeItem;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ItemEntity.class})
public abstract class ItemEntityMixin
implements SacrificeItem {
    @Unique
    private boolean sacrifice$isSacrifice;

    @Inject(method={"tick"}, at={@At(value="RETURN")})
    private void tickPickable(CallbackInfo ci) {
        ItemEntity entity = (ItemEntity)this;
        World level = entity.field_70170_p;
        if (!(level instanceof ServerWorld)) {
            return;
        }
        if (this.sacrifice$get() && Sacrifice.isMoving(entity)) {
            UUID owner = entity.func_200215_l();
            if (owner == null) {
                return;
            }
            Entity source = ((ServerWorld)level).func_217461_a(owner);
            if (source instanceof LivingEntity) {
                DamageSource damageSource = DamageSource.func_188403_a((Entity)entity, (LivingEntity)((LivingEntity)source));
                for (Entity target : level.func_175674_a((Entity)entity, entity.func_174813_aQ(), Entity::func_70089_S)) {
                    target.func_70097_a(damageSource, Sacrifice.DAMAGE);
                }
            }
        }
    }

    @Override
    public boolean sacrifice$get() {
        return this.sacrifice$isSacrifice;
    }

    @Override
    public void sacrifice$set(boolean isSacrifice) {
        this.sacrifice$isSacrifice = isSacrifice;
    }
}

