/*
 * Decompiled with CFR 0.152.
 */
package yelf42.cropcritters.events;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;

public class WeedGrowNotifier {
    private static final Map<class_1937, Map<class_2338, Long>> weedsToRing = new ConcurrentHashMap<class_1937, Map<class_2338, Long>>();
    private static final int RADIUS = 128;
    private static final long MAX_AGE_TICKS = 1200L;
    private static final long MAX_SIZE = 128L;

    public static boolean checkWeedsToRing(class_1937 world, class_2338 bellPos) {
        Map<class_2338, Long> positions = weedsToRing.get(world);
        if (positions == null) {
            return false;
        }
        long currentTime = world.method_8510();
        Iterator<Map.Entry<class_2338, Long>> it = positions.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<class_2338, Long> entry = it.next();
            if (currentTime - entry.getValue() > 1200L) {
                it.remove();
                continue;
            }
            if (!entry.getKey().method_19771((class_2382)bellPos, 128.0)) continue;
            it.remove();
            if (positions.isEmpty()) {
                weedsToRing.remove(world);
            }
            return true;
        }
        if (positions.isEmpty()) {
            weedsToRing.remove(world);
        }
        return false;
    }

    public static void notifyEvent(class_1937 world, class_2338 eventPos) {
        weedsToRing.computeIfAbsent(world, w -> new ConcurrentHashMap());
        Map<class_2338, Long> positions = weedsToRing.get(world);
        if ((long)positions.size() >= 128L) {
            positions.clear();
        }
        positions.put(eventPos.method_10062(), world.method_8510());
    }

    public static void notifyRemoval(class_1937 world, class_2338 eventPos) {
        Map<class_2338, Long> positions = weedsToRing.get(world);
        if (positions == null) {
            return;
        }
        positions.remove(eventPos);
        if (positions.isEmpty()) {
            weedsToRing.remove(world);
        }
    }
}

