/*
 * Decompiled with CFR 0.152.
 */
package com.pepper.faunify.entity;

import com.mojang.serialization.Codec;
import com.pepper.faunify.entity.MouseEntity;
import com.pepper.faunify.particle.FaunifyParticleTypes;
import com.pepper.faunify.registry.FaunifyEntities;
import com.pepper.faunify.registry.FaunifySounds;
import java.util.EnumSet;
import java.util.concurrent.TimeUnit;
import java.util.function.IntFunction;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1321;
import net.minecraft.class_1335;
import net.minecraft.class_1341;
import net.minecraft.class_1347;
import net.minecraft.class_1350;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1376;
import net.minecraft.class_1386;
import net.minecraft.class_1391;
import net.minecraft.class_1394;
import net.minecraft.class_1403;
import net.minecraft.class_1404;
import net.minecraft.class_1406;
import net.minecraft.class_1429;
import net.minecraft.class_1463;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1922;
import net.minecraft.class_1924;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2596;
import net.minecraft.class_2620;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3481;
import net.minecraft.class_3542;
import net.minecraft.class_3730;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_7995;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class RingtailCatEntity
extends class_1321
implements GeoEntity {
    public static final float DEFAULT_HEALTH = 15.0f;
    public static final float TAMED_HEALTH = 25.0f;
    private static final class_2940<Integer> DATA_VARIANT_ID = class_2945.method_12791(RingtailCatEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Boolean> SLEEPING = class_2945.method_12791(RingtailCatEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> STALKING = class_2945.method_12791(RingtailCatEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> DIGGING = class_2945.method_12791(RingtailCatEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> SHRIEKING = class_2945.method_12791(RingtailCatEntity.class, (class_2941)class_2943.field_13323);
    private final AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);

    public RingtailCatEntity(class_1299<? extends class_1321> entityType, class_1937 world) {
        super(entityType, world);
        this.field_6207 = new RingtailMoveControl(this);
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 15.0).method_26868(class_5134.field_23719, 0.25).method_26868(class_5134.field_23721, 1.8);
    }

    public static boolean canSpawn(class_1299<RingtailCatEntity> entityType, class_1936 world, class_3730 spawnReason, class_2338 pos, class_5819 random) {
        return world.method_8320(pos.method_10074()).method_26164(class_3481.field_29822) && class_1429.method_20663(entityType, (class_1936)world, (class_3730)spawnReason, (class_2338)pos, (class_5819)random);
    }

    public void method_6173(boolean tamed) {
        super.method_6173(tamed);
        if (tamed) {
            this.method_5996(class_5134.field_23716).method_6192(25.0);
            this.method_6033(25.0f);
        }
    }

    @Nullable
    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 spawnData, @Nullable class_2487 dataTag) {
        this.setVariant((Variant)((Object)class_156.method_27173((Object[])Variant.values(), (class_5819)world.method_8409())));
        super.method_5943(world, difficulty, spawnReason, spawnData, dataTag);
        if (spawnData == null) {
            spawnData = new class_1296.class_4697(false);
        }
        return spawnData;
    }

    public class_1924 method_48926() {
        return this.method_37908();
    }

    protected void method_5958() {
        class_1657 player;
        class_1293 current;
        class_1309 class_13092;
        super.method_5958();
        if (this.method_6181() && !this.method_6172() && (class_13092 = this.method_35057()) instanceof class_1657 && ((current = (player = (class_1657)class_13092).method_6112(class_1294.field_5917)) == null || current.method_5584() < 10)) {
            player.method_6092(new class_1293(class_1294.field_5917, 40, 0, true, false, true));
        }
    }

    public void method_5980(@Nullable class_1309 target) {
        if (this.method_6181() && this.method_35057() != null && target == this.method_35057()) {
            return;
        }
        super.method_5980(target);
    }

    public boolean method_6121(class_1297 target) {
        boolean flag = target.method_5643(this.method_48923().method_48812((class_1309)this), (float)((int)this.method_26825(class_5134.field_23721)));
        if (target instanceof MouseEntity || target instanceof class_1463) {
            return super.method_6121(target);
        }
        return flag;
    }

    public boolean method_5643(class_1282 source, float amount) {
        boolean result = super.method_5643(source, amount);
        if (this.method_6113()) {
            this.setSleeping(false);
        }
        if (!this.method_37908().field_9236) {
            this.method_24346(false);
        }
        if (this.method_6172()) {
            this.method_6179(false);
        }
        return result;
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(SLEEPING, (Object)false);
        this.field_6011.method_12784(STALKING, (Object)false);
        this.field_6011.method_12784(DIGGING, (Object)false);
        this.field_6011.method_12784(SHRIEKING, (Object)false);
        this.field_6011.method_12784(DATA_VARIANT_ID, (Object)0);
    }

    public void method_5652(class_2487 tag) {
        super.method_5652(tag);
        tag.method_10569("Variant", this.getVariant().id);
        tag.method_10556("Sleeping", this.method_6113());
        tag.method_10556("Digging", this.isDigging());
        tag.method_10556("Shrieking", this.isShrieking());
    }

    public void method_5749(class_2487 tag) {
        super.method_5749(tag);
        this.setVariant(Variant.byId(tag.method_10550("Variant")));
        this.setSleeping(tag.method_10577("Sleeping"));
        this.setDigging(tag.method_10577("Digging"));
        this.setShrieking(tag.method_10577("Shrieking"));
    }

    public boolean method_6113() {
        return (Boolean)this.field_6011.method_12789(SLEEPING);
    }

    public void setSleeping(boolean sleeping) {
        this.field_6011.method_12778(SLEEPING, (Object)sleeping);
    }

    public boolean isStalking() {
        return (Boolean)this.field_6011.method_12789(STALKING);
    }

    public void setStalking(boolean stalking) {
        this.field_6011.method_12778(STALKING, (Object)stalking);
    }

    public boolean isDigging() {
        return (Boolean)this.field_6011.method_12789(DIGGING);
    }

    public void setDigging(boolean digging) {
        this.field_6011.method_12778(DIGGING, (Object)digging);
    }

    public boolean isShrieking() {
        return (Boolean)this.field_6011.method_12789(SHRIEKING);
    }

    public void setShrieking(boolean shrieking) {
        this.field_6011.method_12778(SHRIEKING, (Object)shrieking);
    }

    public Variant getVariant() {
        return Variant.byId((Integer)this.field_6011.method_12789(DATA_VARIANT_ID));
    }

    public void setVariant(Variant variant) {
        this.field_6011.method_12778(DATA_VARIANT_ID, (Object)variant.id);
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new SleepGoal(200));
        this.field_6201.method_6277(2, (class_1352)new class_1386((class_1321)this));
        this.field_6201.method_6277(3, (class_1352)new class_1350((class_1321)this, 1.2, 10.0f, 2.0f, false));
        this.field_6201.method_6277(4, (class_1352)new class_1341((class_1429)this, 1.25));
        this.field_6201.method_6277(5, (class_1352)new class_1391((class_1314)this, 1.35, class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8429, class_1802.field_8209}), false));
        this.field_6201.method_6277(6, (class_1352)new RingtailStalkAndPounceGoal(this));
        this.field_6201.method_6277(7, (class_1352)new MiningGoal(this));
        this.field_6201.method_6277(8, (class_1352)new class_1394((class_1314)this, 1.0));
        this.field_6201.method_6277(9, (class_1352)new class_1361((class_1308)this, class_1657.class, 8.0f));
        this.field_6201.method_6277(10, (class_1352)new class_1376((class_1308)this));
        this.field_6185.method_6277(1, (class_1352)new class_1403((class_1321)this));
        this.field_6185.method_6277(2, (class_1352)new class_1406((class_1321)this));
        this.field_6185.method_6277(5, (class_1352)new class_1404((class_1321)this, class_1463.class, true, null));
        this.field_6185.method_6277(6, (class_1352)new class_1404((class_1321)this, MouseEntity.class, true, null));
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1799 itemstack = player.method_5998(hand);
        class_1792 item = itemstack.method_7909();
        if (this.method_6181() && this.method_6171((class_1309)player)) {
            if (this.method_6113()) {
                this.setSleeping(false);
                this.method_24346(true);
                this.method_6179(true);
                this.field_6282 = false;
                this.field_6189.method_6340();
                this.method_5980(null);
                return class_1269.field_5812;
            }
            if (item == class_1802.field_8073) {
                if (this.method_6032() < this.method_6063()) {
                    int particleCount = 5;
                    this.method_6025(3.0f);
                    if (!player.method_31549().field_7477) {
                        itemstack.method_7934(1);
                    }
                    for (int i = 0; i < particleCount; ++i) {
                        double offsetX = (this.field_5974.method_43058() - 0.5) * 1.0;
                        double offsetY = (this.field_5974.method_43058() - 0.5) * 1.0;
                        double offsetZ = (this.field_5974.method_43058() - 0.5) * 1.0;
                        this.method_37908().method_8406((class_2394)FaunifyParticleTypes.HEALTH, this.method_23317() + offsetX, this.method_23318() + (double)this.method_5751() + offsetY, this.method_23321() + offsetZ, 0.0, 0.0, 0.0);
                    }
                } else {
                    this.method_24346(!this.method_24345());
                    this.method_6179(!this.method_6172());
                    if (this.method_6172()) {
                        this.field_6282 = false;
                        this.field_6189.method_6340();
                        this.method_5980(null);
                    }
                }
                return class_1269.field_5812;
            }
            if (item == class_1802.field_8429 || item == class_1802.field_8209) {
                if (!this.method_6479() && this.method_5618() == 0) {
                    if (!this.method_37908().field_9236) {
                        this.method_6480(player);
                        if (!player.method_31549().field_7477) {
                            itemstack.method_7934(1);
                        }
                    }
                } else {
                    this.method_24346(!this.method_24345());
                    this.method_6179(!this.method_6172());
                    if (this.method_6172()) {
                        this.field_6282 = false;
                        this.field_6189.method_6340();
                        this.method_5980(null);
                    }
                }
                return class_1269.field_5812;
            }
            if (itemstack.method_7960() || item != class_1802.field_8429 && item != class_1802.field_8209 && item != class_1802.field_8073) {
                this.method_24346(!this.method_24345());
                this.method_6179(!this.method_6172());
                if (this.method_6172()) {
                    this.field_6282 = false;
                    this.field_6189.method_6340();
                    this.method_5980(null);
                }
                return class_1269.field_5812;
            }
        }
        if (item == class_1802.field_8073 && !this.method_6181()) {
            if (!player.method_31549().field_7477) {
                itemstack.method_7934(1);
            }
            if (!this.method_37908().field_9236) {
                if (this.field_5974.method_43048(3) == 0) {
                    this.method_6170(player);
                    this.method_6173(true);
                    this.method_6174(player.method_5667());
                    this.method_24346(true);
                    this.method_6179(true);
                    this.field_6189.method_6340();
                    this.method_5980(null);
                    this.method_37908().method_8421((class_1297)this, (byte)7);
                } else {
                    this.method_37908().method_8421((class_1297)this, (byte)6);
                }
            }
            return class_1269.field_5812;
        }
        return super.method_5992(player, hand);
    }

    public boolean method_6481(class_1799 stack) {
        return stack.method_7909() == class_1802.field_8429 || stack.method_7909() == class_1802.field_8209;
    }

    public RingtailCatEntity createChild(class_3218 serverLevel, class_1296 otherParent) {
        RingtailCatEntity babyRingtailCat = (RingtailCatEntity)FaunifyEntities.RINGTAIL.method_5883((class_1937)serverLevel);
        if (babyRingtailCat != null && otherParent instanceof RingtailCatEntity) {
            RingtailCatEntity parent = (RingtailCatEntity)otherParent;
            if (this.method_6181()) {
                babyRingtailCat.method_6174(this.method_6139());
                babyRingtailCat.method_6173(true);
            }
            Variant selectedVariant = this.field_5974.method_43056() ? this.getVariant() : parent.getVariant();
            babyRingtailCat.setVariant(selectedVariant);
            babyRingtailCat.method_5971();
        }
        return babyRingtailCat;
    }

    protected class_3414 method_5994() {
        int soundIndex = this.field_5974.method_43048(2);
        switch (soundIndex) {
            case 0: {
                return FaunifySounds.RINGTAILCAT_IDLE_1;
            }
            case 1: {
                return FaunifySounds.RINGTAILCAT_IDLE_2;
            }
        }
        return FaunifySounds.RINGTAILCAT_IDLE_1;
    }

    protected class_3414 method_6011(class_1282 damageSource) {
        return FaunifySounds.RINGTAILCAT_HURT;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 5, this::predicate)});
    }

    private PlayState predicate(AnimationState<RingtailCatEntity> event) {
        class_1309 target = this.method_5968();
        class_243 velocity = this.method_18798();
        double horizontalSpeedSq = velocity.field_1352 * velocity.field_1352 + velocity.field_1350 * velocity.field_1350;
        double movingThreshold = 0.001;
        if (target != null && !target.method_5805()) {
            this.method_5980(null);
            target = null;
        }
        if (this.method_6113()) {
            event.getController().setAnimation(RawAnimation.begin().then("sleep", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        if (this.isDigging()) {
            event.getController().setAnimation(RawAnimation.begin().then("dig", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        if (this.isStalking()) {
            event.getController().setAnimation(RawAnimation.begin().then("stalk", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        if (this.method_6172()) {
            event.getController().setAnimation(RawAnimation.begin().then("sit", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        if (target instanceof class_1463 || target instanceof MouseEntity) {
            if (horizontalSpeedSq > movingThreshold) {
                event.getController().setAnimation(RawAnimation.begin().then("run", Animation.LoopType.LOOP));
                return PlayState.CONTINUE;
            }
            event.getController().setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        if (this.isFollowingPlayerWithFood()) {
            if (horizontalSpeedSq > movingThreshold) {
                event.getController().setAnimation(RawAnimation.begin().then("run", Animation.LoopType.LOOP));
                return PlayState.CONTINUE;
            }
            event.getController().setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        if (!this.method_24828() && velocity.field_1351 > 0.1) {
            event.getController().setAnimation(RawAnimation.begin().then("leap", Animation.LoopType.PLAY_ONCE));
            return PlayState.CONTINUE;
        }
        if (horizontalSpeedSq > movingThreshold) {
            event.getController().setAnimation(RawAnimation.begin().then("walk", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        event.getController().setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
        return PlayState.CONTINUE;
    }

    private boolean isFollowingPlayerWithFood() {
        class_1657 player = this.method_37908().method_18460((class_1297)this, 10.0);
        if (player != null) {
            class_1799 heldItem = player.method_6047();
            return heldItem.method_7909() == class_1802.field_8429 || heldItem.method_7909() == class_1802.field_8209;
        }
        return false;
    }

    static class RingtailMoveControl
    extends class_1335 {
        private final RingtailCatEntity ringtail;

        public RingtailMoveControl(RingtailCatEntity ringtailEntity) {
            super((class_1308)ringtailEntity);
            this.ringtail = ringtailEntity;
        }

        public void method_6240() {
            if (!this.ringtail.method_6113()) {
                super.method_6240();
            }
        }
    }

    public static enum Variant implements class_3542
    {
        REGULAR(0, "light"),
        BROWN(1, "brown"),
        GREY(2, "grey");

        public static final Codec<Variant> CODEC;
        private static final IntFunction<Variant> BY_ID;
        final int id;
        private final String name;

        private Variant(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public int getId() {
            return this.id;
        }

        public static Variant byId(int id) {
            return BY_ID.apply(id);
        }

        public String method_15434() {
            return this.name;
        }

        static {
            CODEC = class_3542.method_28140(Variant::values);
            BY_ID = class_7995.method_47914(Variant::getId, (Object[])Variant.values(), (class_7995.class_7996)class_7995.class_7996.field_41666);
        }
    }

    public class SleepGoal
    extends class_1352 {
        private final int countdownTime;
        private int countdown;

        public SleepGoal(int countdownTime) {
            this.countdownTime = countdownTime;
            this.countdown = RingtailCatEntity.this.field_5974.method_43048(SleepGoal.method_38848((int)countdownTime));
            this.method_6265(EnumSet.noneOf(class_1352.class_4134.class));
        }

        public boolean method_6264() {
            if (RingtailCatEntity.this.method_5799()) {
                return false;
            }
            if (RingtailCatEntity.this.field_6212 == 0.0f && RingtailCatEntity.this.field_6227 == 0.0f && RingtailCatEntity.this.field_6250 == 0.0f) {
                return this.canSleep() || RingtailCatEntity.this.method_6113();
            }
            return false;
        }

        public boolean method_6266() {
            if (RingtailCatEntity.this.method_5799()) {
                return false;
            }
            if (RingtailCatEntity.this.method_6181() && !RingtailCatEntity.this.method_6172()) {
                return false;
            }
            return this.canSleep();
        }

        private boolean canSleep() {
            if (this.countdown > 0) {
                --this.countdown;
                return false;
            }
            return RingtailCatEntity.this.method_37908().method_23886();
        }

        public void method_6270() {
            RingtailCatEntity.this.setSleeping(false);
            this.countdown = RingtailCatEntity.this.field_5974.method_43048(this.countdownTime);
        }

        public void method_6269() {
            RingtailCatEntity.this.method_6100(false);
            RingtailCatEntity.this.setSleeping(true);
            RingtailCatEntity.this.method_5942().method_6340();
            RingtailCatEntity.this.method_5962().method_6239(RingtailCatEntity.this.method_23317(), RingtailCatEntity.this.method_23318(), RingtailCatEntity.this.method_23321(), 0.0);
        }
    }

    public class RingtailStalkAndPounceGoal
    extends class_1352 {
        private final RingtailCatEntity ringtail;
        private int cooldown = 0;
        private static final double STALK_SPEED = 0.5;
        private static final double POUNCE_RANGE_SQ = 9.0;
        private static final double START_RANGE_SQ = 64.0;
        private static final int COOLDOWN_TICKS = 60;

        public RingtailStalkAndPounceGoal(RingtailCatEntity ringtail) {
            this.ringtail = ringtail;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406, class_1352.class_4134.field_18407));
        }

        public boolean method_6264() {
            if (this.ringtail.method_6113()) {
                return false;
            }
            class_1309 potentialTarget = this.ringtail.method_5968();
            if (potentialTarget == null || !potentialTarget.method_5805()) {
                return false;
            }
            if (!(potentialTarget instanceof class_1463) && !(potentialTarget instanceof MouseEntity)) {
                return false;
            }
            return this.ringtail.method_5858((class_1297)potentialTarget) < 64.0;
        }

        public boolean method_6266() {
            class_1309 currentTarget = this.ringtail.method_5968();
            if (currentTarget == null || !currentTarget.method_5805()) {
                return false;
            }
            return this.ringtail.method_5858((class_1297)currentTarget) < 256.0;
        }

        public void method_6269() {
            this.cooldown = 0;
            this.ringtail.setStalking(true);
        }

        public void method_6270() {
            this.ringtail.method_5942().method_6340();
            this.ringtail.method_5783(FaunifySounds.RINGTAILCAT_ANGRY, 0.5f, 1.0f);
            this.ringtail.setStalking(false);
        }

        public void method_6268() {
            class_1309 currentTarget = this.ringtail.method_5968();
            if (currentTarget == null) {
                return;
            }
            this.ringtail.method_5988().method_6226((class_1297)currentTarget, 30.0f, 30.0f);
            double distSq = this.ringtail.method_5858((class_1297)currentTarget);
            if (distSq > 9.0) {
                this.ringtail.method_5942().method_6335((class_1297)currentTarget, 0.5);
            } else {
                this.ringtail.method_5942().method_6340();
                if (this.cooldown <= 0 && this.ringtail.method_24828()) {
                    class_243 dir = new class_243(currentTarget.method_23317() - this.ringtail.method_23317(), currentTarget.method_23318() - this.ringtail.method_23318(), currentTarget.method_23321() - this.ringtail.method_23321()).method_1029();
                    this.ringtail.method_18800(dir.field_1352 * 0.5, 0.6, dir.field_1350 * 0.5);
                    this.ringtail.method_5783(FaunifySounds.RINGTAILCAT_GROWL, 0.5f, 1.0f);
                    this.cooldown = 60;
                } else {
                    --this.cooldown;
                }
                if (this.cooldown <= 0) {
                    this.method_6270();
                    return;
                }
                if (this.ringtail.method_24828() && this.ringtail.method_5858((class_1297)currentTarget) < 2.0 && currentTarget.method_5805()) {
                    currentTarget.method_5643(this.ringtail.method_48923().method_48812((class_1309)this.ringtail), 5.0f);
                    this.ringtail.method_5783(class_3417.field_14840, 1.0f, 1.0f);
                }
            }
        }
    }

    public class MiningGoal
    extends class_1352 {
        private final RingtailCatEntity ringtail;
        private static final int SEARCH_RADIUS = 5;
        private static final long COOLDOWN_MILLIS = TimeUnit.MINUTES.toMillis(20L);
        private long lastShriekTime = 0L;
        private class_2338 targetOrePos;
        private int standStillTicks = 0;
        private static final int STAND_STILL_DURATION = 60;
        private static final int MAX_LOCK_ON_TICKS = 100;
        private int lockOnTicks = 0;
        private class_2338 diggingBlockPos = null;
        private int breakProgress = 0;
        private int totalBreakTicks = 0;
        private static final int GLOW_DURATION_TICKS = 300;
        private int glowTicksRemaining = 0;
        private boolean hasAppliedGlow = false;

        public MiningGoal(RingtailCatEntity ringtail) {
            this.ringtail = ringtail;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
        }

        public boolean method_6264() {
            if (this.ringtail.method_6113()) {
                return false;
            }
            if (this.ringtail.method_6172()) {
                return false;
            }
            long now = System.currentTimeMillis();
            if (now - this.lastShriekTime < COOLDOWN_MILLIS) {
                return false;
            }
            class_1937 level = this.ringtail.method_37908();
            class_2338 origin = this.ringtail.method_24515();
            for (class_2338 pos : class_2338.method_10097((class_2338)origin.method_10069(-5, -5, -5), (class_2338)origin.method_10069(5, 5, 5))) {
                class_2680 state = level.method_8320(pos);
                if (!this.isRareOre(state)) continue;
                this.targetOrePos = pos.method_10062();
                return true;
            }
            return false;
        }

        private boolean isRareOre(class_2680 state) {
            return state.method_27852(class_2246.field_10090) || state.method_27852(class_2246.field_29028) || state.method_27852(class_2246.field_10571) || state.method_27852(class_2246.field_29026) || state.method_27852(class_2246.field_10013) || state.method_27852(class_2246.field_29220);
        }

        private boolean isSoftBlock(class_2680 state) {
            return state.method_26164(class_3481.field_29822) || state.method_26164(class_3481.field_15466) || state.method_27852(class_2246.field_10477) || state.method_27852(class_2246.field_10255) || state.method_27852(class_2246.field_10460);
        }

        public void method_6269() {
            if (this.targetOrePos != null) {
                this.ringtail.setShrieking(true);
                this.ringtail.method_5783(FaunifySounds.RINGTAILCAT_ALERT, 1.5f, 1.0f);
                this.lastShriekTime = System.currentTimeMillis();
                this.standStillTicks = 0;
                this.lockOnTicks = 0;
                this.hasAppliedGlow = false;
                this.glowTicksRemaining = 0;
                this.applyGlowEffect();
                if (this.ringtail.method_6181()) {
                    this.updatePathToOre();
                }
            }
        }

        private void updatePathToOre() {
            this.ringtail.method_5942().method_6337((double)this.targetOrePos.method_10263(), (double)this.targetOrePos.method_10264(), (double)this.targetOrePos.method_10260(), 1.0);
        }

        public boolean method_6266() {
            if (!this.ringtail.method_6181() || this.ringtail.method_6172()) {
                return false;
            }
            return this.targetOrePos != null && this.lockOnTicks < 100;
        }

        public void method_6270() {
            this.targetOrePos = null;
            this.standStillTicks = 0;
            this.lockOnTicks = 0;
            this.clearGlowEffect();
            this.clearDiggingAnimation();
            this.ringtail.setDigging(false);
            this.ringtail.method_5942().method_6340();
        }

        private void clearDiggingAnimation() {
            if (this.diggingBlockPos != null) {
                this.sendBlockBreakProgress(-1);
            }
            this.diggingBlockPos = null;
            this.breakProgress = 0;
            this.totalBreakTicks = 0;
        }

        public void method_6268() {
            if (this.targetOrePos == null) {
                return;
            }
            this.updateGlowEffect();
            if (this.glowTicksRemaining > 0) {
                --this.glowTicksRemaining;
            }
            if (!this.ringtail.method_6181()) {
                this.method_6270();
                return;
            }
            class_1937 level = this.ringtail.method_37908();
            class_2338 ringtailPos = this.ringtail.method_24515();
            if (this.isOreExposed(level, this.targetOrePos)) {
                this.method_6270();
                return;
            }
            ++this.lockOnTicks;
            if (this.lockOnTicks >= 100) {
                this.method_6270();
                return;
            }
            if (ringtailPos.method_19771((class_2382)this.targetOrePos, 2.0)) {
                ++this.standStillTicks;
                this.ringtail.method_5942().method_6340();
                if (this.diggingBlockPos != null) {
                    this.clearDiggingAnimation();
                    this.ringtail.setDigging(false);
                }
                if (this.standStillTicks >= 60) {
                    this.method_6270();
                }
                return;
            }
            class_2338 blockInFront = this.getBlockInFront(ringtailPos, this.ringtail.method_36454());
            class_2680 blockAhead = level.method_8320(blockInFront);
            if (this.isSoftBlock(blockAhead) && !blockInFront.equals((Object)this.targetOrePos)) {
                this.ringtail.setDigging(true);
                if (this.diggingBlockPos == null || !this.diggingBlockPos.equals((Object)blockInFront)) {
                    if (this.diggingBlockPos != null && !this.diggingBlockPos.equals((Object)blockInFront)) {
                        this.sendBlockBreakProgress(-1);
                    }
                    this.diggingBlockPos = blockInFront.method_10062();
                    this.breakProgress = 0;
                    this.totalBreakTicks = (int)(blockAhead.method_26214((class_1922)level, blockInFront) * 20.0f);
                    this.sendBlockBreakProgress(0);
                }
                if (this.breakProgress < this.totalBreakTicks) {
                    ++this.breakProgress;
                    this.sendBlockBreakProgress((int)((float)this.breakProgress / (float)this.totalBreakTicks * 10.0f));
                } else {
                    level.method_8651(this.diggingBlockPos, true, (class_1297)this.ringtail);
                    this.sendBlockBreakProgress(-1);
                    this.diggingBlockPos = null;
                    this.breakProgress = 0;
                    this.totalBreakTicks = 0;
                }
                this.ringtail.method_5942().method_6340();
            } else {
                if (this.diggingBlockPos != null) {
                    this.clearDiggingAnimation();
                }
                this.ringtail.setDigging(false);
                this.ringtail.method_5962().method_6239((double)this.targetOrePos.method_10263() + 0.5, (double)this.targetOrePos.method_10264(), (double)this.targetOrePos.method_10260() + 0.5, 1.0);
            }
        }

        private void sendBlockBreakProgress(int stage) {
            if (this.diggingBlockPos == null) {
                return;
            }
            int diggingEntityId = this.ringtail.method_5628() + 100000;
            for (class_3222 player : ((class_3218)this.ringtail.method_37908()).method_18456()) {
                player.field_13987.method_14364((class_2596)new class_2620(diggingEntityId, this.diggingBlockPos, stage));
            }
        }

        private class_2338 getBlockInFront(class_2338 currentPos, float yaw) {
            double rad = Math.toRadians(yaw);
            int offsetX = (int)Math.round(-Math.sin(rad));
            int offsetZ = (int)Math.round(Math.cos(rad));
            return currentPos.method_10069(offsetX, 0, offsetZ);
        }

        private boolean isOreExposed(class_1937 level, class_2338 pos) {
            for (class_2350 dir : class_2350.values()) {
                if (!level.method_8320(pos.method_10093(dir)).method_26215()) continue;
                return true;
            }
            return false;
        }

        private void applyGlowEffect() {
            if (this.targetOrePos != null && this.ringtail.method_6181() && !this.hasAppliedGlow) {
                this.glowTicksRemaining = 300;
                this.hasAppliedGlow = true;
            }
        }

        private void updateGlowEffect() {
            if (this.targetOrePos == null || !this.ringtail.method_6181() || this.glowTicksRemaining <= 0) {
                return;
            }
            class_1937 level = this.ringtail.method_37908();
            if (level.field_9236 || !(level instanceof class_3218)) {
                return;
            }
            class_3218 serverLevel = (class_3218)level;
            for (class_3222 player : serverLevel.method_18456()) {
                if (!(player.method_5707(class_243.method_24953((class_2382)this.targetOrePos)) < 4096.0) || this.glowTicksRemaining % 5 != 0) continue;
                double centerX = (double)this.targetOrePos.method_10263() + 0.5;
                double centerY = (double)this.targetOrePos.method_10264() + 0.5;
                double centerZ = (double)this.targetOrePos.method_10260() + 0.5;
                for (int i = 0; i < 8; ++i) {
                    double angle = (double)i / 8.0 * 2.0 * Math.PI;
                    double radius = 0.7;
                    double particleX = centerX + Math.cos(angle) * radius;
                    double particleZ = centerZ + Math.sin(angle) * radius;
                    for (int j = 0; j < 3; ++j) {
                        double particleY = centerY + (double)(j - 1) * 0.3;
                        serverLevel.method_14166(player, (class_2394)class_2398.field_11207, true, particleX, particleY, particleZ, 1, 0.05, 0.05, 0.05, 0.01);
                    }
                }
                serverLevel.method_14166(player, (class_2394)class_2398.field_28479, true, centerX, centerY, centerZ, 3, 0.3, 0.3, 0.3, 0.02);
            }
        }

        private void clearGlowEffect() {
            this.glowTicksRemaining = 0;
            this.hasAppliedGlow = false;
        }
    }
}

