/*
 * Decompiled with CFR 0.152.
 */
package wardentools.block;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import wardentools.tags.ModTags;

public class AbyssDoublePlantBlock
extends DoublePlantBlock {
    public AbyssDoublePlantBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected boolean canSurvive(@NotNull BlockState state, @NotNull LevelReader reader, @NotNull BlockPos pos) {
        return state.is(ModTags.Blocks.CAN_SUSTAIN_ABYSS_PLANTS) || super.canSurvive(state, reader, pos);
    }

    protected boolean mayPlaceOn(@NotNull BlockState state, @NotNull BlockGetter blockGetter, @NotNull BlockPos pos) {
        return state.is(ModTags.Blocks.CAN_SUSTAIN_ABYSS_PLANTS) || super.mayPlaceOn(state, blockGetter, pos);
    }

    protected void tick(@NotNull BlockState state, @NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        super.tick(state, level, pos, random);
        if (!state.canSurvive((LevelReader)level, pos)) {
            level.setBlock(pos, Blocks.AIR.defaultBlockState(), 3);
        }
    }
}

