/*
 * Decompiled with CFR 0.152.
 */
package wardentools.block;

import com.mojang.serialization.MapCodec;
import java.util.OptionalInt;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.ParticleUtils;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.IShearable;
import org.jetbrains.annotations.NotNull;

public class DarktreeLeavesBlock
extends Block
implements SimpleWaterloggedBlock,
IShearable {
    public static final MapCodec<LeavesBlock> CODEC = DarktreeLeavesBlock.simpleCodec(LeavesBlock::new);
    public static final int DECAY_DISTANCE = 9;
    public static final IntegerProperty DISTANCE = IntegerProperty.create((String)"darktree_distance", (int)1, (int)9);
    public static final BooleanProperty PERSISTENT = BlockStateProperties.PERSISTENT;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private static final int TICK_DELAY = 1;

    @NotNull
    public MapCodec<? extends LeavesBlock> codec() {
        return CODEC;
    }

    public DarktreeLeavesBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)DISTANCE, (Comparable)Integer.valueOf(9))).setValue((Property)PERSISTENT, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @NotNull
    protected VoxelShape getBlockSupportShape(@NotNull BlockState state, @NotNull BlockGetter reader, @NotNull BlockPos pos) {
        return Shapes.empty();
    }

    protected boolean isRandomlyTicking(BlockState state) {
        return (Integer)state.getValue((Property)DISTANCE) == 9 && (Boolean)state.getValue((Property)PERSISTENT) == false;
    }

    protected void randomTick(@NotNull BlockState state, @NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        if (this.decaying(state)) {
            DarktreeLeavesBlock.dropResources((BlockState)state, (Level)level, (BlockPos)pos);
            level.removeBlock(pos, false);
        }
    }

    protected boolean decaying(BlockState state) {
        return (Boolean)state.getValue((Property)PERSISTENT) == false && (Integer)state.getValue((Property)DISTANCE) == 9;
    }

    protected void tick(@NotNull BlockState state, ServerLevel level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        level.setBlock(pos, DarktreeLeavesBlock.updateDistance(state, (LevelAccessor)level, pos), 3);
    }

    protected int getLightBlock(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos) {
        return 1;
    }

    @NotNull
    protected BlockState updateShape(BlockState state, @NotNull Direction facing, @NotNull BlockState facingState, @NotNull LevelAccessor level, @NotNull BlockPos currentPos, @NotNull BlockPos facingPos) {
        int i;
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        if ((i = DarktreeLeavesBlock.getDistanceAt(facingState) + 1) != 1 || (Integer)state.getValue((Property)DISTANCE) != i) {
            level.scheduleTick(currentPos, (Block)this, 1);
        }
        return state;
    }

    private static BlockState updateDistance(BlockState state, LevelAccessor level, BlockPos pos) {
        int i = 9;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (Direction direction : Direction.values()) {
            blockpos$mutableblockpos.setWithOffset((Vec3i)pos, direction);
            i = Math.min(i, DarktreeLeavesBlock.getDistanceAt(level.getBlockState((BlockPos)blockpos$mutableblockpos)) + 1);
            if (i == 1) break;
        }
        return (BlockState)state.setValue((Property)DISTANCE, (Comparable)Integer.valueOf(i));
    }

    private static int getDistanceAt(BlockState neighbor) {
        return DarktreeLeavesBlock.getOptionalDistanceAt(neighbor).orElse(9);
    }

    public static OptionalInt getOptionalDistanceAt(BlockState state) {
        if (state.is(BlockTags.LOGS)) {
            return OptionalInt.of(0);
        }
        return state.hasProperty((Property)DISTANCE) ? OptionalInt.of((Integer)state.getValue((Property)DISTANCE)) : OptionalInt.empty();
    }

    @NotNull
    protected FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public void animateTick(@NotNull BlockState state, Level level, BlockPos pos, @NotNull RandomSource random) {
        BlockPos blockpos;
        BlockState blockstate;
        if (!(!level.isRainingAt(pos.above()) || random.nextInt(15) != 1 || (blockstate = level.getBlockState(blockpos = pos.below())).canOcclude() && blockstate.isFaceSturdy((BlockGetter)level, blockpos, Direction.UP))) {
            ParticleUtils.spawnParticleBelow((Level)level, (BlockPos)pos, (RandomSource)random, (ParticleOptions)ParticleTypes.DRIPPING_WATER);
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{DISTANCE, PERSISTENT, WATERLOGGED});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        FluidState fluidstate = context.getLevel().getFluidState(context.getClickedPos());
        BlockState blockstate = (BlockState)((BlockState)this.defaultBlockState().setValue((Property)PERSISTENT, (Comparable)Boolean.valueOf(true))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.getType() == Fluids.WATER));
        return DarktreeLeavesBlock.updateDistance(blockstate, (LevelAccessor)context.getLevel(), context.getClickedPos());
    }

    public boolean isFlammable(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull Direction direction) {
        return true;
    }

    public int getFlammability(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull Direction direction) {
        return 60;
    }

    public int getFireSpreadSpeed(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull Direction direction) {
        return 30;
    }
}

