/*
 * Decompiled with CFR 0.152.
 */
package wardentools.datagen;

import java.util.concurrent.CompletableFuture;
import net.minecraft.advancements.Criterion;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.data.recipes.SingleItemRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import wardentools.datagen.utils.RadianceCatalystRecipeBuilder;
import wardentools.items.ItemRegistry;
import wardentools.items.armors.ArmorRegistry;

public class ModRecipesGenerator
extends RecipeProvider {
    public ModRecipesGenerator(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> completableFuture) {
        super(packOutput, completableFuture);
    }

    protected void buildRecipes(@NotNull RecipeOutput recipeOutput) {
        this.buildRadianceCatalystRecipes(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)ItemRegistry.ABYSS_DIVER.get()), (int)1).define(Character.valueOf('D'), (ItemLike)ItemRegistry.DARK_STICK.get()).define(Character.valueOf('V'), (ItemLike)ItemRegistry.CORRUPTED_VESSEL.get()).pattern("  V").pattern(" D ").pattern("D  ").unlockedBy("has_item", ModRecipesGenerator.has((ItemLike)((ItemLike)ItemRegistry.CORRUPTED_VESSEL.get()))).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)ItemRegistry.ABYSS_DIVER.get()), (int)1).define(Character.valueOf('D'), (ItemLike)ItemRegistry.DARK_STICK.get()).define(Character.valueOf('V'), (ItemLike)ItemRegistry.CORRUPTED_VESSEL.get()).pattern("V  ").pattern(" D ").pattern("  D").unlockedBy("has_item", ModRecipesGenerator.has((ItemLike)((ItemLike)ItemRegistry.CORRUPTED_VESSEL.get()))).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)"abyss_diver_reverse"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)ItemRegistry.RADIANT_STAFF.get())).define(Character.valueOf('D'), (ItemLike)ItemRegistry.DARK_STICK.get()).define(Character.valueOf('V'), (ItemLike)ItemRegistry.PURE_VESSEL.get()).pattern("  V").pattern(" D ").pattern("D  ").unlockedBy("has_item", ModRecipesGenerator.has((ItemLike)((ItemLike)ItemRegistry.PURE_VESSEL.get()))).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)ItemRegistry.RADIANT_STAFF.get())).define(Character.valueOf('D'), (ItemLike)ItemRegistry.DARK_STICK.get()).define(Character.valueOf('V'), (ItemLike)ItemRegistry.PURE_VESSEL.get()).pattern("V  ").pattern(" D ").pattern("  D").unlockedBy("has_item", ModRecipesGenerator.has((ItemLike)((ItemLike)ItemRegistry.PURE_VESSEL.get()))).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)"radiant_staff_reverse"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)ItemRegistry.ABYSSAL_SCYTHE.get()), (int)1).define(Character.valueOf('D'), (ItemLike)ItemRegistry.DARK_STICK.get()).define(Character.valueOf('I'), (ItemLike)ItemRegistry.DEEPINGOTS.get()).pattern("III").pattern("  D").pattern("  D").unlockedBy("has_item", ModRecipesGenerator.has((ItemLike)((ItemLike)ItemRegistry.DEEPINGOTS.get()))).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)ItemRegistry.RADIANT_SPEAR.get())).define(Character.valueOf('R'), (ItemLike)ItemRegistry.RADIANCE_INGOTS.get()).pattern("  R").pattern(" R ").pattern("R  ").unlockedBy("has_item", ModRecipesGenerator.has((ItemLike)((ItemLike)ItemRegistry.RADIANCE_INGOTS.get()))).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ItemRegistry.BLACK_LANTERN.get()), (int)1).define(Character.valueOf('I'), (ItemLike)Items.IRON_NUGGET).define(Character.valueOf('E'), (ItemLike)Items.ECHO_SHARD).define(Character.valueOf('P'), (ItemLike)ItemRegistry.PALE_SHARD.get()).pattern("IEI").pattern("EPE").pattern("IEI").unlockedBy("has_item", ModRecipesGenerator.has((ItemLike)((ItemLike)ItemRegistry.PALE_SHARD.get()))).unlockedBy("has_item", ModRecipesGenerator.has((ItemLike)Items.ECHO_SHARD)).save(recipeOutput);
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.CITRINE_FRAGMENT.get()}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.AMETHYST_SHARD, (float)0.1f, (int)50).unlockedBy("has_item", ModRecipesGenerator.has((ItemLike)((ItemLike)ItemRegistry.CITRINE_FRAGMENT.get()))).save(recipeOutput);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ItemRegistry.CORRUPTED_ESSENCE.get()), (int)9).requires((ItemLike)ItemRegistry.WARDEN_HEART.get()).unlockedBy("has_item", ModRecipesGenerator.has((ItemLike)((ItemLike)ItemRegistry.WARDEN_HEART.get()))).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ItemRegistry.WARDEN_HEART.get()), (int)1).define(Character.valueOf('E'), (ItemLike)ItemRegistry.CORRUPTED_ESSENCE.get()).pattern("EEE").pattern("EEE").pattern("EEE").unlockedBy("has_item", ModRecipesGenerator.has((ItemLike)((ItemLike)ItemRegistry.CORRUPTED_ESSENCE.get()))).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ItemRegistry.CORRUPTED_VESSEL.get()), (int)1).define(Character.valueOf('E'), (ItemLike)ItemRegistry.CORRUPTED_ESSENCE.get()).define(Character.valueOf('G'), (ItemLike)Items.GLASS).define(Character.valueOf('P'), (ItemLike)ItemRegistry.PALE_SHARD.get()).pattern("GPG").pattern("PEP").pattern("GPG").unlockedBy("has_item", ModRecipesGenerator.has((ItemLike)((ItemLike)ItemRegistry.CORRUPTED_ESSENCE.get()))).unlockedBy("has_item", ModRecipesGenerator.has((ItemLike)((ItemLike)ItemRegistry.PALE_SHARD.get()))).save(recipeOutput);
        this.allStoneVariants(recipeOutput, "abyssalite", (Item)ItemRegistry.ABYSSALITE.get(), (Item)ItemRegistry.ABYSSALITE_BRICKS.get(), (Item)ItemRegistry.ABYSSALITE_BRICKS_SLAB.get(), (Item)ItemRegistry.ABYSSALITE_BRICKS_STAIRS.get(), (Item)ItemRegistry.ABYSSALITE_BRICKS_WALL.get(), (Item)ItemRegistry.CHISELED_ABYSSALITE.get());
        this.crackedStoneCrafts(recipeOutput, "cracked_abyssalite", (Item)ItemRegistry.ABYSSALITE_BRICKS.get(), (Item)ItemRegistry.CRACKED_ABYSSALITE_BRICKS.get(), (Item)ItemRegistry.CRACKED_ABYSSALITE_BRICKS_SLAB.get(), (Item)ItemRegistry.CRACKED_ABYSSALITE_BRICKS_STAIR.get(), (Item)ItemRegistry.CRACKED_ABYSSALITE_BRICKS_WALL.get());
        this.allWoodCrafts(recipeOutput, "darktree", (Item)ItemRegistry.DARKTREE_LOG.get(), (Item)ItemRegistry.DARKTREE_PLANKS.get(), (Item)ItemRegistry.STRIPPED_DARKTREE_LOG.get(), (Item)ItemRegistry.DARKTREE_SLAB.get(), (Item)ItemRegistry.DARKTREE_STAIRS.get(), (Item)ItemRegistry.DARKTREE_FENCE.get(), (Item)ItemRegistry.DARKTREE_FENCE_GATE.get(), (Item)ItemRegistry.DARKTREE_DOOR.get(), (Item)ItemRegistry.DARKTREE_TRAPDOOR.get(), (Item)ItemRegistry.DARKTREE_BUTTON.get(), (Item)ItemRegistry.DARKTREE_WOOD.get(), (Item)ItemRegistry.STRIPPED_DARKTREE_WOOD.get(), (Item)ItemRegistry.DARKTREE_BOAT.get(), (Item)ItemRegistry.DARKTREE_CHEST_BOAT.get());
        this.allWoodCrafts(recipeOutput, "whitetree", (Item)ItemRegistry.WHITETREE_LOG.get(), (Item)ItemRegistry.WHITETREE_PLANKS.get(), (Item)ItemRegistry.STRIPPED_WHITETREE_LOG.get(), (Item)ItemRegistry.WHITETREE_SLAB.get(), (Item)ItemRegistry.WHITETREE_STAIRS.get(), (Item)ItemRegistry.WHITETREE_FENCE.get(), (Item)ItemRegistry.WHITETREE_FENCE_GATE.get(), (Item)ItemRegistry.WHITETREE_DOOR.get(), (Item)ItemRegistry.WHITETREE_TRAPDOOR.get(), (Item)ItemRegistry.WHITETREE_BUTTON.get(), (Item)ItemRegistry.WHITETREE_WOOD.get(), (Item)ItemRegistry.STRIPPED_WHITETREE_WOOD.get(), (Item)ItemRegistry.WHITETREE_BOAT.get(), (Item)ItemRegistry.WHITETREE_CHEST_BOAT.get());
        this.craftsForCrystal(recipeOutput, (Item)ItemRegistry.CITRINE.get(), (Item)ItemRegistry.CITRINE_BLOCK.get(), (Item)ItemRegistry.CITRINE_FRAGMENT.get());
        this.craftsForCrystal(recipeOutput, (Item)ItemRegistry.MALACHITE.get(), (Item)ItemRegistry.MALACHITE_BLOCK.get(), (Item)ItemRegistry.MALACHITE_FRAGMENT.get());
        this.craftsForCrystal(recipeOutput, (Item)ItemRegistry.RUBY.get(), (Item)ItemRegistry.RUBY_BLOCK.get(), (Item)ItemRegistry.RUBY_FRAGMENT.get());
        this.craftsForCrystal(recipeOutput, (Item)ItemRegistry.PALE_CRISTAL.get(), (Item)ItemRegistry.PALE_CRISTAL_BLOCK.get(), (Item)ItemRegistry.PALE_SHARD.get());
        this.craftsForCrystal(recipeOutput, (Item)ItemRegistry.ECHO_CRISTAL.get(), (Item)ItemRegistry.ECHO_BLOCK.get(), Items.ECHO_SHARD);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ItemRegistry.DEEPCRISTAL.get()), (int)1).define(Character.valueOf('F'), (ItemLike)ItemRegistry.DEEP_FRAGMENT.get()).pattern(" F ").pattern("FFF").pattern(" F ").unlockedBy("has_item", ModRecipesGenerator.has((ItemLike)((ItemLike)ItemRegistry.DEEP_FRAGMENT.get()))).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ItemRegistry.RADIANCE_CRISTAL.get()), (int)1).define(Character.valueOf('F'), (ItemLike)ItemRegistry.RADIANCE_FRAGMENT.get()).pattern(" F ").pattern("FFF").pattern(" F ").unlockedBy("has_item", ModRecipesGenerator.has((ItemLike)((ItemLike)ItemRegistry.RADIANCE_FRAGMENT.get()))).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ItemRegistry.DARK_STICK.get()), (int)1).define(Character.valueOf('P'), (ItemLike)ItemRegistry.DARKTREE_PLANKS.get()).pattern("P").pattern("P").pattern("P").unlockedBy("has_item", ModRecipesGenerator.has((ItemLike)((ItemLike)ItemRegistry.DARKTREE_LOG.get()))).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ItemRegistry.DEEPBLOCK.get()), (int)1).define(Character.valueOf('I'), (ItemLike)ItemRegistry.DEEPINGOTS.get()).pattern("III").pattern("III").pattern("III").unlockedBy("has_item", ModRecipesGenerator.has((ItemLike)((ItemLike)ItemRegistry.DEEPINGOTS.get()))).save(recipeOutput);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ItemRegistry.DEEPINGOTS.get()), (int)9).requires((ItemLike)ItemRegistry.DEEPBLOCK.get()).unlockedBy("has_item", ModRecipesGenerator.has((ItemLike)((ItemLike)ItemRegistry.DEEPBLOCK.get()))).save(recipeOutput);
        this.smeltAndBlast(recipeOutput, (Item)ItemRegistry.DEEPCRISTAL.get(), (Item)ItemRegistry.DEEPINGOTS.get(), "deepingot", 2.0f, 400);
        this.smeltAndBlast(recipeOutput, (Item)ItemRegistry.RADIANCE_CRISTAL.get(), (Item)ItemRegistry.RADIANCE_INGOTS.get(), "radiance_ingot", 2.0f, 400);
        this.fullArmorCraft(recipeOutput, (Item)ItemRegistry.DEEPINGOTS.get(), (Item)ArmorRegistry.DEEPCRISTAL_HELMET.get(), (Item)ArmorRegistry.DEEPCRISTAL_CHESTPLATE.get(), (Item)ArmorRegistry.DEEPCRISTAL_LEGGINGS.get(), (Item)ArmorRegistry.DEEPCRISTAL_BOOTS.get());
        this.fullArmorCraft(recipeOutput, (Item)ItemRegistry.RADIANCE_INGOTS.get(), (Item)ArmorRegistry.RADIANCE_CRISTAL_HELMET.get(), (Item)ArmorRegistry.RADIANCE_CRISTAL_CHESTPLATE.get(), (Item)ArmorRegistry.RADIANCE_CRISTAL_LEGGINGS.get(), (Item)ArmorRegistry.RADIANCE_CRISTAL_BOOTS.get());
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ItemRegistry.NOCTILURE_TREAT.get())).requires((ItemLike)ItemRegistry.DEEP_FRUIT.get()).requires((ItemLike)Items.SUGAR).requires((ItemLike)ItemRegistry.BLUE_GLOW_BERRIES.get()).unlockedBy("has_item", ModRecipesGenerator.has((ItemLike)((ItemLike)ItemRegistry.DEEP_FRUIT.get()))).unlockedBy("has_item", ModRecipesGenerator.has((ItemLike)((ItemLike)ItemRegistry.BLUE_GLOW_BERRIES.get()))).save(recipeOutput);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)Items.SUGAR).requires((ItemLike)ItemRegistry.DEPTH_BERRIES.get()).unlockedBy("has_item", ModRecipesGenerator.has((ItemLike)((ItemLike)ItemRegistry.DEPTH_BERRIES.get()))).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ItemRegistry.PROTECTOR_HEART.get())).define(Character.valueOf('E'), (ItemLike)ItemRegistry.PURE_ESSENCE.get()).pattern("EEE").pattern("EEE").pattern("EEE").unlockedBy("has_item", ModRecipesGenerator.has((ItemLike)((ItemLike)ItemRegistry.PURE_ESSENCE.get()))).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ItemRegistry.PROTECTOR_INVOKER.get())).define(Character.valueOf('D'), (ItemLike)ItemRegistry.DARK_STICK.get()).define(Character.valueOf('V'), (ItemLike)ItemRegistry.PURE_VESSEL.get()).define(Character.valueOf('P'), (ItemLike)ItemRegistry.WHITETREE_PLANKS.get()).define(Character.valueOf('G'), (ItemLike)Items.GLASS).pattern(" G ").pattern("DVD").pattern(" P ").unlockedBy("has_item", ModRecipesGenerator.has((ItemLike)((ItemLike)ItemRegistry.PURE_VESSEL.get()))).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ItemRegistry.RADIANCE_CATALYST.get())).define(Character.valueOf('C'), (ItemLike)ItemRegistry.RADIANT_CORE.get()).define(Character.valueOf('I'), (ItemLike)Items.IRON_INGOT).define(Character.valueOf('G'), (ItemLike)Items.GLASS).pattern("GIG").pattern("ICI").pattern("GIG").unlockedBy("has_item", ModRecipesGenerator.has((ItemLike)((ItemLike)ItemRegistry.RADIANT_CORE.get()))).unlockedBy("has_item", ModRecipesGenerator.has((ItemLike)((ItemLike)ItemRegistry.RADIANCE_FRAGMENT.get()))).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ItemRegistry.RADIANT_CORE.get())).define(Character.valueOf('F'), (ItemLike)ItemRegistry.RADIANCE_FRAGMENT.get()).define(Character.valueOf('W'), (ItemLike)ItemRegistry.WHITE_SEED.get()).pattern("FFF").pattern("FWF").pattern("FFF").unlockedBy("has_item", ModRecipesGenerator.has((ItemLike)((ItemLike)ItemRegistry.RADIANCE_FRAGMENT.get()))).unlockedBy("has_item", ModRecipesGenerator.has((ItemLike)((ItemLike)ItemRegistry.WHITE_SEED.get()))).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)ItemRegistry.WHISTLE.get()), (int)1).define(Character.valueOf('S'), (ItemLike)ItemRegistry.DARKTREE_SLAB.get()).pattern("SSS").pattern("SS ").unlockedBy("has_item", ModRecipesGenerator.has((ItemLike)((ItemLike)ItemRegistry.DARKTREE_SLAB.get()))).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ItemRegistry.WIND_WHISPERER.get())).define(Character.valueOf('L'), (ItemLike)ItemRegistry.DARKTREE_LEAVES.get()).define(Character.valueOf('C'), (ItemLike)ItemRegistry.CORRUPTED_VESSEL.get()).pattern("LLL").pattern("LCL").pattern("LLL").unlockedBy("has_item", ModRecipesGenerator.has((ItemLike)((ItemLike)ItemRegistry.CORRUPTED_VESSEL.get()))).save(recipeOutput);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ItemRegistry.WIND_JOURNAL.get())).requires((ItemLike)ItemRegistry.NOCTILURE_FEATHER.get()).requires((ItemLike)Items.BOOK).requires((ItemLike)ItemRegistry.DARKTREE_LEAVES.get()).unlockedBy("has_item", ModRecipesGenerator.has((ItemLike)((ItemLike)ItemRegistry.NOCTILURE_FEATHER.get()))).unlockedBy("has_item", ModRecipesGenerator.has((ItemLike)((ItemLike)ItemRegistry.DARKTREE_LEAVES.get()))).save(recipeOutput);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ItemRegistry.CORRUPTED_ABYSSALITE.get()), (int)2).requires((ItemLike)ItemRegistry.ABYSSALITE.get()).requires((ItemLike)Items.SCULK).unlockedBy("has_item", ModRecipesGenerator.has((ItemLike)((ItemLike)ItemRegistry.ABYSSALITE.get()))).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)ItemRegistry.CRYSTAL_RESONATOR.get())).define(Character.valueOf('A'), (ItemLike)Items.AMETHYST_SHARD).define(Character.valueOf('C'), (ItemLike)Items.COMPASS).pattern(" A ").pattern("ACA").pattern(" A ").unlockedBy("has_item", ModRecipesGenerator.has((ItemLike)Items.COMPASS)).unlockedBy("has_item", ModRecipesGenerator.has((ItemLike)Items.AMETHYST_SHARD)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)((ItemLike)ItemRegistry.SONIC_BLASTER.get())).define(Character.valueOf('R'), (ItemLike)Items.REDSTONE).define(Character.valueOf('P'), (ItemLike)ItemRegistry.PALE_SHARD.get()).define(Character.valueOf('A'), (ItemLike)ItemRegistry.ABYSSALITE.get()).pattern("AAA").pattern("PRP").pattern("AAA").unlockedBy("has_item", ModRecipesGenerator.has((ItemLike)((ItemLike)ItemRegistry.SONIC_BLASTER.get()))).save(recipeOutput);
    }

    protected void allStoneVariants(@NotNull RecipeOutput recipeOutput, String name, @NotNull Item block, @NotNull Item brick, @NotNull Item slab, @Nullable Item stairs, @Nullable Item wall, @Nullable Item chiseled) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)brick, (int)4).define(Character.valueOf('B'), (ItemLike)block).pattern("BB").pattern("BB").unlockedBy("has_item", ModRecipesGenerator.has((ItemLike)block)).save(recipeOutput);
        SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{block}), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)brick, (int)1).unlockedBy("has_item", ModRecipesGenerator.has((ItemLike)block)).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)(name + "_brick_stone_cutting")));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)slab, (int)6).define(Character.valueOf('B'), (ItemLike)brick).pattern("BBB").unlockedBy("has_item", ModRecipesGenerator.has((ItemLike)block)).save(recipeOutput);
        SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{block}), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)slab, (int)2).unlockedBy("has_item", ModRecipesGenerator.has((ItemLike)block)).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)(name + "_slab_stone_cutting")));
        SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{brick}), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)slab, (int)2).unlockedBy("has_item", ModRecipesGenerator.has((ItemLike)block)).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)(name + "_slab_from_brick_stone_cutting")));
        if (stairs != null) {
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)stairs, (int)4).define(Character.valueOf('B'), (ItemLike)brick).pattern("  B").pattern(" BB").pattern("BBB").unlockedBy("has_item", ModRecipesGenerator.has((ItemLike)block)).save(recipeOutput);
            SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{block}), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)stairs, (int)1).unlockedBy("has_item", ModRecipesGenerator.has((ItemLike)block)).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)(name + "_stairs_stone_cutting")));
            SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{brick}), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)stairs, (int)1).unlockedBy("has_item", ModRecipesGenerator.has((ItemLike)block)).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)(name + "_stairs_from_brick_stone_cutting")));
        }
        if (wall != null) {
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)wall, (int)6).define(Character.valueOf('B'), (ItemLike)brick).pattern("BBB").pattern("BBB").unlockedBy("has_item", ModRecipesGenerator.has((ItemLike)block)).save(recipeOutput);
            SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{block}), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)wall, (int)1).unlockedBy("has_item", ModRecipesGenerator.has((ItemLike)block)).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)(name + "_wall_stone_cutting")));
            SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{brick}), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)wall, (int)1).unlockedBy("has_item", ModRecipesGenerator.has((ItemLike)block)).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)(name + "_wall_from_brick_stone_cutting")));
        }
        if (chiseled != null) {
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)chiseled, (int)1).define(Character.valueOf('B'), (ItemLike)slab).pattern("B").pattern("B").unlockedBy("has_item", ModRecipesGenerator.has((ItemLike)block)).save(recipeOutput);
            SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{block}), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)chiseled, (int)1).unlockedBy("has_item", ModRecipesGenerator.has((ItemLike)block)).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)("chiseled_" + name + "_stone_cutting")));
            SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{brick}), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)chiseled, (int)1).unlockedBy("has_item", ModRecipesGenerator.has((ItemLike)block)).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)("chiseled_" + name + "_from_brick_stone_cutting")));
        }
    }

    protected void allWoodCrafts(@NotNull RecipeOutput recipeOutput, String name, @NotNull Item log, @NotNull Item plank, @NotNull Item stripedLog, @Nullable Item slab, @Nullable Item stairs, @Nullable Item fence, @Nullable Item fenceGate, @Nullable Item door, @Nullable Item trapdoor, @Nullable Item button, @Nullable Item wood, @Nullable Item strippedWood, @Nullable Item boat, @Nullable Item chestboat) {
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)plank, (int)4).requires((ItemLike)log).unlockedBy("has_item", ModRecipesGenerator.has((ItemLike)log)).save(recipeOutput);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)plank, (int)4).requires((ItemLike)stripedLog).unlockedBy("has_item", ModRecipesGenerator.has((ItemLike)log)).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)(name + "_plank_from_striped_log")));
        if (slab != null) {
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)slab, (int)6).define(Character.valueOf('P'), (ItemLike)plank).pattern("PPP").unlockedBy("has_item", ModRecipesGenerator.has((ItemLike)plank)).save(recipeOutput);
        }
        if (stairs != null) {
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)stairs, (int)4).define(Character.valueOf('P'), (ItemLike)plank).pattern("  P").pattern(" PP").pattern("PPP").unlockedBy("has_item", ModRecipesGenerator.has((ItemLike)plank)).save(recipeOutput);
        }
        if (fence != null) {
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)fence, (int)3).define(Character.valueOf('P'), (ItemLike)plank).define(Character.valueOf('S'), (ItemLike)Items.STICK).pattern("PSP").pattern("PSP").unlockedBy("has_item", ModRecipesGenerator.has((ItemLike)plank)).save(recipeOutput);
        }
        if (fenceGate != null) {
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)fenceGate, (int)3).define(Character.valueOf('P'), (ItemLike)plank).define(Character.valueOf('S'), (ItemLike)Items.STICK).pattern("SPS").pattern("SPS").unlockedBy("has_item", ModRecipesGenerator.has((ItemLike)plank)).save(recipeOutput);
        }
        if (door != null) {
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)door, (int)3).define(Character.valueOf('P'), (ItemLike)plank).pattern("PP").pattern("PP").pattern("PP").unlockedBy("has_item", ModRecipesGenerator.has((ItemLike)plank)).save(recipeOutput);
        }
        if (trapdoor != null) {
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)trapdoor, (int)2).define(Character.valueOf('P'), (ItemLike)plank).pattern("PPP").pattern("PPP").unlockedBy("has_item", ModRecipesGenerator.has((ItemLike)plank)).save(recipeOutput);
        }
        if (button != null) {
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)button, (int)1).define(Character.valueOf('P'), (ItemLike)plank).pattern("P").unlockedBy("has_item", ModRecipesGenerator.has((ItemLike)plank)).save(recipeOutput);
        }
        if (wood != null) {
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)wood, (int)1).define(Character.valueOf('P'), (ItemLike)log).pattern("PP").pattern("PP").unlockedBy("has_item", ModRecipesGenerator.has((ItemLike)log)).save(recipeOutput);
        }
        if (strippedWood != null) {
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)strippedWood, (int)1).define(Character.valueOf('P'), (ItemLike)stripedLog).pattern("PP").pattern("PP").unlockedBy("has_item", ModRecipesGenerator.has((ItemLike)log)).save(recipeOutput);
        }
        if (boat != null) {
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TRANSPORTATION, (ItemLike)boat, (int)1).define(Character.valueOf('P'), (ItemLike)plank).pattern("P P").pattern("PPP").unlockedBy("has_item", ModRecipesGenerator.has((ItemLike)plank)).save(recipeOutput);
        }
        if (chestboat != null && boat != null) {
            ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.TRANSPORTATION, (ItemLike)chestboat, (int)1).requires((ItemLike)boat).requires((ItemLike)Items.CHEST).unlockedBy("has_item", ModRecipesGenerator.has((ItemLike)boat)).save(recipeOutput);
        }
    }

    protected void craftsForCrystal(@NotNull RecipeOutput recipeOutput, @NotNull Item crystal, @NotNull Item block, @NotNull Item shard) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)block, (int)1).define(Character.valueOf('S'), (ItemLike)shard).pattern("SSS").pattern("SSS").pattern("SSS").unlockedBy("has_item", ModRecipesGenerator.has((ItemLike)crystal)).unlockedBy("has_item", ModRecipesGenerator.has((ItemLike)shard)).unlockedBy("has_item", ModRecipesGenerator.has((ItemLike)block)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)crystal, (int)1).define(Character.valueOf('S'), (ItemLike)shard).pattern(" S ").pattern("SSS").pattern(" S ").unlockedBy("has_item", ModRecipesGenerator.has((ItemLike)crystal)).unlockedBy("has_item", ModRecipesGenerator.has((ItemLike)shard)).unlockedBy("has_item", ModRecipesGenerator.has((ItemLike)block)).save(recipeOutput);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)shard, (int)9).requires((ItemLike)block).unlockedBy("has_item", ModRecipesGenerator.has((ItemLike)crystal)).unlockedBy("has_item", ModRecipesGenerator.has((ItemLike)shard)).unlockedBy("has_item", ModRecipesGenerator.has((ItemLike)block)).save(recipeOutput);
    }

    protected void crackedStoneCrafts(@NotNull RecipeOutput recipeOutput, String name, @NotNull Item block, @NotNull Item cracked, @Nullable Item crackedSlab, @Nullable Item crackedStair, @Nullable Item crackedWall) {
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{block}), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)cracked, (float)0.0f, (int)100).unlockedBy("has_item", ModRecipesGenerator.has((ItemLike)block)).save(recipeOutput);
        if (crackedSlab != null) {
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)crackedSlab, (int)6).define(Character.valueOf('C'), (ItemLike)cracked).pattern("CCC").unlockedBy("has_item", ModRecipesGenerator.has((ItemLike)cracked)).save(recipeOutput);
            SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{cracked}), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)crackedSlab, (int)2).unlockedBy("has_item", ModRecipesGenerator.has((ItemLike)block)).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)(name + "_slab_stone_cutting")));
        }
        if (crackedStair != null) {
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)crackedStair, (int)4).define(Character.valueOf('C'), (ItemLike)cracked).pattern("  C").pattern(" CC").pattern("CCC").unlockedBy("has_item", ModRecipesGenerator.has((ItemLike)cracked)).save(recipeOutput);
            SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{cracked}), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)crackedStair, (int)1).unlockedBy("has_item", ModRecipesGenerator.has((ItemLike)block)).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)(name + "_stairs_stone_cutting")));
        }
        if (crackedWall != null) {
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)crackedWall, (int)6).define(Character.valueOf('C'), (ItemLike)cracked).pattern("CCC").pattern("CCC").unlockedBy("has_item", ModRecipesGenerator.has((ItemLike)cracked)).save(recipeOutput);
            SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{cracked}), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)crackedWall, (int)1).unlockedBy("has_item", ModRecipesGenerator.has((ItemLike)block)).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)(name + "_wall_stone_cutting")));
        }
    }

    protected void smeltAndBlast(@NotNull RecipeOutput recipeOutput, @NotNull Item input, @NotNull Item output, String name, float exp, int time) {
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{input}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)output, (float)exp, (int)time).unlockedBy("has_item", ModRecipesGenerator.has((ItemLike)input)).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)(name + "_smelting")));
        SimpleCookingRecipeBuilder.blasting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{input}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)output, (float)exp, (int)(time / 2)).unlockedBy("has_item", ModRecipesGenerator.has((ItemLike)input)).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)(name + "_blasting")));
    }

    protected void fullArmorCraft(@NotNull RecipeOutput recipeOutput, @NotNull Item material, @NotNull Item helmet, @NotNull Item chestplate, @NotNull Item leggings, @NotNull Item boots) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)helmet, (int)1).define(Character.valueOf('M'), (ItemLike)material).pattern("MMM").pattern("M M").unlockedBy("has_item", ModRecipesGenerator.has((ItemLike)material)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)chestplate, (int)1).define(Character.valueOf('M'), (ItemLike)material).pattern("M M").pattern("MMM").pattern("MMM").unlockedBy("has_item", ModRecipesGenerator.has((ItemLike)material)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)leggings, (int)1).define(Character.valueOf('M'), (ItemLike)material).pattern("MMM").pattern("M M").pattern("M M").unlockedBy("has_item", ModRecipesGenerator.has((ItemLike)material)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)boots, (int)1).define(Character.valueOf('M'), (ItemLike)material).pattern("M M").pattern("M M").unlockedBy("has_item", ModRecipesGenerator.has((ItemLike)material)).save(recipeOutput);
    }

    private void buildRadianceCatalystRecipes(RecipeOutput recipeOutput) {
        RadianceCatalystRecipeBuilder.catalyst(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.CORRUPTED_VESSEL.get()}), new ItemStack((ItemLike)ItemRegistry.PURE_VESSEL.get()), 100).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)"pure_vessel_catalyst"));
        RadianceCatalystRecipeBuilder.catalyst(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.CORRUPTED_ESSENCE.get()}), new ItemStack((ItemLike)ItemRegistry.PURE_ESSENCE.get()), 100).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)"pure_essence_catalyst"));
        RadianceCatalystRecipeBuilder.catalyst(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.WARDEN_HEART.get()}), new ItemStack((ItemLike)ItemRegistry.PROTECTOR_HEART.get()), 900).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)"protector_heart_catalyst"));
        RadianceCatalystRecipeBuilder.catalyst(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.DYING_PROTECTOR_HEART.get()}), new ItemStack((ItemLike)ItemRegistry.PROTECTOR_HEART.get()), 600).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)"protector_heart_from_dying_catalyst"));
    }

    public static Criterion<?> hasItem(ItemLike item) {
        return ModRecipesGenerator.has((ItemLike)item);
    }
}

